/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.index;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.neo4j.impl.batchinsert.BatchInserter;
import org.neo4j.impl.util.ArrayMap;
import org.neo4j.util.index.LuceneIndexBatchInserter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexBatchInserterImpl
implements LuceneIndexBatchInserter {
    private final String storeDir;
    private final ArrayMap<String, IndexWriter> indexWriters = new ArrayMap(6, false, false);
    private final Analyzer fieldAnalyzer = new Analyzer(){

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return new LowerCaseFilter((TokenStream)new WhitespaceTokenizer(reader));
        }
    };
    private IndexSearcher cachedIndexSearcher = null;
    private String cachedForKey = null;

    public LuceneIndexBatchInserterImpl(BatchInserter neo) {
        this.storeDir = this.fixPath(neo.getStore() + "/lucene");
    }

    private String fixPath(String dir) {
        String store = dir;
        String fileSeparator = System.getProperty("file.separator");
        if ("\\".equals(fileSeparator)) {
            store = dir.replace('/', '\\');
        } else if ("/".equals(fileSeparator)) {
            store = dir.replace('\\', '/');
        }
        File directories = new File(dir);
        if (!directories.exists() && !directories.mkdirs()) {
            throw new RuntimeException("Unable to create directory path[" + this.storeDir + "] for Lucene index store.");
        }
        return store;
    }

    @Override
    public void index(long node, String key, Object value) {
        IndexWriter writer = (IndexWriter)this.indexWriters.get((Object)key);
        if (writer == null) {
            try {
                FSDirectory dir = FSDirectory.getDirectory((File)new File(this.storeDir + "/" + key));
                writer = new IndexWriter((Directory)dir, this.fieldAnalyzer, IndexWriter.MaxFieldLength.UNLIMITED);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.indexWriters.put((Object)key, (Object)writer);
        }
        Document document = new Document();
        document.add((Fieldable)new Field("id", String.valueOf(node), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new Field("index", value.toString(), Field.Store.NO, Field.Index.NOT_ANALYZED));
        try {
            writer.addDocument(document);
            if (key.equals(this.cachedForKey) && this.cachedIndexSearcher != null) {
                this.cachedIndexSearcher.close();
                this.cachedIndexSearcher = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void shutdown() {
        for (IndexWriter writer : this.indexWriters.values()) {
            try {
                writer.close();
            }
            catch (CorruptIndexException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Iterable<Long> getNodes(String key, Object value) {
        IndexWriter writer = (IndexWriter)this.indexWriters.remove((Object)key);
        if (writer != null) {
            try {
                writer.close();
            }
            catch (CorruptIndexException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        HashSet<Long> nodeSet = new HashSet<Long>();
        if (!key.equals(this.cachedForKey) || this.cachedIndexSearcher == null) {
            try {
                FSDirectory dir = FSDirectory.getDirectory((File)new File(this.storeDir + "/" + key));
                this.cachedForKey = key;
                if (dir.list().length == 0) {
                    return Collections.EMPTY_SET;
                }
                this.cachedIndexSearcher = new IndexSearcher((Directory)dir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        TermQuery query = new TermQuery(new Term("index", value.toString()));
        try {
            Hits hits = this.cachedIndexSearcher.search((Query)query);
            for (int i = 0; i < hits.length(); ++i) {
                Document document = hits.doc(i);
                long id = Long.parseLong(document.getField("id").stringValue());
                nodeSet.add(id);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return nodeSet;
    }

    @Override
    public void optimize() {
        try {
            ArrayList<IndexWriter> writers = new ArrayList<IndexWriter>();
            for (IndexWriter writer : this.indexWriters.values()) {
                writer.optimize(true);
                writers.add(writer);
            }
            this.indexWriters.clear();
            for (IndexWriter writer : writers) {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getSingleNode(String key, Object value) {
        long node;
        Iterator<Long> nodes = this.getNodes(key, value).iterator();
        long l = node = nodes.hasNext() ? nodes.next() : -1L;
        while (nodes.hasNext()) {
            if (nodes.next().equals(node)) continue;
            throw new RuntimeException("More than one node for " + key + "=" + value);
        }
        return node;
    }
}

