/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.neo4j.api.core.EmbeddedNeo;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.api.core.NotInTransactionException;
import org.neo4j.impl.cache.LruCache;
import org.neo4j.impl.transaction.LockManager;
import org.neo4j.impl.transaction.TxModule;
import org.neo4j.impl.util.ArrayMap;
import org.neo4j.util.index.GenericIndexService;
import org.neo4j.util.index.LuceneDataSource;
import org.neo4j.util.index.LuceneTransaction;
import org.neo4j.util.index.LuceneXaConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexService
extends GenericIndexService {
    protected static final String DOC_ID_KEY = "id";
    protected static final String DOC_INDEX_KEY = "index";
    private final TransactionManager txManager;
    private final ConnectionBroker broker;
    private final LuceneDataSource xaDs;
    private Sort sorting;

    public LuceneIndexService(NeoService neo) {
        super(neo);
        EmbeddedNeo embeddedNeo = (EmbeddedNeo)neo;
        String luceneDirectory = embeddedNeo.getConfig().getTxModule().getTxLogDirectory() + "/" + this.getDirName();
        TxModule txModule = embeddedNeo.getConfig().getTxModule();
        this.txManager = txModule.getTxManager();
        byte[] resourceId = this.getXaResourceId();
        Map<Object, Object> params = this.getDefaultParams();
        params.put("dir", luceneDirectory);
        params.put(LockManager.class, embeddedNeo.getConfig().getLockManager());
        this.xaDs = (LuceneDataSource)txModule.registerDataSource(this.getDirName(), this.getDataSourceClass().getName(), resourceId, params, true);
        this.broker = new ConnectionBroker(this.txManager, this.xaDs);
        this.xaDs.setIndexService(this);
    }

    public void rotate() throws IOException {
        this.xaDs.rotateLogicalLog();
    }

    protected Class<? extends LuceneDataSource> getDataSourceClass() {
        return LuceneDataSource.class;
    }

    protected String getDirName() {
        return "lucene";
    }

    protected byte[] getXaResourceId() {
        return "162373".getBytes();
    }

    protected Field.Index getIndexStrategy() {
        return Field.Index.NOT_ANALYZED;
    }

    private Map<Object, Object> getDefaultParams() {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put(LuceneIndexService.class, this);
        return params;
    }

    public void enableCache(String key, int maxNumberOfCachedEntries) {
        this.xaDs.enableCache(key, maxNumberOfCachedEntries);
    }

    @Override
    protected void indexThisTx(Node node, String key, Object value) {
        this.getConnection().index(node, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Node> getNodes(String key, Object value) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        LuceneTransaction luceneTx = this.getConnection().getLuceneTx();
        Set<Object> addedNodes = Collections.emptySet();
        Set<Long> deletedNodes = Collections.emptySet();
        if (luceneTx != null) {
            addedNodes = luceneTx.getNodesFor(key, value);
            Iterator<Object> i$ = addedNodes.iterator();
            while (i$.hasNext()) {
                long id = (Long)i$.next();
                nodes.add(this.getNeo().getNodeById(id));
            }
            deletedNodes = luceneTx.getDeletedNodesFor(key, value);
        }
        this.xaDs.getReadLock();
        try {
            IndexSearcher searcher = this.xaDs.getIndexSearcher(key);
            if (searcher != null) {
                Iterable cachedNodes;
                LruCache<String, Iterable<Long>> cachedNodesMap = this.xaDs.getFromCache(key);
                boolean foundInCache = false;
                String valueAsString = value.toString();
                if (cachedNodesMap != null && (cachedNodes = (Iterable)cachedNodesMap.get((Object)valueAsString)) != null) {
                    foundInCache = true;
                    for (Long cachedNodeId : cachedNodes) {
                        nodes.add(this.getNeo().getNodeById(cachedNodeId.longValue()));
                    }
                }
                if (!foundInCache) {
                    Iterable<Node> readNodes = this.searchForNodes(key, value, deletedNodes);
                    ArrayList<Long> readNodeIds = new ArrayList<Long>();
                    for (Node readNode : readNodes) {
                        nodes.add(readNode);
                        readNodeIds.add(readNode.getId());
                    }
                    if (cachedNodesMap != null) {
                        cachedNodesMap.put((Object)valueAsString, readNodeIds);
                    }
                }
            }
        }
        finally {
            this.xaDs.releaseReadLock();
        }
        return nodes;
    }

    public void setSorting(Sort sortingOrNullForNone) {
        this.sorting = sortingOrNullForNone;
    }

    protected Query formQuery(String key, Object value) {
        return new TermQuery(new Term(DOC_INDEX_KEY, value.toString()));
    }

    private Iterable<Node> searchForNodes(String key, Object value, Set<Long> deletedNodes) {
        Query query = this.formQuery(key, value);
        this.xaDs.getReadLock();
        try {
            IndexSearcher searcher = this.xaDs.getIndexSearcher(key);
            ArrayList<Node> nodes = new ArrayList<Node>();
            Hits hits = this.sorting != null ? searcher.search(query, this.sorting) : searcher.search(query);
            for (int i = 0; i < hits.length(); ++i) {
                Document document = hits.doc(i);
                try {
                    long id = Long.parseLong(document.getField(DOC_ID_KEY).stringValue());
                    if (deletedNodes.contains(id)) continue;
                    nodes.add(this.getNeo().getNodeById(id));
                    continue;
                }
                catch (NotFoundException e) {
                    // empty catch block
                }
            }
            ArrayList<Node> arrayList = nodes;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to search for " + key + "," + value, e);
        }
        finally {
            this.xaDs.releaseReadLock();
        }
    }

    @Override
    public Node getSingleNode(String key, Object value) {
        Node node;
        Iterator<Node> nodes = this.getNodes(key, value).iterator();
        Node node2 = node = nodes.hasNext() ? nodes.next() : null;
        while (nodes.hasNext()) {
            if (nodes.next().equals(node)) continue;
            throw new RuntimeException("More than one node for " + key + "=" + value);
        }
        return node;
    }

    @Override
    protected void removeIndexThisTx(Node node, String key, Object value) {
        this.getConnection().removeIndex(node, key, value);
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        EmbeddedNeo embeddedNeo = (EmbeddedNeo)this.getNeo();
        TxModule txModule = embeddedNeo.getConfig().getTxModule();
        if (txModule.getXaDataSourceManager().hasDataSource(this.getDirName())) {
            txModule.getXaDataSourceManager().unregisterDataSource(this.getDirName());
        }
        this.xaDs.close();
    }

    LuceneXaConnection getConnection() {
        return this.broker.acquireResourceConnection();
    }

    private static class ConnectionBroker {
        private final ArrayMap<Transaction, LuceneXaConnection> txConnectionMap = new ArrayMap(5, true, true);
        private final TransactionManager transactionManager;
        private final LuceneDataSource xaDs;

        ConnectionBroker(TransactionManager transactionManager, LuceneDataSource xaDs) {
            this.transactionManager = transactionManager;
            this.xaDs = xaDs;
        }

        LuceneXaConnection acquireResourceConnection() {
            LuceneXaConnection con = null;
            Transaction tx = this.getCurrentTransaction();
            con = (LuceneXaConnection)((Object)this.txConnectionMap.get((Object)tx));
            if (con == null) {
                try {
                    con = (LuceneXaConnection)this.xaDs.getXaConnection();
                    if (!tx.enlistResource(con.getXaResource())) {
                        throw new RuntimeException("Unable to enlist '" + con.getXaResource() + "' in " + tx);
                    }
                    tx.registerSynchronization((Synchronization)new TxCommitHook(tx));
                    this.txConnectionMap.put((Object)tx, (Object)con);
                }
                catch (RollbackException re) {
                    String msg = "The transaction is marked for rollback only.";
                    throw new RuntimeException(msg, re);
                }
                catch (SystemException se) {
                    String msg = "TM encountered an unexpected error condition.";
                    throw new RuntimeException(msg, se);
                }
            }
            return con;
        }

        void releaseResourceConnectionsForTransaction(Transaction tx) throws NotInTransactionException {
            LuceneXaConnection con = (LuceneXaConnection)((Object)this.txConnectionMap.remove((Object)tx));
            if (con != null) {
                con.destroy();
            }
        }

        void delistResourcesForTransaction() throws NotInTransactionException {
            Transaction tx = this.getCurrentTransaction();
            LuceneXaConnection con = (LuceneXaConnection)((Object)this.txConnectionMap.get((Object)tx));
            if (con != null) {
                try {
                    tx.delistResource(con.getXaResource(), 0x4000000);
                }
                catch (IllegalStateException e) {
                    throw new RuntimeException("Unable to delist lucene resource from tx", e);
                }
                catch (SystemException e) {
                    throw new RuntimeException("Unable to delist lucene resource from tx", e);
                }
            }
        }

        private Transaction getCurrentTransaction() throws NotInTransactionException {
            try {
                Transaction tx = this.transactionManager.getTransaction();
                if (tx == null) {
                    throw new NotInTransactionException("No transaction found for current thread");
                }
                return tx;
            }
            catch (SystemException se) {
                throw new NotInTransactionException("Error fetching transaction for current thread", (Throwable)se);
            }
        }

        private class TxCommitHook
        implements Synchronization {
            private final Transaction tx;

            TxCommitHook(Transaction tx) {
                this.tx = tx;
            }

            public void afterCompletion(int param) {
                ConnectionBroker.this.releaseResourceConnectionsForTransaction(this.tx);
            }

            public void beforeCompletion() {
                ConnectionBroker.this.delistResourcesForTransaction();
            }
        }
    }
}

