/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.neo4j.api.core.Node;
import org.neo4j.impl.transaction.xaframework.XaCommand;
import org.neo4j.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.impl.transaction.xaframework.XaTransaction;
import org.neo4j.util.index.LuceneCommand;
import org.neo4j.util.index.LuceneDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LuceneTransaction
extends XaTransaction {
    private final Map<String, Map<Object, Set<Long>>> txIndexed = new HashMap<String, Map<Object, Set<Long>>>();
    private final Map<String, Map<Object, Set<Long>>> txRemoved = new HashMap<String, Map<Object, Set<Long>>>();
    private final LuceneDataSource luceneDs;
    private final Map<String, List<LuceneCommand.AddCommand>> addCommandMap = new HashMap<String, List<LuceneCommand.AddCommand>>();
    private final Map<String, List<LuceneCommand.RemoveCommand>> removeCommandMap = new HashMap<String, List<LuceneCommand.RemoveCommand>>();

    LuceneTransaction(int identifier, XaLogicalLog xaLog, LuceneDataSource luceneDs) {
        super(identifier, xaLog);
        this.luceneDs = luceneDs;
    }

    void index(Node node, String key, Object value) {
        this.insert(node, key, value, this.txRemoved, this.txIndexed);
    }

    void removeIndex(Node node, String key, Object value) {
        this.insert(node, key, value, this.txIndexed, this.txRemoved);
    }

    private void insert(Node node, String key, Object value, Map<String, Map<Object, Set<Long>>> toRemoveFrom, Map<String, Map<Object, Set<Long>>> toInsertInto) {
        Set<Long> nodeIds;
        this.delFromIndex(node, key, value, toRemoveFrom);
        Map<Object, Set<Long>> keyIndex = toInsertInto.get(key);
        if (keyIndex == null) {
            keyIndex = new HashMap<Object, Set<Long>>();
            toInsertInto.put(key, keyIndex);
        }
        if ((nodeIds = keyIndex.get(value)) == null) {
            nodeIds = new HashSet<Long>();
        }
        nodeIds.add(node.getId());
        keyIndex.put(value, nodeIds);
    }

    private boolean delFromIndex(Node node, String key, Object value, Map<String, Map<Object, Set<Long>>> map) {
        Map<Object, Set<Long>> keyIndex = map.get(key);
        if (keyIndex == null) {
            return false;
        }
        Set<Long> nodeIds = keyIndex.get(value);
        if (nodeIds != null) {
            return nodeIds.remove(node.getId());
        }
        return false;
    }

    Set<Long> getDeletedNodesFor(String key, Object value) {
        Set<Long> nodeIds;
        Map<Object, Set<Long>> keyIndex = this.txRemoved.get(key);
        if (keyIndex != null && (nodeIds = keyIndex.get(value)) != null) {
            return nodeIds;
        }
        return Collections.emptySet();
    }

    Set<Long> getNodesFor(String key, Object value) {
        Set<Long> nodeIds;
        Map<Object, Set<Long>> keyIndex = this.txIndexed.get(key);
        if (keyIndex != null && (nodeIds = keyIndex.get(value)) != null) {
            return nodeIds;
        }
        return Collections.emptySet();
    }

    protected LuceneDataSource getDataSource() {
        return this.luceneDs;
    }

    private void indexWriter(IndexWriter writer, long nodeId, String key, Object value) {
        Document document = new Document();
        this.luceneDs.fillDocument(document, nodeId, key, value);
        try {
            writer.addDocument(document);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doAddCommand(XaCommand command) {
        if (command instanceof LuceneCommand.AddCommand) {
            LuceneCommand.AddCommand addCommand = (LuceneCommand.AddCommand)command;
            List<LuceneCommand.AddCommand> list = this.addCommandMap.get(addCommand.getKey());
            if (list == null) {
                list = new ArrayList<LuceneCommand.AddCommand>();
                this.addCommandMap.put(addCommand.getKey(), list);
            }
            list.add(addCommand);
        } else if (command instanceof LuceneCommand.RemoveCommand) {
            LuceneCommand.RemoveCommand removeCommand = (LuceneCommand.RemoveCommand)command;
            List<LuceneCommand.RemoveCommand> list = this.removeCommandMap.get(removeCommand.getKey());
            if (list == null) {
                list = new ArrayList<LuceneCommand.RemoveCommand>();
                this.removeCommandMap.put(removeCommand.getKey(), list);
            }
            list.add(removeCommand);
        } else {
            throw new RuntimeException("Unknown command: " + command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit() {
        this.luceneDs.getWriteLock();
        try {
            List<LuceneCommand> commands;
            for (String key : this.removeCommandMap.keySet()) {
                IndexSearcher searcher = this.luceneDs.getIndexSearcher(key);
                if (searcher != null) {
                    commands = this.removeCommandMap.get(key);
                    for (LuceneCommand cmd : commands) {
                        String value = cmd.getValue();
                        long id = cmd.getNodeId();
                        this.luceneDs.deleteDocumentUsingReader(searcher, id, value);
                        this.luceneDs.invalidateCache(key, value);
                    }
                }
                this.luceneDs.removeIndexSearcher(key);
            }
            for (String key : this.addCommandMap.keySet()) {
                IndexWriter writer = this.luceneDs.getIndexWriter(key);
                commands = this.addCommandMap.get(key);
                for (LuceneCommand cmd : commands) {
                    this.indexWriter(writer, cmd.getNodeId(), key, cmd.getValue());
                    this.luceneDs.invalidateCache(key, cmd.getValue());
                }
                this.luceneDs.removeWriter(key, writer);
                this.luceneDs.removeIndexSearcher(key);
            }
        }
        finally {
            this.luceneDs.releaseWriteLock();
        }
    }

    protected void doPrepare() {
        for (String key : this.txIndexed.keySet()) {
            Map<Object, Set<Long>> addIndex = this.txIndexed.get(key);
            for (Object object : addIndex.keySet()) {
                for (long id : addIndex.get(object)) {
                    this.addCommand(new LuceneCommand.AddCommand(id, key, object.toString()));
                }
            }
        }
        for (String key : this.txRemoved.keySet()) {
            Map<Object, Set<Long>> removeIndex = this.txRemoved.get(key);
            for (Object object : removeIndex.keySet()) {
                for (long id : removeIndex.get(object)) {
                    this.addCommand(new LuceneCommand.RemoveCommand(id, key, object.toString()));
                }
            }
        }
    }

    protected void doRollback() {
        this.addCommandMap.clear();
        this.removeCommandMap.clear();
        this.txIndexed.clear();
        this.txRemoved.clear();
    }

    public boolean isReadOnly() {
        return false;
    }
}

