/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.index;

import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.util.btree.KeyEntry;
import org.neo4j.util.index.AbstractIndex;

public class MultiValueIndex
extends AbstractIndex {
    public MultiValueIndex(String name, Node underlyingNode, NeoService neo) {
        super(name, underlyingNode, neo);
    }

    protected void addOrReplace(KeyEntry entry, long nodeId) {
        Object value = entry.getValue();
        if (value.getClass().isArray()) {
            long[] values = (long[])value;
            long[] newValues = new long[values.length + 1];
            boolean addNewValues = true;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == nodeId) {
                    addNewValues = false;
                    break;
                }
                newValues[i] = values[i];
            }
            if (addNewValues) {
                newValues[newValues.length - 1] = nodeId;
                entry.setValue(newValues);
            }
        } else {
            long currentId = (Long)value;
            if (currentId != nodeId) {
                long[] newValues = new long[]{currentId, nodeId};
                entry.setValue(newValues);
            }
        }
    }

    protected void addOrReplace(Node node, long nodeId) {
        Object value = node.getProperty("index_values");
        if (value.getClass().isArray()) {
            long[] values = (long[])value;
            long[] newValues = new long[values.length + 1];
            boolean addNewValues = true;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == nodeId) {
                    addNewValues = false;
                    break;
                }
                newValues[i] = values[i];
            }
            if (addNewValues) {
                newValues[newValues.length - 1] = nodeId;
                node.setProperty("index_values", (Object)newValues);
            }
        } else {
            long currentId = (Long)value;
            if (currentId != nodeId) {
                long[] newValues = new long[]{currentId, nodeId};
                node.setProperty("index_values", (Object)newValues);
            }
        }
    }

    protected boolean removeAllOrOne(Node node, long nodeId) {
        Object value = node.getProperty("index_values");
        if (value.getClass().isArray()) {
            long[] values = (long[])value;
            if (values.length == 1) {
                return values[0] == nodeId;
            }
            long[] newValues = new long[values.length - 1];
            int j = 0;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == nodeId) continue;
                newValues[j++] = values[i];
            }
            node.setProperty("index_values", (Object)newValues);
            return false;
        }
        long currentId = (Long)value;
        return currentId == nodeId;
    }

    protected boolean removeAllOrOne(KeyEntry entry, long nodeId) {
        Object value = entry.getValue();
        if (value.getClass().isArray()) {
            long[] values = (long[])value;
            if (values.length == 1) {
                return values[0] == nodeId;
            }
            long[] newValues = new long[values.length - 1];
            int j = 0;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == nodeId) continue;
                newValues[j++] = values[i];
            }
            entry.setValue(newValues);
            return false;
        }
        long currentId = (Long)value;
        return currentId == nodeId;
    }

    protected long[] getValues(KeyEntry entry) {
        Object value = entry.getValue();
        if (value.getClass().isArray()) {
            return (long[])value;
        }
        long[] values = new long[]{(Long)value};
        return values;
    }

    protected long[] getValues(Node node) {
        Object value = node.getProperty("index_values");
        if (value.getClass().isArray()) {
            return (long[])value;
        }
        long[] values = new long[]{(Long)value};
        return values;
    }

    protected String getIndexType() {
        return "multi";
    }

    protected long getSingleValue(KeyEntry entry) {
        Object value = entry.getValue();
        if (value.getClass().isArray()) {
            long[] ids = (long[])value;
            if (ids.length > 1) {
                throw new RuntimeException("Multiple values found");
            }
            return ids[0];
        }
        return (Long)value;
    }

    protected long getSingleValue(Node entry) {
        Object value = entry.getProperty("index_values");
        if (value.getClass().isArray()) {
            long[] ids = (long[])value;
            if (ids.length > 1) {
                throw new RuntimeException("Multiple values found");
            }
            return ids[0];
        }
        return (Long)value;
    }
}

