/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.index;

import java.util.Collections;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.impl.util.ArrayMap;
import org.neo4j.util.index.GenericIndexService;
import org.neo4j.util.index.Index;
import org.neo4j.util.index.MultiValueIndex;
import org.neo4j.util.index.SingleValueIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoIndexService
extends GenericIndexService {
    private final Node rootIndexService;
    private final Index keyToIndex;
    private final ArrayMap<String, Index> keyToIndexCache = new ArrayMap(6, true, true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NeoIndexService(NeoService neo) {
        super(neo);
        Transaction tx = neo.beginTx();
        try {
            Node refNode = neo.getReferenceNode();
            Relationship rel = refNode.getSingleRelationship((RelationshipType)RelTypes.INDEX_SERVICE, Direction.OUTGOING);
            if (rel == null) {
                this.rootIndexService = neo.createNode();
                refNode.createRelationshipTo(this.rootIndexService, (RelationshipType)RelTypes.INDEX_SERVICE);
                Node keyIndexRoot = neo.createNode();
                this.rootIndexService.createRelationshipTo(keyIndexRoot, (RelationshipType)RelTypes.KEY_INDEX);
                this.keyToIndex = new SingleValueIndex("keyToIndex", keyIndexRoot, neo);
            } else {
                this.rootIndexService = rel.getEndNode();
                Relationship keyRel = this.rootIndexService.getSingleRelationship((RelationshipType)RelTypes.KEY_INDEX, Direction.OUTGOING);
                if (keyRel == null) {
                    throw new RuntimeException("Unable to locate KeyToIndex relationship in index service.");
                }
                Node keyIndexRoot = keyRel.getEndNode();
                this.keyToIndex = new SingleValueIndex("keyToIndex", keyIndexRoot, neo);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Override
    protected void indexThisTx(Node node, String key, Object value) {
        Index valueIndex = this.getValueIndex(key, true);
        valueIndex.index(node, value);
    }

    Index getValueIndex(String key, boolean create) {
        Index valueIndex = (Index)this.keyToIndexCache.get((Object)key);
        if (valueIndex == null) {
            Node valueIndexNode = this.keyToIndex.getSingleNodeFor(key);
            if (valueIndexNode == null && create) {
                valueIndexNode = this.getNeo().createNode();
                this.keyToIndex.index(valueIndexNode, key);
                this.rootIndexService.createRelationshipTo(valueIndexNode, (RelationshipType)RelTypes.VALUE_INDEX);
                valueIndex = new MultiValueIndex("index_" + key, valueIndexNode, this.getNeo());
                this.keyToIndexCache.put((Object)key, (Object)valueIndex);
            } else if (valueIndexNode != null) {
                valueIndex = new MultiValueIndex("index_" + key, valueIndexNode, this.getNeo());
                this.keyToIndexCache.put((Object)key, (Object)valueIndex);
            }
        }
        return valueIndex;
    }

    @Override
    public Iterable<Node> getNodes(String key, Object value) {
        Index valueIndex = this.getValueIndex(key, false);
        if (valueIndex == null) {
            return Collections.emptyList();
        }
        return valueIndex.getNodesFor(value);
    }

    @Override
    public Node getSingleNode(String key, Object value) {
        Index valueIndex = this.getValueIndex(key, false);
        if (valueIndex == null) {
            return null;
        }
        return valueIndex.getSingleNodeFor(value);
    }

    @Override
    protected void removeIndexThisTx(Node node, String key, Object value) {
        Index valueIndex = this.getValueIndex(key, false);
        if (valueIndex != null) {
            valueIndex.remove(node, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RelTypes implements RelationshipType
    {
        INDEX_SERVICE,
        KEY_INDEX,
        VALUE_INDEX;

    }
}

