/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.index;

import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.util.btree.KeyEntry;
import org.neo4j.util.index.AbstractIndex;

public class SingleValueIndex
extends AbstractIndex {
    public SingleValueIndex(String name, Node underlyingNode, NeoService neo) {
        super(name, underlyingNode, neo);
    }

    protected void addOrReplace(KeyEntry entry, long value) {
        entry.setValue(value);
    }

    protected void addOrReplace(Node entryNode, long value) {
        entryNode.setProperty("index_values", (Object)value);
    }

    protected String getIndexType() {
        return "single";
    }

    protected long getSingleValue(KeyEntry entry) {
        return (Long)entry.getValue();
    }

    protected long getSingleValue(Node entry) {
        return (Long)entry.getProperty("index_values");
    }

    protected long[] getValues(KeyEntry entry) {
        return new long[]{(Long)entry.getValue()};
    }

    protected long[] getValues(Node entry) {
        return new long[]{(Long)entry.getProperty("index_values")};
    }

    protected boolean removeAllOrOne(KeyEntry entry, long value) {
        return true;
    }

    protected boolean removeAllOrOne(Node entry, long value) {
        return true;
    }
}

