/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.sortedtree;

import javax.transaction.Transaction;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.EmbeddedNeo;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.util.btree.BTree;
import org.neo4j.util.sortedtree.NodeEntry;
import org.neo4j.util.sortedtree.SortedTree;

class TreeNode {
    private SortedTree bTree;
    private Node treeNode;

    TreeNode(SortedTree bTree, Node underlyingNode) {
        this.bTree = bTree;
        this.treeNode = underlyingNode;
    }

    Node getUnderlyingNode() {
        return this.treeNode;
    }

    TreeNode getParent() {
        Relationship toParentNode = this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING);
        if (toParentNode != null) {
            Node parentNode = toParentNode.getStartNode();
            Relationship prevEntry = parentNode.getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.INCOMING);
            while (prevEntry != null) {
                parentNode = prevEntry.getStartNode();
                prevEntry = parentNode.getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.INCOMING);
            }
            return new TreeNode(this.bTree, parentNode);
        }
        return null;
    }

    private Node disconnectFromParent() {
        Relationship toParentNode = this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING);
        Node parentNode = toParentNode.getStartNode();
        toParentNode.delete();
        return parentNode;
    }

    private void connectToParent(Node parent) {
        assert (this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING) == null);
        parent.createRelationshipTo(this.treeNode, (RelationshipType)BTree.RelTypes.SUB_TREE);
    }

    void delete() {
        NodeEntry entry;
        if (!this.isRoot()) {
            this.disconnectFromParent();
        }
        if ((entry = this.getFirstEntry()) == null) {
            this.getUnderlyingNode().delete();
            return;
        }
        TreeNode subTree = entry.getBeforeSubTree();
        if (subTree != null) {
            subTree.delete();
        }
        Node lastNode = null;
        while (entry != null) {
            subTree = entry.getAfterSubTree();
            if (subTree != null) {
                subTree.delete();
            }
            NodeEntry nextEntry = entry.getNextKey();
            lastNode = entry.getEndNode();
            entry.getStartNode().delete();
            entry.getUnderlyingRelationship().delete();
            entry = nextEntry;
        }
        if (lastNode != null) {
            lastNode.delete();
        }
    }

    int delete(int commitInterval, int count) {
        NodeEntry entry;
        if (!this.isRoot()) {
            this.disconnectFromParent();
            ++count;
        }
        if ((entry = this.getFirstEntry()) == null) {
            this.getUnderlyingNode().delete();
            return count++;
        }
        TreeNode subTree = entry.getBeforeSubTree();
        if (subTree != null) {
            subTree.delete(commitInterval, count);
        }
        Node lastNode = null;
        while (entry != null) {
            subTree = entry.getAfterSubTree();
            if (subTree != null) {
                subTree.delete(commitInterval, count);
            }
            NodeEntry nextEntry = entry.getNextKey();
            lastNode = entry.getEndNode();
            entry.getStartNode().delete();
            entry.getUnderlyingRelationship().delete();
            ++count;
            entry = nextEntry;
        }
        if (lastNode != null) {
            lastNode.delete();
            ++count;
        }
        if (count >= commitInterval) {
            EmbeddedNeo neo = (EmbeddedNeo)this.bTree.getNeo();
            try {
                Transaction tx = neo.getConfig().getTxModule().getTxManager().getTransaction();
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            neo.beginTx();
            count = 0;
        }
        return count;
    }

    NodeEntry getFirstEntry() {
        Relationship keyEntryRel = this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        assert (this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.INCOMING) == null);
        if (keyEntryRel != null) {
            return new NodeEntry(this, keyEntryRel);
        }
        return null;
    }

    NodeEntry getLastEntry() {
        Relationship keyEntryRel = this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        NodeEntry last = null;
        while (keyEntryRel != null) {
            last = new NodeEntry(this, keyEntryRel);
            keyEntryRel = keyEntryRel.getEndNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        }
        return last;
    }

    private int getEntryCount() {
        int entryCount = 0;
        for (NodeEntry entry = this.getFirstEntry(); entry != null; entry = entry.getNextKey()) {
            ++entryCount;
        }
        return entryCount;
    }

    boolean addEntry(Node theNode, boolean ignoreIfExist) {
        int entryCount = 0;
        for (NodeEntry keyEntry = this.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            Node currentNode = keyEntry.getTheNode();
            if (currentNode.equals(theNode)) {
                if (ignoreIfExist) {
                    return false;
                }
                throw new RuntimeException("Node already exist:" + theNode);
            }
            ++entryCount;
            if (this.bTree.getComparator().compare(theNode, currentNode) < 0) {
                TreeNode subTree = keyEntry.getBeforeSubTree();
                if (subTree != null) {
                    return subTree.addEntry(theNode, ignoreIfExist);
                }
                for (NodeEntry entry = keyEntry.getNextKey(); entry != null; entry = entry.getNextKey()) {
                    ++entryCount;
                }
                Node blankNode = this.bTree.getNeo().createNode();
                this.createEntry(keyEntry.getStartNode(), blankNode, theNode);
                keyEntry.move(this, blankNode, keyEntry.getEndNode());
                assert (++entryCount <= this.bTree.getOrder());
                if (this.bTree.getOrder() == entryCount) {
                    this.moveMiddleUp();
                }
                return true;
            }
            if (keyEntry.getNextKey() != null) continue;
            TreeNode subTree = keyEntry.getAfterSubTree();
            if (subTree != null) {
                return subTree.addEntry(theNode, ignoreIfExist);
            }
            Node blankNode = this.bTree.getNeo().createNode();
            this.createEntry(keyEntry.getEndNode(), blankNode, theNode);
            assert (++entryCount <= this.bTree.getOrder());
            if (this.bTree.getOrder() == entryCount) {
                this.moveMiddleUp();
            }
            return true;
        }
        assert (this.isRoot());
        assert (!this.treeNode.getRelationships(new RelationshipType[]{BTree.RelTypes.SUB_TREE}).iterator().hasNext());
        Node blankNode = this.bTree.getNeo().createNode();
        this.createEntry(this.treeNode, blankNode, theNode);
        return true;
    }

    boolean containsEntry(Node theNode) {
        int entryCount = 0;
        for (NodeEntry keyEntry = this.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            Node currentNode = keyEntry.getTheNode();
            if (currentNode.equals(theNode)) {
                return true;
            }
            ++entryCount;
            if (this.bTree.getComparator().compare(theNode, currentNode) < 0) {
                TreeNode subTree = keyEntry.getBeforeSubTree();
                if (subTree != null) {
                    return subTree.containsEntry(theNode);
                }
                return false;
            }
            if (keyEntry.getNextKey() != null) continue;
            TreeNode subTree = keyEntry.getAfterSubTree();
            if (subTree != null) {
                return subTree.containsEntry(theNode);
            }
            return false;
        }
        return false;
    }

    private NodeEntry createEntry(Node startNode, Node endNode, Node theNode) {
        NodeEntry newEntry = new NodeEntry(this, startNode.createRelationshipTo(endNode, (RelationshipType)BTree.RelTypes.KEY_ENTRY));
        newEntry.setTheNode(theNode);
        return newEntry;
    }

    boolean isRoot() {
        return this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.TREE_ROOT, Direction.INCOMING) != null;
    }

    private NodeEntry insertEntry(Node theNode) {
        for (NodeEntry keyEntry = this.getFirstEntry(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
            Node currentNode = keyEntry.getTheNode();
            assert (!currentNode.equals(theNode));
            if (this.bTree.getComparator().compare(theNode, currentNode) < 0) {
                Node blankNode = this.bTree.getNeo().createNode();
                NodeEntry newEntry = this.createEntry(keyEntry.getStartNode(), blankNode, theNode);
                keyEntry.move(this, blankNode, keyEntry.getEndNode());
                return newEntry;
            }
            if (keyEntry.getNextKey() != null) continue;
            Node blankNode = this.bTree.getNeo().createNode();
            return this.createEntry(keyEntry.getEndNode(), blankNode, theNode);
        }
        Node blankNode = this.bTree.getNeo().createNode();
        return this.createEntry(this.treeNode, blankNode, theNode);
    }

    private void moveMiddleUp() {
        TreeNode parent = this.getParent();
        if (parent == null) {
            assert (this.isRoot());
            parent = new TreeNode(this.bTree, this.bTree.getNeo().createNode());
            this.bTree.makeRoot(parent);
        } else {
            this.disconnectFromParent();
        }
        NodeEntry middleEntry = this.getFirstEntry();
        for (int i = 0; i < this.bTree.getOrder() / 2; ++i) {
            middleEntry = middleEntry.getNextKey();
        }
        TreeNode newTreeToTheRight = new TreeNode(this.bTree, middleEntry.getEndNode());
        NodeEntry movedMiddleEntry = parent.insertEntry(middleEntry.getTheNode());
        middleEntry.getUnderlyingRelationship().delete();
        movedMiddleEntry.getStartNode().createRelationshipTo(this.getUnderlyingNode(), (RelationshipType)BTree.RelTypes.SUB_TREE);
        movedMiddleEntry.getEndNode().createRelationshipTo(newTreeToTheRight.getUnderlyingNode(), (RelationshipType)BTree.RelTypes.SUB_TREE);
        int parentEntryCount = parent.getEntryCount();
        if (parentEntryCount == this.bTree.getOrder()) {
            parent.moveMiddleUp();
        }
        assert (parent.getEntryCount() <= this.bTree.getOrder());
    }

    public boolean removeEntry(Node theNode) {
        NodeEntry entry = null;
        NodeEntry keyEntry = this.getFirstEntry();
        if (keyEntry == null) {
            return false;
        }
        int entryCount = 0;
        while (keyEntry != null) {
            ++entryCount;
            Node currentNode = keyEntry.getTheNode();
            if (currentNode.equals(theNode)) {
                entry = keyEntry;
                for (keyEntry = keyEntry.getNextKey(); keyEntry != null; keyEntry = keyEntry.getNextKey()) {
                    ++entryCount;
                }
                break;
            }
            if (this.bTree.getComparator().compare(theNode, currentNode) < 0) {
                TreeNode subTree = keyEntry.getBeforeSubTree();
                if (subTree != null) {
                    return subTree.removeEntry(theNode);
                }
                return false;
            }
            if (keyEntry.getNextKey() == null) {
                TreeNode subTree = keyEntry.getAfterSubTree();
                if (subTree != null) {
                    return subTree.removeEntry(theNode);
                }
                return false;
            }
            keyEntry = keyEntry.getNextKey();
        }
        assert (entry != null);
        if (entry.isLeaf()) {
            NodeEntry nextEntry = entry.getNextKey();
            if (nextEntry != null) {
                nextEntry.move(this, entry.getStartNode(), nextEntry.getEndNode());
            }
            entry.getEndNode().delete();
            entry.getUnderlyingRelationship().delete();
            if (--entryCount < this.bTree.getOrder() / 2 && !this.isRoot()) {
                this.tryBorrowFromSibling();
            }
        } else {
            NodeEntry successor = entry.getAfterSubTree().getFirstEntry();
            while (!successor.isLeaf()) {
                successor = successor.getBeforeSubTree().getFirstEntry();
            }
            TreeNode leafTree = successor.getTreeNode();
            NodeEntry next = successor.getNextKey();
            next.move(leafTree, successor.getStartNode(), next.getEndNode());
            successor.move(this, entry.getStartNode(), entry.getEndNode());
            entry.getUnderlyingRelationship().delete();
            entryCount = leafTree.getEntryCount();
            if (entryCount < this.bTree.getOrder() / 2 && !leafTree.isRoot()) {
                leafTree.tryBorrowFromSibling();
            }
        }
        return true;
    }

    private void tryBorrowFromSibling() {
        TreeNode leftSibling = this.getLeftSibbling();
        TreeNode rightSibling = this.getRightSibbling();
        if (leftSibling != null && leftSibling.getEntryCount() > this.bTree.getOrder() / 2) {
            this.borrowFromLeftSibling(leftSibling);
        } else if (rightSibling != null && rightSibling.getEntryCount() > this.bTree.getOrder() / 2) {
            this.borrowFromRightSibling(rightSibling);
        } else if (leftSibling != null) {
            this.mergeWithLeftSibling(leftSibling);
        } else if (rightSibling != null) {
            this.mergeWithRightSibling(rightSibling);
        } else {
            throw new RuntimeException();
        }
    }

    private void borrowFromLeftSibling(TreeNode leftSibling) {
        TreeNode parentNode = this.getParent();
        NodeEntry entryToMoveDown = new NodeEntry(parentNode, this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING).getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.INCOMING));
        NodeEntry entryToMoveUp = leftSibling.getLastEntry();
        TreeNode subTree = entryToMoveUp.getAfterSubTree();
        if (subTree != null) {
            subTree.disconnectFromParent();
        }
        entryToMoveUp.getEndNode().delete();
        entryToMoveUp.move(parentNode, entryToMoveDown.getStartNode(), entryToMoveDown.getEndNode());
        Node newStartNode = this.bTree.getNeo().createNode();
        entryToMoveDown.move(this, newStartNode, this.treeNode);
        Node parentToReAttachTo = this.disconnectFromParent();
        this.treeNode = newStartNode;
        this.connectToParent(parentToReAttachTo);
        if (subTree != null) {
            subTree.connectToParent(newStartNode);
        }
    }

    private void borrowFromRightSibling(TreeNode rightSibling) {
        TreeNode parentNode = this.getParent();
        NodeEntry entryToMoveDown = new NodeEntry(parentNode, this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING).getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.OUTGOING));
        NodeEntry entryToMoveUp = rightSibling.getFirstEntry();
        TreeNode subTree = entryToMoveUp.getBeforeSubTree();
        if (subTree != null) {
            subTree.disconnectFromParent();
        }
        Node rightParentToReAttachTo = rightSibling.disconnectFromParent();
        rightSibling.treeNode = entryToMoveUp.getEndNode();
        rightSibling.connectToParent(rightParentToReAttachTo);
        entryToMoveUp.getStartNode().delete();
        entryToMoveUp.move(parentNode, entryToMoveDown.getStartNode(), entryToMoveDown.getEndNode());
        Node newLastNode = this.bTree.getNeo().createNode();
        entryToMoveDown.move(this, this.getLastEntry().getEndNode(), newLastNode);
        if (subTree != null) {
            subTree.connectToParent(newLastNode);
        }
    }

    private void mergeWithLeftSibling(TreeNode leftSibling) {
        int entryCount;
        NodeEntry entry;
        TreeNode subTree;
        TreeNode parentNode = this.getParent();
        NodeEntry entryToMoveDown = new NodeEntry(parentNode, this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING).getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.INCOMING));
        NodeEntry nextParentEntry = entryToMoveDown.getNextKey();
        if (nextParentEntry != null) {
            nextParentEntry.move(parentNode, entryToMoveDown.getStartNode(), nextParentEntry.getEndNode());
        }
        if ((subTree = (entry = this.getFirstEntry()).getBeforeSubTree()) != null) {
            subTree.disconnectFromParent();
        }
        this.disconnectFromParent();
        entryToMoveDown.getEndNode().delete();
        Node blankNode = this.bTree.getNeo().createNode();
        entryToMoveDown.move(leftSibling, leftSibling.getLastEntry().getEndNode(), blankNode);
        entry.getStartNode().delete();
        entry.move(leftSibling, blankNode, entry.getEndNode());
        this.treeNode = leftSibling.treeNode;
        if (subTree != null) {
            subTree.connectToParent(blankNode);
        }
        if ((entryCount = parentNode.getEntryCount()) < this.bTree.getOrder() / 2 && !parentNode.isRoot()) {
            assert (entryCount > 0);
            parentNode.tryBorrowFromSibling();
        } else if (entryCount == 0) {
            assert (parentNode.isRoot());
            this.disconnectFromParent();
            this.bTree.makeRoot(this);
        }
    }

    private void mergeWithRightSibling(TreeNode rightSibling) {
        int entryCount;
        NodeEntry entry;
        TreeNode subTree;
        TreeNode parentNode = this.getParent();
        NodeEntry entryToMoveDown = new NodeEntry(parentNode, this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING).getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.OUTGOING));
        NodeEntry nextInParent = entryToMoveDown.getNextKey();
        if (nextInParent != null) {
            nextInParent.move(parentNode, entryToMoveDown.getStartNode(), nextInParent.getEndNode());
        }
        if ((subTree = (entry = rightSibling.getFirstEntry()).getBeforeSubTree()) != null) {
            subTree.disconnectFromParent();
        }
        rightSibling.disconnectFromParent();
        entryToMoveDown.getEndNode().delete();
        Node blankNode = this.bTree.getNeo().createNode();
        entryToMoveDown.move(this, this.getLastEntry().getEndNode(), blankNode);
        entry.getStartNode().delete();
        entry.move(this, blankNode, entry.getEndNode());
        rightSibling.treeNode = this.treeNode;
        if (subTree != null) {
            subTree.connectToParent(blankNode);
        }
        if ((entryCount = parentNode.getEntryCount()) < this.bTree.getOrder() / 2 && !parentNode.isRoot()) {
            assert (entryCount > 0);
            parentNode.tryBorrowFromSibling();
        } else if (entryCount == 0) {
            assert (parentNode.isRoot());
            this.disconnectFromParent();
            this.bTree.makeRoot(this);
        }
    }

    TreeNode getLeftSibbling() {
        Relationship parent = this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING);
        if (parent == null) {
            return null;
        }
        Relationship prevEntry = parent.getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.INCOMING);
        if (prevEntry == null) {
            return null;
        }
        return new TreeNode(this.getBTree(), prevEntry.getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.OUTGOING).getEndNode());
    }

    TreeNode getRightSibbling() {
        Relationship parent = this.treeNode.getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.INCOMING);
        if (parent == null) {
            return null;
        }
        Relationship nextEntry = parent.getStartNode().getSingleRelationship((RelationshipType)BTree.RelTypes.KEY_ENTRY, Direction.OUTGOING);
        if (nextEntry == null) {
            return null;
        }
        return new TreeNode(this.getBTree(), nextEntry.getEndNode().getSingleRelationship((RelationshipType)BTree.RelTypes.SUB_TREE, Direction.OUTGOING).getEndNode());
    }

    SortedTree getBTree() {
        return this.bTree;
    }
}

