/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.timeline;

import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.ReturnableEvaluator;
import org.neo4j.api.core.StopEvaluator;
import org.neo4j.api.core.Transaction;
import org.neo4j.api.core.TraversalPosition;
import org.neo4j.api.core.Traverser;
import org.neo4j.util.btree.BTree;
import org.neo4j.util.timeline.TimelineIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timeline
implements TimelineIndex {
    private static final String TIMESTAMP = "timestamp";
    private static final String TIMELINE_NAME = "timeline_name";
    private static final String TIMELINE_IS_INDEXED = "timeline_indexed";
    private static final String INDEX_COUNT = "index_count";
    private static final int INDEX_TRIGGER_COUNT = 1000;
    private final Node underlyingNode;
    private boolean useIndexing = false;
    private BTree bTree = null;
    private final NeoService neo;
    private Node firstNode;
    private Node lastNode;
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timeline(String name, Node underlyingNode, boolean indexed, NeoService neo) {
        if (underlyingNode == null || neo == null) {
            throw new IllegalArgumentException("Null parameter underlyingNode=" + underlyingNode + " neo=" + neo);
        }
        this.useIndexing = false;
        this.underlyingNode = underlyingNode;
        this.neo = neo;
        Transaction tx = neo.beginTx();
        try {
            if (underlyingNode.hasProperty(TIMELINE_NAME)) {
                String storedName = (String)underlyingNode.getProperty(TIMELINE_NAME);
                if (name != null && !storedName.equals(name)) {
                    throw new IllegalArgumentException("Name of timeline for node=" + underlyingNode.getId() + "," + storedName + " is not same as passed in name=" + name);
                }
                if (name == null) {
                    underlyingNode.setProperty(TIMELINE_NAME, (Object)name);
                }
                this.name = name;
            } else {
                underlyingNode.setProperty(TIMELINE_NAME, (Object)name);
                this.name = name;
            }
            if (underlyingNode.hasProperty(TIMELINE_IS_INDEXED)) {
                if (!underlyingNode.getProperty(TIMELINE_IS_INDEXED).equals(indexed)) {
                    throw new IllegalArgumentException("indexed=" + indexed + " do not match timeline");
                }
                this.useIndexing = indexed;
            } else {
                underlyingNode.setProperty(TIMELINE_IS_INDEXED, (Object)indexed);
                this.useIndexing = indexed;
            }
            if (this.useIndexing) {
                Relationship bTreeRel = underlyingNode.getSingleRelationship((RelationshipType)BTree.RelTypes.TREE_ROOT, Direction.OUTGOING);
                if (bTreeRel == null) {
                    Node bTreeNode = neo.createNode();
                    bTreeRel = underlyingNode.createRelationshipTo(bTreeNode, (RelationshipType)BTree.RelTypes.TREE_ROOT);
                }
                this.bTree = new BTree(neo, bTreeRel.getEndNode());
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public Timeline(String name, Node underlyingNode, NeoService neo) {
        this(name, underlyingNode, true, neo);
    }

    public Node getUnderlyingNode() {
        return this.underlyingNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getLastNode() {
        if (this.lastNode != null) {
            return this.lastNode;
        }
        Transaction tx = this.neo.beginTx();
        try {
            Relationship rel = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.INCOMING);
            if (rel == null) {
                Node node = null;
                return node;
            }
            this.lastNode = ((Relationship)rel.getStartNode().getRelationships((RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING).iterator().next()).getEndNode();
            tx.success();
            Node node = this.lastNode;
            return node;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getFirstNode() {
        if (this.firstNode != null) {
            return this.firstNode;
        }
        Transaction tx = this.neo.beginTx();
        try {
            Relationship rel = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING);
            if (rel == null) {
                Node node = null;
                return node;
            }
            this.firstNode = ((Relationship)rel.getEndNode().getRelationships((RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING).iterator().next()).getEndNode();
            tx.success();
            Node node = this.firstNode;
            return node;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNode(Node nodeToAdd, long timestamp) {
        if (nodeToAdd == null) {
            throw new IllegalArgumentException("Null node");
        }
        Transaction tx = this.neo.beginTx();
        try {
            for (Relationship rel : nodeToAdd.getRelationships(new RelationshipType[]{RelTypes.TIMELINE_INSTANCE})) {
                if (!rel.getProperty(TIMELINE_NAME, (Object)"").equals(this.name)) continue;
                throw new IllegalArgumentException("Node[" + nodeToAdd.getId() + "] already connected to Timeline[" + this.name + "]");
            }
            Relationship rel = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.INCOMING);
            if (rel == null) {
                Node node = this.createNewTimeNode(timestamp, nodeToAdd);
                this.underlyingNode.createRelationshipTo(node, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
                node.createRelationshipTo(this.underlyingNode, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
                this.firstNode = nodeToAdd;
                this.lastNode = nodeToAdd;
                this.updateNodeAdded(timestamp);
            } else {
                Node previousLast = rel.getStartNode();
                long previousTime = (Long)previousLast.getProperty(TIMESTAMP);
                if (timestamp > previousTime) {
                    Node node = this.createNewTimeNode(timestamp, nodeToAdd);
                    rel.delete();
                    previousLast.createRelationshipTo(node, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
                    node.createRelationshipTo(this.underlyingNode, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
                    this.lastNode = nodeToAdd;
                    this.updateNodeAdded(timestamp);
                } else if (timestamp == previousTime) {
                    previousLast.createRelationshipTo(nodeToAdd, (RelationshipType)RelTypes.TIMELINE_INSTANCE);
                } else {
                    Iterator<Node> itr = this.getAllTimeNodesAfter(timestamp).iterator();
                    assert (itr.hasNext());
                    Node next = itr.next();
                    rel = next.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.INCOMING);
                    assert (rel != null);
                    Node previous = rel.getStartNode();
                    long previousTimestamp = Long.MIN_VALUE;
                    if (!previous.equals(this.underlyingNode)) {
                        previousTimestamp = (Long)previous.getProperty(TIMESTAMP);
                    }
                    if (previousTimestamp == timestamp) {
                        previous.createRelationshipTo(nodeToAdd, (RelationshipType)RelTypes.TIMELINE_INSTANCE);
                        return;
                    }
                    long nextTimestamp = (Long)next.getProperty(TIMESTAMP);
                    if (nextTimestamp == timestamp) {
                        next.createRelationshipTo(nodeToAdd, (RelationshipType)RelTypes.TIMELINE_INSTANCE);
                        return;
                    }
                    assert (previousTimestamp < timestamp);
                    assert (nextTimestamp > timestamp);
                    Node node = this.createNewTimeNode(timestamp, nodeToAdd);
                    rel.delete();
                    previous.createRelationshipTo(node, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
                    node.createRelationshipTo(next, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
                    if (previous.equals(this.underlyingNode)) {
                        this.firstNode = nodeToAdd;
                    }
                    this.updateNodeAdded(timestamp);
                }
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private Node createNewTimeNode(long timestamp, Node nodeToAdd) {
        Node node = this.neo.createNode();
        node.setProperty(TIMESTAMP, (Object)timestamp);
        Relationship instanceRel = node.createRelationshipTo(nodeToAdd, (RelationshipType)RelTypes.TIMELINE_INSTANCE);
        instanceRel.setProperty(TIMELINE_NAME, (Object)this.name);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimestampForNode(Node node) {
        Transaction tx = this.neo.beginTx();
        try {
            Traverser traverser = node.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, new ReturnableEvaluator(){

                public boolean isReturnableNode(TraversalPosition position) {
                    Node currentNode = position.currentNode();
                    return currentNode != null && !currentNode.hasRelationship((RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.INCOMING);
                }
            }, (RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.INCOMING);
            Iterator hits = traverser.iterator();
            Long result = null;
            if (!hits.hasNext()) {
                throw new RuntimeException("No timpestamp found for '" + node + "' maybe it's not in the timeline?");
            }
            Node hit = (Node)hits.next();
            result = (Long)hit.getProperty(TIMESTAMP);
            tx.success();
            long l = result;
            return l;
        }
        finally {
            tx.finish();
        }
    }

    private synchronized void updateNodeAdded(long timestamp) {
        if (!this.useIndexing) {
            return;
        }
        Long nodeId = (Long)this.bTree.getClosestHigherEntry(timestamp);
        if (nodeId == null) {
            int indexCount = (Integer)this.underlyingNode.getProperty(INDEX_COUNT, (Object)0);
            if (++indexCount >= 1000) {
                indexCount = this.createIndex(this.underlyingNode, indexCount);
            }
            this.underlyingNode.setProperty(INDEX_COUNT, (Object)indexCount);
        } else {
            Node indexedNode = this.neo.getNodeById(nodeId.longValue());
            int indexCount = (Integer)indexedNode.getProperty(INDEX_COUNT);
            if (++indexCount >= 1000) {
                indexCount = this.createIndex(indexedNode, indexCount);
            }
            indexedNode.setProperty(INDEX_COUNT, (Object)indexCount);
        }
    }

    private int createIndex(Node startIndexNode, int currentCount) {
        assert (this.useIndexing);
        int newCount = 0;
        int timesToTraverse = 330;
        assert (timesToTraverse > 0);
        Node newIndexedNode = startIndexNode;
        for (int i = 0; i < timesToTraverse; ++i) {
            newIndexedNode = newIndexedNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.INCOMING).getStartNode();
            ++newCount;
            assert (!newIndexedNode.hasProperty(INDEX_COUNT));
        }
        long timestamp = (Long)newIndexedNode.getProperty(TIMESTAMP);
        this.bTree.addEntry(timestamp, newIndexedNode.getId());
        newIndexedNode.setProperty(INDEX_COUNT, (Object)(currentCount - timesToTraverse));
        return newCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode(Node nodeToRemove) {
        if (nodeToRemove == null) {
            throw new IllegalArgumentException("Null parameter.");
        }
        if (nodeToRemove.equals(this.underlyingNode)) {
            throw new IllegalArgumentException("Cannot remove underlying node");
        }
        Transaction tx = this.neo.beginTx();
        try {
            Relationship instanceRel = null;
            for (Relationship rel : nodeToRemove.getRelationships(new RelationshipType[]{RelTypes.TIMELINE_INSTANCE})) {
                if (!rel.getProperty(TIMELINE_NAME, (Object)"").equals(this.name)) continue;
                assert (instanceRel == null);
                instanceRel = rel;
            }
            if (instanceRel == null) {
                throw new IllegalArgumentException("Node[" + nodeToRemove.getId() + "] not added to Timeline[" + this.name + "]");
            }
            Node node = instanceRel.getStartNode();
            instanceRel.delete();
            if (this.firstNode != null && this.firstNode.equals(nodeToRemove)) {
                this.firstNode = null;
            }
            if (this.lastNode != null && this.lastNode.equals(nodeToRemove)) {
                this.lastNode = null;
            }
            if (node.getRelationships(new RelationshipType[]{RelTypes.TIMELINE_INSTANCE}).iterator().hasNext()) {
                return;
            }
            Relationship incoming = node.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.INCOMING);
            if (incoming == null) {
                throw new RuntimeException("No incoming relationship of " + (Object)((Object)RelTypes.TIMELINE_NEXT_ENTRY) + " found");
            }
            Relationship outgoing = node.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING);
            if (outgoing == null) {
                throw new RuntimeException("No outgoing relationship of " + (Object)((Object)RelTypes.TIMELINE_NEXT_ENTRY) + " found");
            }
            Node previous = incoming.getStartNode();
            Node next = outgoing.getEndNode();
            incoming.delete();
            outgoing.delete();
            if (node.hasProperty(INDEX_COUNT)) {
                long nodeId = (Long)this.bTree.removeEntry((Long)node.getProperty(TIMESTAMP));
                assert (nodeId == node.getId());
                int count = (Integer)node.getProperty(INDEX_COUNT);
                --count;
                if (!previous.equals(this.underlyingNode) && !previous.hasProperty(INDEX_COUNT)) {
                    previous.setProperty(INDEX_COUNT, (Object)count);
                    this.bTree.addEntry((Long)previous.getProperty(TIMESTAMP), previous.getId());
                }
            } else {
                long timestamp = (Long)node.getProperty(TIMESTAMP);
                if (this.useIndexing) {
                    Long nodeId = (Long)this.bTree.getClosestHigherEntry(timestamp);
                    if (nodeId != null) {
                        Node indexedNode = this.neo.getNodeById(nodeId.longValue());
                        int count = (Integer)indexedNode.getProperty(INDEX_COUNT);
                        indexedNode.setProperty(INDEX_COUNT, (Object)(--count));
                    } else if (this.underlyingNode.hasProperty(INDEX_COUNT)) {
                        int count = (Integer)this.underlyingNode.getProperty(INDEX_COUNT);
                        this.underlyingNode.setProperty(INDEX_COUNT, (Object)(--count));
                    }
                }
            }
            node.delete();
            if (!previous.equals(next)) {
                previous.createRelationshipTo(next, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY);
            }
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    public Iterable<Node> getAllNodes(Long afterTimestampOrNull, Long beforeTimestampOrNull) {
        Iterable<Node> result = null;
        result = afterTimestampOrNull == null && beforeTimestampOrNull == null ? this.getAllNodes() : (afterTimestampOrNull == null ? this.getAllNodesBefore(beforeTimestampOrNull) : (beforeTimestampOrNull == null ? this.getAllNodesAfter(afterTimestampOrNull) : this.getAllNodesBetween(afterTimestampOrNull, beforeTimestampOrNull)));
        return result;
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return this.underlyingNode.traverse(Traverser.Order.BREADTH_FIRST, StopEvaluator.END_OF_GRAPH, new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition position) {
                Relationship last = position.lastRelationshipTraversed();
                return last != null && last.getType().equals((Object)RelTypes.TIMELINE_INSTANCE);
            }
        }, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING, (RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING);
    }

    Iterable<Node> getAllTimeNodes() {
        return this.underlyingNode.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition position) {
                return position.depth() > 0;
            }
        }, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING);
    }

    private Node getIndexedStartNode(long timestamp) {
        if (this.useIndexing) {
            Node startNode = this.underlyingNode;
            Long nodeId = (Long)this.bTree.getClosestLowerEntry(timestamp);
            if (nodeId != null) {
                startNode = this.neo.getNodeById(nodeId.longValue());
            }
            return startNode;
        }
        return this.underlyingNode;
    }

    @Override
    public Iterable<Node> getNodes(long timestamp) {
        Relationship rel;
        long currentTime;
        Node currentNode = this.getIndexedStartNode(timestamp);
        ArrayList<Node> nodeList = new ArrayList<Node>();
        if (currentNode.equals(this.underlyingNode)) {
            if (!currentNode.hasRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING)) {
                return nodeList;
            }
            currentNode = currentNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING).getEndNode();
        }
        do {
            if ((currentTime = ((Long)currentNode.getProperty(TIMESTAMP)).longValue()) != timestamp) continue;
            for (Relationship instanceRel : currentNode.getRelationships((RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING)) {
                nodeList.add(instanceRel.getEndNode());
            }
            break;
        } while (currentTime <= timestamp && !(currentNode = (rel = currentNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING)).getEndNode()).equals(this.underlyingNode));
        return nodeList;
    }

    @Override
    public Iterable<Node> getAllNodesAfter(final long timestamp) {
        Node startNode = this.getIndexedStartNode(timestamp);
        return startNode.traverse(Traverser.Order.DEPTH_FIRST, new StopEvaluator(){

            public boolean isStopNode(TraversalPosition position) {
                return position.lastRelationshipTraversed() != null && position.currentNode().equals(Timeline.this.underlyingNode);
            }
        }, new ReturnableEvaluator(){
            private boolean timeOk = false;

            public boolean isReturnableNode(TraversalPosition position) {
                if (position.currentNode().equals(Timeline.this.underlyingNode)) {
                    return false;
                }
                Relationship last = position.lastRelationshipTraversed();
                if (!this.timeOk && last != null && last.getType().equals((Object)RelTypes.TIMELINE_NEXT_ENTRY)) {
                    Node node = position.currentNode();
                    long currentTime = (Long)node.getProperty(Timeline.TIMESTAMP);
                    this.timeOk = currentTime > timestamp;
                    return false;
                }
                return this.timeOk && last.getType().equals((Object)RelTypes.TIMELINE_INSTANCE);
            }
        }, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING, (RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING);
    }

    Iterable<Node> getAllTimeNodesAfter(final long timestamp) {
        Node startNode = this.getIndexedStartNode(timestamp);
        return startNode.traverse(Traverser.Order.DEPTH_FIRST, new StopEvaluator(){

            public boolean isStopNode(TraversalPosition position) {
                return position.lastRelationshipTraversed() != null && position.currentNode().equals(Timeline.this.underlyingNode);
            }
        }, new ReturnableEvaluator(){
            private boolean timeOk = false;

            public boolean isReturnableNode(TraversalPosition position) {
                if (position.currentNode().equals(Timeline.this.underlyingNode)) {
                    return false;
                }
                Relationship last = position.lastRelationshipTraversed();
                if (!this.timeOk && last != null && last.getType().equals((Object)RelTypes.TIMELINE_NEXT_ENTRY)) {
                    Node node = position.currentNode();
                    long currentTime = (Long)node.getProperty(Timeline.TIMESTAMP);
                    this.timeOk = currentTime > timestamp;
                }
                return this.timeOk;
            }
        }, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING);
    }

    @Override
    public Iterable<Node> getAllNodesBefore(final long timestamp) {
        return this.underlyingNode.traverse(Traverser.Order.DEPTH_FIRST, new StopEvaluator(){

            public boolean isStopNode(TraversalPosition position) {
                Relationship last = position.lastRelationshipTraversed();
                if (last != null && last.getType().equals((Object)RelTypes.TIMELINE_NEXT_ENTRY)) {
                    Node node = position.currentNode();
                    long currentTime = (Long)node.getProperty(Timeline.TIMESTAMP);
                    return currentTime >= timestamp;
                }
                return false;
            }
        }, new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition position) {
                Relationship last = position.lastRelationshipTraversed();
                return last != null && last.getType().equals((Object)RelTypes.TIMELINE_INSTANCE);
            }
        }, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING, (RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING);
    }

    @Override
    public Iterable<Node> getAllNodesBetween(final long startTime, final long endTime) {
        if (startTime >= endTime) {
            throw new IllegalArgumentException("Start time greater or equal to end time");
        }
        Node startNode = this.getIndexedStartNode(startTime);
        return startNode.traverse(Traverser.Order.DEPTH_FIRST, new StopEvaluator(){

            public boolean isStopNode(TraversalPosition position) {
                Relationship last = position.lastRelationshipTraversed();
                if (last != null && position.currentNode().equals(Timeline.this.underlyingNode)) {
                    return true;
                }
                if (last != null && last.getType().equals((Object)RelTypes.TIMELINE_NEXT_ENTRY)) {
                    Node node = position.currentNode();
                    long currentTime = (Long)node.getProperty(Timeline.TIMESTAMP);
                    return currentTime >= endTime;
                }
                return false;
            }
        }, new ReturnableEvaluator(){
            private boolean timeOk = false;

            public boolean isReturnableNode(TraversalPosition position) {
                if (position.currentNode().equals(Timeline.this.underlyingNode)) {
                    return false;
                }
                Relationship last = position.lastRelationshipTraversed();
                if (!this.timeOk && last != null && last.getType().equals((Object)RelTypes.TIMELINE_NEXT_ENTRY)) {
                    Node node = position.currentNode();
                    long currentTime = (Long)node.getProperty(Timeline.TIMESTAMP);
                    this.timeOk = currentTime > startTime;
                    return false;
                }
                return this.timeOk && last.getType().equals((Object)RelTypes.TIMELINE_INSTANCE);
            }
        }, (RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING, (RelationshipType)RelTypes.TIMELINE_INSTANCE, Direction.OUTGOING);
    }

    @Override
    public void delete() {
        if (this.useIndexing) {
            this.bTree.delete();
        }
        Relationship rel = this.underlyingNode.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING);
        while (rel != null) {
            Node node = rel.getEndNode();
            if (!node.equals(this.underlyingNode)) {
                for (Relationship instance : node.getRelationships(new RelationshipType[]{RelTypes.TIMELINE_INSTANCE})) {
                    instance.delete();
                }
                rel.delete();
                rel = node.getSingleRelationship((RelationshipType)RelTypes.TIMELINE_NEXT_ENTRY, Direction.OUTGOING);
                node.delete();
                continue;
            }
            rel.delete();
            rel = null;
        }
        this.underlyingNode.delete();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RelTypes implements RelationshipType
    {
        TIMELINE_INSTANCE,
        TIMELINE_NEXT_ENTRY;

    }
}

