/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.api.core;

import java.util.Map;
import org.neo4j.impl.cache.AdaptiveCacheManager;
import org.neo4j.impl.core.LockReleaser;
import org.neo4j.impl.core.NeoModule;
import org.neo4j.impl.event.EventModule;
import org.neo4j.impl.persistence.IdGeneratorModule;
import org.neo4j.impl.persistence.PersistenceModule;
import org.neo4j.impl.transaction.LockManager;
import org.neo4j.impl.transaction.TxModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private EventModule eventModule;
    private AdaptiveCacheManager cacheManager;
    private TxModule txModule;
    private LockManager lockManager;
    private LockReleaser lockReleaser;
    private PersistenceModule persistenceModule;
    private boolean create = false;
    private String persistenceSourceName;
    private IdGeneratorModule idGeneratorModule;
    private NeoModule neoModule;
    private String storeDir;
    private final Map<Object, Object> params;
    private final boolean readOnly;

    Config(String storeDir, Map<Object, Object> params) {
        this.storeDir = storeDir;
        this.params = params;
        String readOnlyStr = (String)params.get("read_only");
        this.readOnly = readOnlyStr != null && readOnlyStr.toLowerCase().equals("true");
        params.put("read_only", this.readOnly);
        this.eventModule = new EventModule();
        this.cacheManager = new AdaptiveCacheManager();
        this.txModule = !this.readOnly ? new TxModule(this.storeDir) : new TxModule(true);
        this.lockManager = new LockManager(this.txModule.getTxManager());
        this.lockReleaser = new LockReleaser(this.lockManager, this.txModule.getTxManager());
        this.persistenceModule = new PersistenceModule();
        this.idGeneratorModule = new IdGeneratorModule();
        this.neoModule = new NeoModule(this.cacheManager, this.lockManager, this.txModule.getTxManager(), this.idGeneratorModule.getIdGenerator(), this.readOnly);
    }

    void setNeoPersistenceSource(String name, boolean create) {
        this.persistenceSourceName = name;
        this.create = create;
    }

    String getPersistenceSource() {
        return this.persistenceSourceName;
    }

    boolean getCreatePersistenceSource() {
        return this.create;
    }

    public EventModule getEventModule() {
        return this.eventModule;
    }

    public TxModule getTxModule() {
        return this.txModule;
    }

    public NeoModule getNeoModule() {
        return this.neoModule;
    }

    public PersistenceModule getPersistenceModule() {
        return this.persistenceModule;
    }

    IdGeneratorModule getIdGeneratorModule() {
        return this.idGeneratorModule;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public LockReleaser getLockReleaser() {
        return this.lockReleaser;
    }

    public Map<Object, Object> getParams() {
        return this.params;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }
}

