/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.api.core;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Map;
import org.neo4j.api.core.NeoService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShellService {
    private final NeoService neo;
    private final Object shellServer;

    ShellService(NeoService neo, Map<String, Serializable> config) throws ShellNotAvailableException, RemoteException {
        this.neo = neo;
        if (!this.shellDependencyAvailable()) {
            throw new ShellNotAvailableException();
        }
        this.shellServer = this.startShellServer(config);
    }

    private boolean shellDependencyAvailable() {
        try {
            Class.forName("org.neo4j.shell.ShellServer");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private Object startShellServer(Map<String, Serializable> config) throws RemoteException {
        Integer port = (Integer)this.getConfig(config, "port", "DEFAULT_PORT");
        String name = (String)((Object)this.getConfig(config, "name", "DEFAULT_NAME"));
        try {
            Class<?> shellServerClass = Class.forName("org.neo4j.shell.neo.NeoShellServer");
            Object shellServer = shellServerClass.getConstructor(NeoService.class).newInstance(this.neo);
            shellServer.getClass().getMethod("makeRemotelyAvailable", Integer.TYPE, String.class).invoke(shellServer, port, name);
            return shellServer;
        }
        catch (Exception e) {
            throw new RemoteException("Couldn't start shell '" + name + "' at port " + port, e);
        }
    }

    private Serializable getConfig(Map<String, Serializable> config, String key, String defaultVariableName) throws RemoteException {
        Serializable result = config.get(key);
        if (result == null) {
            try {
                result = (Serializable)Class.forName("org.neo4j.shell.AbstractServer").getDeclaredField(defaultVariableName).get(null);
            }
            catch (Exception e) {
                throw new RemoteException("Default variable not found", e);
            }
        }
        return result;
    }

    public boolean shutdown() throws ShellNotAvailableException {
        try {
            this.shellServer.getClass().getMethod("shutdown", new Class[0]).invoke(this.shellServer, new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static class ShellNotAvailableException
    extends Exception {
    }
}

