/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.neo4j.api.core.EmbeddedNeo;
import org.neo4j.api.core.NeoService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneWithShell {
    private static Logger log = Logger.getLogger(StandaloneWithShell.class.getName());
    private NeoService embeddedNeo;
    private AtomicBoolean shutdownInitiated = new AtomicBoolean(false);

    private NeoService getNeo() {
        return this.embeddedNeo;
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                StandaloneWithShell.this.shutdown();
            }
        });
    }

    private void initialize(Map<String, String> arguments) {
        String path = arguments.get("path");
        this.embeddedNeo = new EmbeddedNeo(path);
        Map<String, Serializable> shellProperties = Collections.emptyMap();
        this.getNeo().enableRemoteShell(shellProperties);
        log.info("Neo started at '" + path + "'");
    }

    private void blockUntilShutdown() {
        try {
            while (!this.shutdownInitiated.get()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    private void shutdown() {
        if (this.shutdownInitiated.compareAndSet(false, true)) {
            log.info("Shutting down...");
            try {
                if (this.getNeo() != null) {
                    this.getNeo().shutdown();
                    this.embeddedNeo = null;
                }
            }
            catch (Throwable t) {
                log.warning("Error shutting down Neo: " + t);
            }
        }
    }

    public void execute(Map<String, String> arguments) {
        this.addShutdownHook();
        this.initialize(arguments);
        this.blockUntilShutdown();
    }

    public static void main(String[] args) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) continue;
            String key = arg.substring(1);
            String value = ++i < args.length ? args[i] : null;
            arguments.put(key, value);
        }
        if (!arguments.containsKey("path")) {
            System.out.println("Use -path <path> to control the neo4j store path");
            return;
        }
        new StandaloneWithShell().execute(arguments);
    }
}

