/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.batchinsert;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.api.core.NotInTransactionException;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.ReturnableEvaluator;
import org.neo4j.api.core.StopEvaluator;
import org.neo4j.api.core.Transaction;
import org.neo4j.api.core.Traverser;
import org.neo4j.impl.batchinsert.BatchInserterImpl;
import org.neo4j.impl.batchinsert.SimpleRelationship;
import org.neo4j.impl.cache.LruCache;
import org.neo4j.impl.nioneo.store.InvalidRecordException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NeoServiceBatchImpl
implements NeoService {
    final BatchInserterImpl batchInserter;
    private final LruCache<Long, NodeBatchImpl> nodes = new LruCache<Long, NodeBatchImpl>("NodeCache", 10000, null){

        @Override
        public void elementCleaned(NodeBatchImpl node) {
            Map<String, Object> properties = node.getProperties();
            if (properties != null) {
                NeoServiceBatchImpl.this.batchInserter.setNodeProperties(node.getId(), properties);
            }
        }
    };
    private final LruCache<Long, RelationshipBatchImpl> rels = new LruCache<Long, RelationshipBatchImpl>("RelCache", 10000, null){

        @Override
        public void elementCleaned(RelationshipBatchImpl rel) {
            Map<String, Object> properties = rel.getProperties();
            if (properties != null) {
                NeoServiceBatchImpl.this.batchInserter.setRelationshipProperties(rel.getId(), properties);
            }
        }
    };

    NeoServiceBatchImpl(BatchInserterImpl batchInserter) {
        this.batchInserter = batchInserter;
    }

    BatchInserterImpl getBatchInserter() {
        return this.batchInserter;
    }

    @Override
    public Transaction beginTx() {
        return new FakeTransaction();
    }

    @Override
    public Node createNode() {
        long id = this.batchInserter.createNode(null);
        NodeBatchImpl node = new NodeBatchImpl(id, this, NeoServiceBatchImpl.emptyProps());
        this.nodes.put((Long)id, node);
        return node;
    }

    static Map<String, Object> emptyProps() {
        return new HashMap<String, Object>();
    }

    @Override
    public boolean enableRemoteShell() {
        return false;
    }

    @Override
    public boolean enableRemoteShell(Map<String, Serializable> initialProperties) {
        return false;
    }

    @Override
    public Iterable<Node> getAllNodes() {
        throw new UnsupportedOperationException("Batch inserter mode");
    }

    @Override
    public Node getNodeById(long id) {
        NodeBatchImpl node = this.nodes.get(id);
        if (node == null) {
            try {
                node = new NodeBatchImpl(id, this, this.batchInserter.getNodeProperties(id));
                this.nodes.put((Long)id, node);
            }
            catch (InvalidRecordException e) {
                throw new NotFoundException(e);
            }
        }
        return node;
    }

    @Override
    public Node getReferenceNode() {
        return this.getNodeById(0L);
    }

    @Override
    public Relationship getRelationshipById(long id) {
        RelationshipBatchImpl rel = this.rels.get(id);
        if (rel == null) {
            try {
                SimpleRelationship simpleRel = this.batchInserter.getRelationshipById(id);
                Map<String, Object> props = this.batchInserter.getRelationshipProperties(id);
                rel = new RelationshipBatchImpl(simpleRel, this, props);
                this.rels.put((Long)id, rel);
            }
            catch (InvalidRecordException e) {
                throw new NotFoundException(e);
            }
        }
        return rel;
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        throw new UnsupportedOperationException("Batch inserter mode");
    }

    @Override
    public void shutdown() {
        this.batchInserter.shutdown();
    }

    void addRelationshipToCache(long id, RelationshipBatchImpl rel) {
        this.rels.put((Long)id, rel);
    }

    void clearCaches() {
        this.nodes.clear();
        this.rels.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RelIterator
    implements Iterable<Relationship>,
    Iterator<Relationship> {
        private final NeoServiceBatchImpl neoService;
        private final Iterable<Long> relIds;
        private final Iterator<Long> relItr;
        private final long nodeId;
        private final Direction dir;
        private final RelationshipType[] types;
        private Relationship nextElement;

        RelIterator(NeoServiceBatchImpl neoService, Iterable<Long> relIds, long nodeId, Direction dir, RelationshipType[] types) {
            this.neoService = neoService;
            this.relIds = relIds;
            this.relItr = relIds.iterator();
            this.nodeId = nodeId;
            this.dir = dir;
            this.types = types;
        }

        @Override
        public Iterator<Relationship> iterator() {
            return new RelIterator(this.neoService, this.relIds, this.nodeId, this.dir, this.types);
        }

        @Override
        public boolean hasNext() {
            this.getNextElement();
            return this.nextElement != null;
        }

        @Override
        public Relationship next() {
            this.getNextElement();
            if (this.nextElement != null) {
                Relationship returnVal = this.nextElement;
                this.nextElement = null;
                return returnVal;
            }
            throw new NoSuchElementException();
        }

        private void getNextElement() {
            block0: while (this.nextElement == null && this.relItr.hasNext()) {
                Relationship possibleRel = this.neoService.getRelationshipById(this.relItr.next());
                if (this.dir == Direction.OUTGOING && possibleRel.getEndNode().getId() == this.nodeId || this.dir == Direction.INCOMING && possibleRel.getStartNode().getId() == this.nodeId) continue;
                if (this.types != null) {
                    for (RelationshipType type : this.types) {
                        if (!type.name().equals(possibleRel.getType().name())) continue;
                        this.nextElement = possibleRel;
                        continue block0;
                    }
                    continue;
                }
                this.nextElement = possibleRel;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RelationshipBatchImpl
    implements Relationship {
        private final SimpleRelationship rel;
        private final NeoServiceBatchImpl neoService;
        private final Map<String, Object> properties;

        RelationshipBatchImpl(SimpleRelationship rel, NeoServiceBatchImpl neoService, Map<String, Object> properties) {
            this.rel = rel;
            this.neoService = neoService;
            this.properties = properties;
        }

        Map<String, Object> getProperties() {
            return this.properties;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("Batch inserter mode");
        }

        @Override
        public Node getEndNode() {
            return this.neoService.getNodeById(this.rel.getEndNode());
        }

        @Override
        public long getId() {
            return this.rel.getId();
        }

        @Override
        public Node[] getNodes() {
            return new Node[]{this.getStartNode(), this.getEndNode()};
        }

        @Override
        public Node getOtherNode(Node node) {
            Node startNode = this.getStartNode();
            Node endNode = this.getEndNode();
            if (node.equals(endNode)) {
                return startNode;
            }
            if (node.equals(startNode)) {
                return endNode;
            }
            throw new IllegalArgumentException("" + node);
        }

        @Override
        public Node getStartNode() {
            return this.neoService.getNodeById(this.rel.getStartNode());
        }

        @Override
        public RelationshipType getType() {
            return this.rel.getType();
        }

        @Override
        public boolean isType(RelationshipType type) {
            return this.rel.getType().equals(type);
        }

        @Override
        public Object getProperty(String key) {
            Object val = this.properties.get(key);
            if (val == null) {
                throw new NotFoundException(key);
            }
            return val;
        }

        @Override
        public Object getProperty(String key, Object defaultValue) {
            Object val = this.properties.get(key);
            if (val == null) {
                return defaultValue;
            }
            return val;
        }

        @Override
        public Iterable<String> getPropertyKeys() {
            return this.properties.keySet();
        }

        @Override
        public Iterable<Object> getPropertyValues() {
            return this.properties.values();
        }

        @Override
        public boolean hasProperty(String key) {
            return this.properties.containsKey(key);
        }

        @Override
        public Object removeProperty(String key) {
            Object val = this.properties.remove(key);
            if (val == null) {
                throw new NotFoundException("Property " + key);
            }
            return val;
        }

        @Override
        public void setProperty(String key, Object value) {
            this.properties.put(key, value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Relationship)) {
                return false;
            }
            return this.getId() == ((Relationship)o).getId();
        }

        public int hashCode() {
            return (int)this.rel.getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeBatchImpl
    implements Node {
        private final NeoServiceBatchImpl neoService;
        private final long id;
        private final Map<String, Object> properties;

        NodeBatchImpl(long id, NeoServiceBatchImpl neoService, Map<String, Object> properties) {
            this.id = id;
            this.neoService = neoService;
            this.properties = properties;
        }

        @Override
        public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
            long relId = this.neoService.getBatchInserter().createRelationship(this.id, otherNode.getId(), type, null);
            RelationshipBatchImpl rel = new RelationshipBatchImpl(new SimpleRelationship((int)relId, (int)this.id, (int)otherNode.getId(), type), this.neoService, NeoServiceBatchImpl.emptyProps());
            this.neoService.addRelationshipToCache(relId, rel);
            return rel;
        }

        Map<String, Object> getProperties() {
            return this.properties;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getId() {
            return this.id;
        }

        private RelIterator newRelIterator(Direction dir, RelationshipType[] types) {
            Iterable<Long> relIds = this.neoService.getBatchInserter().getRelationshipIds(this.id);
            return new RelIterator(this.neoService, relIds, this.id, dir, types);
        }

        @Override
        public Iterable<Relationship> getRelationships() {
            return this.newRelIterator(Direction.BOTH, null);
        }

        @Override
        public Iterable<Relationship> getRelationships(RelationshipType ... types) {
            return this.newRelIterator(Direction.BOTH, types);
        }

        @Override
        public Iterable<Relationship> getRelationships(Direction dir) {
            return this.newRelIterator(dir, null);
        }

        @Override
        public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
            return this.newRelIterator(dir, new RelationshipType[]{type});
        }

        @Override
        public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
            RelIterator relItr = this.newRelIterator(dir, new RelationshipType[]{type});
            if (relItr.hasNext()) {
                Relationship rel = (Relationship)relItr.next();
                if (relItr.hasNext()) {
                    throw new NotFoundException("More than one relationship[" + type + ", " + (Object)((Object)dir) + "] found for " + this);
                }
                return rel;
            }
            return null;
        }

        @Override
        public boolean hasRelationship() {
            RelIterator relItr = this.newRelIterator(Direction.BOTH, null);
            return relItr.hasNext();
        }

        @Override
        public boolean hasRelationship(RelationshipType ... types) {
            RelIterator relItr = this.newRelIterator(Direction.BOTH, types);
            return relItr.hasNext();
        }

        @Override
        public boolean hasRelationship(Direction dir) {
            RelIterator relItr = this.newRelIterator(dir, null);
            return relItr.hasNext();
        }

        @Override
        public boolean hasRelationship(RelationshipType type, Direction dir) {
            RelIterator relItr = this.newRelIterator(dir, new RelationshipType[]{type});
            return relItr.hasNext();
        }

        @Override
        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
            throw new UnsupportedOperationException("Batch inserter mode");
        }

        @Override
        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
            throw new UnsupportedOperationException("Batch inserter mode");
        }

        @Override
        public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
            throw new UnsupportedOperationException("Batch inserter mode");
        }

        @Override
        public Object getProperty(String key) {
            Object val = this.properties.get(key);
            if (val == null) {
                throw new NotFoundException(key);
            }
            return val;
        }

        @Override
        public Object getProperty(String key, Object defaultValue) {
            Object val = this.properties.get(key);
            if (val == null) {
                return defaultValue;
            }
            return val;
        }

        @Override
        public Iterable<String> getPropertyKeys() {
            return this.properties.keySet();
        }

        @Override
        public Iterable<Object> getPropertyValues() {
            return this.properties.values();
        }

        @Override
        public boolean hasProperty(String key) {
            return this.properties.containsKey(key);
        }

        @Override
        public Object removeProperty(String key) {
            Object val = this.properties.remove(key);
            if (val == null) {
                throw new NotFoundException("Property " + key);
            }
            return val;
        }

        @Override
        public void setProperty(String key, Object value) {
            this.properties.put(key, value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Node)) {
                return false;
            }
            return this.getId() == ((Node)o).getId();
        }

        public int hashCode() {
            return (int)this.id;
        }
    }

    static class FakeTransaction
    implements Transaction {
        FakeTransaction() {
        }

        public void failure() {
            throw new NotInTransactionException("Batch insert mode, failure is not an option.");
        }

        public void finish() {
        }

        public void success() {
        }
    }
}

