/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.batchinsert;

import org.neo4j.api.core.NotFoundException;
import org.neo4j.impl.nioneo.store.PropertyIndexData;
import org.neo4j.impl.util.ArrayMap;

public class PropertyIndexHolder {
    private final ArrayMap<String, Integer> propertyIndexes = new ArrayMap(5, false, false);
    private final ArrayMap<Integer, String> idToIndex = new ArrayMap(5, false, false);

    PropertyIndexHolder(PropertyIndexData[] indexes) {
        for (PropertyIndexData index : indexes) {
            this.propertyIndexes.put(index.getValue(), index.getKeyId());
            this.idToIndex.put(index.getKeyId(), index.getValue());
        }
    }

    void addPropertyIndex(String stringKey, int keyId) {
        this.propertyIndexes.put(stringKey, keyId);
        this.idToIndex.put(keyId, stringKey);
    }

    int getKeyId(String stringKey) {
        Integer keyId = this.propertyIndexes.get(stringKey);
        if (keyId != null) {
            return keyId;
        }
        return -1;
    }

    String getStringKey(int keyId) {
        String stringKey = this.idToIndex.get(keyId);
        if (stringKey == null) {
            throw new NotFoundException("No such property index[" + keyId + "]");
        }
        return stringKey;
    }
}

