/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.impl.core.NodeImpl;
import org.neo4j.impl.core.NodeManager;
import org.neo4j.impl.core.NullRelTypeElement;
import org.neo4j.impl.core.RelTypeElementIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntArrayIterator
implements Iterable<Relationship>,
Iterator<Relationship> {
    private Logger log = Logger.getLogger(IntArrayIterator.class.getName());
    private Iterator<RelTypeElementIterator> typeIterator;
    private RelTypeElementIterator currentTypeIterator = null;
    private NodeImpl fromNode;
    private Direction direction = null;
    private Relationship nextElement = null;
    private final NodeManager nodeManager;
    private int position = 0;
    private final RelationshipType[] types;
    private Set<String> visitedTypes = new HashSet<String>();

    IntArrayIterator(List<RelTypeElementIterator> rels, NodeImpl fromNode, Direction direction, NodeManager nodeManager, RelationshipType[] types) {
        this.typeIterator = rels.iterator();
        if (this.typeIterator.hasNext()) {
            this.currentTypeIterator = this.typeIterator.next();
            this.visitedTypes.add(this.currentTypeIterator.getType());
        } else {
            this.currentTypeIterator = new NullRelTypeElement();
        }
        this.fromNode = fromNode;
        this.direction = direction;
        this.nodeManager = nodeManager;
        this.types = types;
    }

    @Override
    public Iterator<Relationship> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.nextElement != null) {
            return true;
        }
        block2: do {
            if (this.currentTypeIterator.hasNext()) {
                int nextId = (Integer)this.currentTypeIterator.next();
                try {
                    Relationship possibleElement = this.nodeManager.getRelationshipById(nextId);
                    if (this.direction == Direction.INCOMING && possibleElement.getEndNode().equals(this.fromNode)) {
                        this.nextElement = possibleElement;
                        return true;
                    }
                    if (this.direction == Direction.OUTGOING && possibleElement.getStartNode().equals(this.fromNode)) {
                        this.nextElement = possibleElement;
                        return true;
                    }
                    if (this.direction == Direction.BOTH) {
                        this.nextElement = possibleElement;
                        return true;
                    }
                }
                catch (NotFoundException e) {
                    this.log.log(Level.FINE, "Unable to get relationship " + nextId, e);
                }
            }
            while (!this.currentTypeIterator.hasNext()) {
                if (this.typeIterator.hasNext()) {
                    this.currentTypeIterator = this.typeIterator.next();
                    this.visitedTypes.add(this.currentTypeIterator.getType());
                    continue;
                }
                boolean gotMore = this.fromNode.getMoreRelationships();
                List<RelTypeElementIterator> list = Collections.EMPTY_LIST;
                list = this.types.length == 0 ? this.fromNode.getAllRelationships() : this.fromNode.getAllRelationshipsOfType(this.types);
                Iterator<RelTypeElementIterator> itr = list.iterator();
                while (itr.hasNext()) {
                    RelTypeElementIterator element = itr.next();
                    if (!this.visitedTypes.contains(element.getType())) continue;
                    itr.remove();
                }
                this.typeIterator = list.iterator();
                if (this.typeIterator.hasNext()) {
                    this.currentTypeIterator = this.typeIterator.next();
                    this.visitedTypes.add(this.currentTypeIterator.getType());
                }
                if (gotMore) continue;
                continue block2;
            }
        } while (this.currentTypeIterator.hasNext());
        return false;
    }

    @Override
    public Relationship next() {
        this.hasNext();
        if (this.nextElement != null) {
            Relationship elementToReturn = this.nextElement;
            this.nextElement = null;
            return elementToReturn;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

