/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.core;

import java.util.LinkedList;
import java.util.List;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.ReturnableEvaluator;
import org.neo4j.api.core.StopEvaluator;
import org.neo4j.api.core.Traverser;
import org.neo4j.impl.core.IntArrayIterator;
import org.neo4j.impl.core.NeoPrimitive;
import org.neo4j.impl.core.NodeManager;
import org.neo4j.impl.core.PropertyIndex;
import org.neo4j.impl.core.RelTypeElement;
import org.neo4j.impl.core.RelTypeElementIterator;
import org.neo4j.impl.nioneo.store.PropertyData;
import org.neo4j.impl.nioneo.store.Record;
import org.neo4j.impl.nioneo.store.RelationshipChainPosition;
import org.neo4j.impl.transaction.LockType;
import org.neo4j.impl.util.ArrayMap;
import org.neo4j.impl.util.IntArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeImpl
extends NeoPrimitive
implements Node,
Comparable<Node> {
    private ArrayMap<String, IntArray> relationshipMap = null;
    private RelationshipChainPosition relChainPosition = null;

    NodeImpl(int id, NodeManager nodeManager) {
        super(id, nodeManager);
    }

    NodeImpl(int id, boolean newNode, NodeManager nodeManager) {
        super(id, newNode, nodeManager);
        if (newNode) {
            this.relationshipMap = new ArrayMap();
            this.relChainPosition = new RelationshipChainPosition(Record.NO_NEXT_RELATIONSHIP.intValue());
        }
    }

    @Override
    protected void changeProperty(int propertyId, Object value) {
        this.nodeManager.nodeChangeProperty(this, propertyId, value);
    }

    @Override
    protected int addProperty(PropertyIndex index, Object value) {
        return this.nodeManager.nodeAddProperty(this, index, value);
    }

    @Override
    protected void removeProperty(int propertyId) {
        this.nodeManager.nodeRemoveProperty(this, propertyId);
    }

    @Override
    protected ArrayMap<Integer, PropertyData> loadProperties() {
        return this.nodeManager.loadProperties(this);
    }

    List<RelTypeElementIterator> getAllRelationships() {
        this.ensureFullRelationships();
        LinkedList<RelTypeElementIterator> relTypeList = new LinkedList<RelTypeElementIterator>();
        ArrayMap<String, IntArray> addMap = this.nodeManager.getCowRelationshipAddMap(this);
        for (String type : this.relationshipMap.keySet()) {
            IntArray src = this.relationshipMap.get(type);
            IntArray remove = this.nodeManager.getCowRelationshipRemoveMap(this, type);
            IntArray add = null;
            if (addMap != null) {
                add = addMap.get(type);
            }
            if (src == null && add == null) continue;
            relTypeList.add(RelTypeElement.create(type, this, src, add, remove));
        }
        if (addMap != null) {
            for (String type : addMap.keySet()) {
                if (this.relationshipMap.get(type) != null) continue;
                IntArray remove = this.nodeManager.getCowRelationshipRemoveMap(this, type);
                IntArray add = addMap.get(type);
                relTypeList.add(RelTypeElement.create(type, this, null, add, remove));
            }
        }
        return relTypeList;
    }

    List<RelTypeElementIterator> getAllRelationshipsOfType(RelationshipType ... types) {
        this.ensureFullRelationships();
        LinkedList<RelTypeElementIterator> relTypeList = new LinkedList<RelTypeElementIterator>();
        for (RelationshipType type : types) {
            IntArray src = this.relationshipMap.get(type.name());
            IntArray remove = this.nodeManager.getCowRelationshipRemoveMap(this, type.name());
            IntArray add = this.nodeManager.getCowRelationshipAddMap(this, type.name());
            if (src == null && add == null) continue;
            relTypeList.add(RelTypeElement.create(type.name(), this, src, add, remove));
        }
        return relTypeList;
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return new IntArrayIterator(this.getAllRelationships(), this, Direction.BOTH, this.nodeManager, new RelationshipType[0]);
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction dir) {
        return new IntArrayIterator(this.getAllRelationships(), this, dir, this.nodeManager, new RelationshipType[0]);
    }

    public Iterable<Relationship> getRelationships(RelationshipType type) {
        RelationshipType[] types = new RelationshipType[]{type};
        return new IntArrayIterator(this.getAllRelationshipsOfType(types), this, Direction.BOTH, this.nodeManager, types);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        return new IntArrayIterator(this.getAllRelationshipsOfType(types), this, Direction.BOTH, this.nodeManager, types);
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        RelationshipType[] types = new RelationshipType[]{type};
        IntArrayIterator rels = new IntArrayIterator(this.getAllRelationshipsOfType(types), this, dir, this.nodeManager, types);
        if (!rels.hasNext()) {
            return null;
        }
        Relationship rel = (Relationship)rels.next();
        if (rels.hasNext()) {
            throw new NotFoundException("More than one relationship[" + type + ", " + (Object)((Object)dir) + "] found for " + this);
        }
        return rel;
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        RelationshipType[] types = new RelationshipType[]{type};
        return new IntArrayIterator(this.getAllRelationshipsOfType(types), this, dir, this.nodeManager, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        this.nodeManager.acquireLock(this, LockType.WRITE);
        boolean success = false;
        try {
            this.nodeManager.deleteNode(this);
            success = true;
        }
        finally {
            this.nodeManager.releaseLock(this, LockType.WRITE);
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    @Override
    public int compareTo(Node n) {
        long theirId;
        long ourId = this.getId();
        if (ourId < (theirId = n.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        return this.getId() == ((Node)o).getId();
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "NodeImpl#" + this.getId();
    }

    void addRelationship(RelationshipType type, int relId) {
        IntArray relationshipSet = this.nodeManager.getCowRelationshipAddMap(this, type.name(), true);
        relationshipSet.add(relId);
    }

    void removeRelationship(RelationshipType type, int relId) {
        IntArray relationshipSet = this.nodeManager.getCowRelationshipRemoveMap(this, type.name(), true);
        relationshipSet.add(relId);
    }

    private boolean ensureFullRelationships() {
        if (this.relationshipMap == null) {
            this.relChainPosition = this.nodeManager.getRelationshipChainPosition(this);
            this.relationshipMap = new ArrayMap();
            this.getMoreRelationships();
            return true;
        }
        return false;
    }

    synchronized boolean getMoreRelationships() {
        if (!this.relChainPosition.hasMore()) {
            return false;
        }
        ArrayMap<String, IntArray> addMap = this.nodeManager.getMoreRelationships(this);
        if (addMap.size() == 0) {
            return false;
        }
        for (String type : addMap.keySet()) {
            IntArray addRels = addMap.get(type);
            IntArray srcRels = this.relationshipMap.get(type);
            if (srcRels == null) {
                this.relationshipMap.put(type, addRels);
                continue;
            }
            srcRels.addAll(addRels);
        }
        return true;
    }

    @Override
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        return this.nodeManager.createRelationship(this, otherNode, type);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        if (direction == null) {
            throw new IllegalArgumentException("Null direction");
        }
        if (relationshipType == null) {
            throw new IllegalArgumentException("Null relationship type");
        }
        return this.nodeManager.createTraverser(traversalOrder, this, relationshipType, direction, stopEvaluator, returnableEvaluator);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        if (firstDirection == null || secondDirection == null) {
            throw new IllegalArgumentException("Null direction, firstDirection=" + (Object)((Object)firstDirection) + "secondDirection=" + (Object)((Object)secondDirection));
        }
        if (firstRelationshipType == null || secondRelationshipType == null) {
            throw new IllegalArgumentException("Null rel type, first=" + firstRelationshipType + "second=" + secondRelationshipType);
        }
        RelationshipType[] types = new RelationshipType[2];
        Direction[] dirs = new Direction[2];
        types[0] = firstRelationshipType;
        types[1] = secondRelationshipType;
        dirs[0] = firstDirection;
        dirs[1] = secondDirection;
        return this.nodeManager.createTraverser(traversalOrder, this, types, dirs, stopEvaluator, returnableEvaluator);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        int length = relationshipTypesAndDirections.length;
        if (length % 2 != 0 || length == 0) {
            throw new IllegalArgumentException("Variable argument should  consist of [RelationshipType,Direction] pairs");
        }
        int elements = relationshipTypesAndDirections.length / 2;
        RelationshipType[] types = new RelationshipType[elements];
        Direction[] dirs = new Direction[elements];
        int j = 0;
        for (int i = 0; i < elements; ++i) {
            Object direction;
            Object relType;
            if (!((relType = relationshipTypesAndDirections[j++]) instanceof RelationshipType)) {
                throw new IllegalArgumentException("Expected RelationshipType at var args pos " + (j - 1) + ", found " + relType);
            }
            types[i] = (RelationshipType)relType;
            if (!((direction = relationshipTypesAndDirections[j++]) instanceof Direction)) {
                throw new IllegalArgumentException("Expected Direction at var args pos " + (j - 1) + ", found " + direction);
            }
            dirs[i] = (Direction)((Object)direction);
        }
        return this.nodeManager.createTraverser(traversalOrder, this, types, dirs, stopEvaluator, returnableEvaluator);
    }

    @Override
    public boolean hasRelationship() {
        return this.getRelationships().iterator().hasNext();
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types) {
        return this.getRelationships(types).iterator().hasNext();
    }

    @Override
    public boolean hasRelationship(Direction dir) {
        return this.getRelationships(dir).iterator().hasNext();
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.getRelationships(type, dir).iterator().hasNext();
    }

    protected void commitRelationshipMaps(ArrayMap<String, IntArray> cowRelationshipAddMap, ArrayMap<String, IntArray> cowRelationshipRemoveMap) {
        IntArray remove;
        if (this.relationshipMap == null) {
            return;
        }
        if (cowRelationshipAddMap != null) {
            for (String type : cowRelationshipAddMap.keySet()) {
                IntArray add = cowRelationshipAddMap.get(type);
                remove = null;
                if (cowRelationshipRemoveMap != null) {
                    remove = cowRelationshipRemoveMap.get(type);
                }
                IntArray src = this.relationshipMap.get(type);
                this.relationshipMap.put(type, IntArray.composeNew(src, add, remove));
            }
        }
        if (cowRelationshipRemoveMap != null) {
            for (String type : cowRelationshipRemoveMap.keySet()) {
                if (cowRelationshipAddMap != null && cowRelationshipAddMap.get(type) != null) continue;
                IntArray src = this.relationshipMap.get(type);
                remove = cowRelationshipRemoveMap.get(type);
                this.relationshipMap.put(type, IntArray.composeNew(src, null, remove));
            }
        }
    }

    RelationshipChainPosition getRelChainPosition() {
        return this.relChainPosition;
    }
}

