/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.core;

import org.neo4j.api.core.Node;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.impl.core.NeoPrimitive;
import org.neo4j.impl.core.NodeImpl;
import org.neo4j.impl.core.NodeManager;
import org.neo4j.impl.core.NodeProxy;
import org.neo4j.impl.core.PropertyIndex;
import org.neo4j.impl.nioneo.store.PropertyData;
import org.neo4j.impl.transaction.LockException;
import org.neo4j.impl.transaction.LockType;
import org.neo4j.impl.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RelationshipImpl
extends NeoPrimitive
implements Relationship,
Comparable<Relationship> {
    private final int startNodeId;
    private final int endNodeId;
    private final RelationshipType type;

    RelationshipImpl(int id, NodeManager nodeManager) {
        super(id, nodeManager);
        this.startNodeId = -1;
        this.endNodeId = -1;
        this.type = null;
    }

    RelationshipImpl(int id, int startNodeId, int endNodeId, RelationshipType type, boolean newRel, NodeManager nodeManager) {
        super(id, newRel, nodeManager);
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        if (startNodeId == endNodeId) {
            throw new IllegalArgumentException("Start node equals end node");
        }
        this.startNodeId = startNodeId;
        this.endNodeId = endNodeId;
        this.type = type;
    }

    @Override
    protected void changeProperty(int propertyId, Object value) {
        this.nodeManager.relChangeProperty(this, propertyId, value);
    }

    @Override
    protected int addProperty(PropertyIndex index, Object value) {
        return this.nodeManager.relAddProperty(this, index, value);
    }

    @Override
    protected void removeProperty(int propertyId) {
        this.nodeManager.relRemoveProperty(this, propertyId);
    }

    @Override
    protected ArrayMap<Integer, PropertyData> loadProperties() {
        return this.nodeManager.loadProperties(this);
    }

    @Override
    public Node[] getNodes() {
        return new Node[]{new NodeProxy(this.startNodeId, this.nodeManager), new NodeProxy(this.endNodeId, this.nodeManager)};
    }

    @Override
    public Node getOtherNode(Node node) {
        if (this.startNodeId == (int)node.getId()) {
            return new NodeProxy(this.endNodeId, this.nodeManager);
        }
        if (this.endNodeId == (int)node.getId()) {
            return new NodeProxy(this.startNodeId, this.nodeManager);
        }
        throw new NotFoundException("Node[" + node.getId() + "] not connected to this relationship[" + this.getId() + "]");
    }

    @Override
    public Node getStartNode() {
        return new NodeProxy(this.startNodeId, this.nodeManager);
    }

    int getStartNodeId() {
        return this.startNodeId;
    }

    @Override
    public Node getEndNode() {
        return new NodeProxy(this.endNodeId, this.nodeManager);
    }

    int getEndNodeId() {
        return this.endNodeId;
    }

    @Override
    public RelationshipType getType() {
        return this.type;
    }

    @Override
    public boolean isType(RelationshipType otherType) {
        return otherType != null && otherType.name().equals(this.getType().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        boolean releaseFailed2;
        NodeImpl startNode = null;
        NodeImpl endNode = null;
        boolean startNodeLocked = false;
        boolean endNodeLocked = false;
        this.nodeManager.acquireLock(this, LockType.WRITE);
        boolean success = false;
        try {
            startNode = this.nodeManager.getLightNode(this.startNodeId);
            if (startNode != null) {
                this.nodeManager.acquireLock(startNode, LockType.WRITE);
                startNodeLocked = true;
            }
            if ((endNode = this.nodeManager.getLightNode(this.endNodeId)) != null) {
                this.nodeManager.acquireLock(endNode, LockType.WRITE);
                endNodeLocked = true;
            }
            this.nodeManager.deleteRelationship(this);
            if (startNode != null) {
                startNode.removeRelationship(this.type, this.id);
            }
            if (endNode != null) {
                endNode.removeRelationship(this.type, this.id);
            }
            success = true;
            Object var7_6 = null;
            releaseFailed2 = false;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            boolean releaseFailed2 = false;
            try {
                if (startNodeLocked) {
                    this.nodeManager.releaseLock(startNode, LockType.WRITE);
                }
            }
            catch (Exception e) {
                releaseFailed2 = true;
                e.printStackTrace();
            }
            try {
                if (endNodeLocked) {
                    this.nodeManager.releaseLock(endNode, LockType.WRITE);
                }
            }
            catch (Exception e) {
                releaseFailed2 = true;
                e.printStackTrace();
            }
            this.nodeManager.releaseLock(this, LockType.WRITE);
            if (!success) {
                this.setRollbackOnly();
            }
            if (releaseFailed2) {
                throw new LockException("Unable to release locks [" + startNode + "," + endNode + "] in relationship delete->" + this);
            }
            throw throwable;
        }
        try {
            if (startNodeLocked) {
                this.nodeManager.releaseLock(startNode, LockType.WRITE);
            }
        }
        catch (Exception e) {
            releaseFailed2 = true;
            e.printStackTrace();
        }
        try {
            if (endNodeLocked) {
                this.nodeManager.releaseLock(endNode, LockType.WRITE);
            }
        }
        catch (Exception e) {
            releaseFailed2 = true;
            e.printStackTrace();
        }
        this.nodeManager.releaseLock(this, LockType.WRITE);
        if (!success) {
            this.setRollbackOnly();
        }
        if (releaseFailed2) {
            throw new LockException("Unable to release locks [" + startNode + "," + endNode + "] in relationship delete->" + this);
        }
    }

    public String toString() {
        return "RelationshipImpl #" + this.getId() + " of type " + this.type + " between Node[" + this.startNodeId + "] and Node[" + this.endNodeId + "]";
    }

    @Override
    public int compareTo(Relationship r) {
        int theirId;
        int ourId = (int)this.getId();
        if (ourId < (theirId = (int)r.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Relationship)) {
            return false;
        }
        return this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return this.id;
    }
}

