/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.nioneo.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.impl.nioneo.store.Buffer;
import org.neo4j.impl.nioneo.store.LockableWindow;
import org.neo4j.impl.nioneo.store.UnderlyingStorageException;

abstract class AbstractPersistenceWindow
extends LockableWindow {
    private final int recordSize;
    private final long position;
    private Buffer buffer = null;
    private final int totalSize;
    private final int windowSize;

    AbstractPersistenceWindow(long position, int recordSize, int totalSize, FileChannel channel, ByteBuffer byteBuffer) {
        super(channel);
        assert (position >= 0L) : "Illegal position[" + position + "]";
        assert (recordSize > 0) : "Illegal recordSize[" + recordSize + "]";
        assert (channel != null) : "Null file channel";
        assert (totalSize >= recordSize);
        this.position = position;
        this.recordSize = recordSize;
        this.totalSize = totalSize;
        this.windowSize = totalSize / recordSize;
        this.buffer = new Buffer(this);
        this.buffer.setByteBuffer(byteBuffer);
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public Buffer getOffsettedBuffer(int id) {
        int offset = (int)(((long)id & 0xFFFFFFFFL) - this.buffer.position()) * this.recordSize;
        this.buffer.setOffset(offset);
        return this.buffer;
    }

    public long position() {
        return this.position;
    }

    void readPosition() {
        try {
            long fileSize = this.getFileChannel().size();
            long recordCount = fileSize / (long)this.recordSize;
            if (this.position > recordCount) {
                return;
            }
            ByteBuffer byteBuffer = this.buffer.getBuffer();
            byteBuffer.clear();
            this.getFileChannel().read(byteBuffer, this.position * (long)this.recordSize);
            byteBuffer.clear();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to load position[" + this.position + "] @[" + this.position * (long)this.recordSize + "]", e);
        }
    }

    void writeOut() {
        ByteBuffer byteBuffer = this.buffer.getBuffer();
        byteBuffer.clear();
        try {
            int count = this.getFileChannel().write(byteBuffer, this.position * (long)this.recordSize);
            assert (count == this.totalSize);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to write record[" + this.position + "] @[" + this.position * (long)this.recordSize + "]", e);
        }
    }

    public int size() {
        return this.windowSize;
    }

    public void force() {
        this.writeOut();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractPersistenceWindow)) {
            return false;
        }
        return this.position() == ((AbstractPersistenceWindow)o).position();
    }

    public int hashCode() {
        return (int)this.position;
    }

    public String toString() {
        return "PersistenceRow[" + this.position + "]";
    }

    public void close() {
        this.buffer.close();
    }
}

