/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.nioneo.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.Map;
import org.neo4j.impl.core.ReadOnlyNeoException;
import org.neo4j.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.impl.nioneo.store.IdGeneratorImpl;
import org.neo4j.impl.nioneo.store.InvalidIdGeneratorException;
import org.neo4j.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.impl.nioneo.store.UnderlyingStorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStore
extends CommonAbstractStore {
    public abstract int getRecordSize();

    protected static void createEmptyStore(String fileName, String typeAndVersionDescriptor) {
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        File file = new File(fileName);
        if (file.exists()) {
            throw new IllegalStateException("Can't create store[" + fileName + "], file already exists");
        }
        try {
            FileChannel channel = new FileOutputStream(fileName).getChannel();
            int endHeaderSize = typeAndVersionDescriptor.getBytes().length;
            ByteBuffer buffer = ByteBuffer.allocate(endHeaderSize);
            buffer.put(typeAndVersionDescriptor.getBytes()).flip();
            channel.write(buffer);
            channel.force(false);
            channel.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create store " + fileName, e);
        }
        IdGeneratorImpl.createGenerator(fileName + ".id");
    }

    public AbstractStore(String fileName, Map<?, ?> config) {
        super(fileName, config);
    }

    public AbstractStore(String fileName) {
        super(fileName);
    }

    @Override
    protected void loadStorage() {
        try {
            long fileSize = this.getFileChannel().size();
            String expectedVersion = this.getTypeAndVersionDescriptor();
            byte[] version = new byte[expectedVersion.getBytes().length];
            ByteBuffer buffer = ByteBuffer.wrap(version);
            if (fileSize >= (long)version.length) {
                this.getFileChannel().position(fileSize - (long)version.length);
            } else if (!this.isReadOnly()) {
                this.setStoreNotOk();
            }
            this.getFileChannel().read(buffer);
            if (!(expectedVersion.equals(new String(version)) || this.isReadOnly() || this.versionFound(new String(version)))) {
                this.setStoreNotOk();
            }
            if (this.getRecordSize() != 0 && (fileSize - (long)version.length) % (long)this.getRecordSize() != 0L && !this.isReadOnly()) {
                this.setStoreNotOk();
            }
            if (this.getStoreOk() && !this.isReadOnly()) {
                this.getFileChannel().truncate(fileSize - (long)version.length);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to load store " + this.getStorageFileName(), e);
        }
        try {
            if (!this.isReadOnly()) {
                this.openIdGenerator();
            } else {
                this.openReadOnlyIdGenerator(this.getRecordSize());
            }
        }
        catch (InvalidIdGeneratorException e) {
            this.setStoreNotOk();
        }
        this.setWindowPool(new PersistenceWindowPool(this.getStorageFileName(), this.getRecordSize(), this.getFileChannel(), this.getMappedMem(), this.getIfMemoryMapped(), this.isReadOnly()));
    }

    @Override
    public long getHighId() {
        return super.getHighId();
    }

    public void setHighId(int id) {
        super.setHighId(id);
    }

    protected void updateHighId() {
        try {
            long highId = this.getFileChannel().size() / (long)this.getRecordSize();
            this.setHighId(highId);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private int findHighIdBackwards() throws IOException {
        FileChannel fileChannel = this.getFileChannel();
        int recordSize = this.getRecordSize();
        long fileSize = fileChannel.size();
        long highId = fileSize / (long)recordSize;
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        for (long i = highId; i > 0L; --i) {
            fileChannel.position(i * (long)recordSize);
            if (fileChannel.read(byteBuffer) <= 0) continue;
            byteBuffer.flip();
            byte inUse = byteBuffer.get();
            byteBuffer.clear();
            if (inUse == 0) continue;
            return (int)i;
        }
        return 0;
    }

    @Override
    protected void rebuildIdGenerator() {
        if (this.isReadOnly()) {
            throw new ReadOnlyNeoException();
        }
        boolean RECORD_NOT_IN_USE = false;
        logger.fine("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
        this.closeIdGenerator();
        File file = new File(this.getStorageFileName() + ".id");
        if (file.exists()) {
            boolean success = file.delete();
            assert (success);
        }
        IdGeneratorImpl.createGenerator(this.getStorageFileName() + ".id");
        this.openIdGenerator();
        FileChannel fileChannel = this.getFileChannel();
        long highId = 1L;
        long defraggedCount = 0L;
        try {
            String mode;
            long fileSize = fileChannel.size();
            int recordSize = this.getRecordSize();
            boolean fullRebuild = true;
            if (this.getConfig() != null && (mode = (String)this.getConfig().get("rebuild_idgenerators_fast")) != null && mode.toLowerCase().equals("true")) {
                fullRebuild = false;
                highId = this.findHighIdBackwards();
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[1]);
            LinkedList<Integer> freeIdList = new LinkedList<Integer>();
            if (fullRebuild) {
                long i = 0L;
                while (i * (long)recordSize < fileSize && recordSize > 0) {
                    fileChannel.position(i * (long)recordSize);
                    fileChannel.read(byteBuffer);
                    byteBuffer.flip();
                    byte inUse = byteBuffer.get();
                    byteBuffer.flip();
                    this.nextId();
                    if (inUse == 0) {
                        freeIdList.add((int)i);
                    } else {
                        highId = i;
                        while (!freeIdList.isEmpty()) {
                            this.freeId((Integer)freeIdList.removeFirst());
                            ++defraggedCount;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
        }
        this.setHighId(highId + 1L);
        logger.fine("[" + this.getStorageFileName() + "] high id=" + this.getHighId() + " (defragged=" + defraggedCount + ")");
        this.closeIdGenerator();
        this.openIdGenerator();
    }
}

