/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.nioneo.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Random;
import org.neo4j.impl.nioneo.store.AbstractStore;
import org.neo4j.impl.nioneo.store.Buffer;
import org.neo4j.impl.nioneo.store.IllegalStoreVersionException;
import org.neo4j.impl.nioneo.store.NodeStore;
import org.neo4j.impl.nioneo.store.OperationType;
import org.neo4j.impl.nioneo.store.PersistenceWindow;
import org.neo4j.impl.nioneo.store.PropertyStore;
import org.neo4j.impl.nioneo.store.Record;
import org.neo4j.impl.nioneo.store.RelationshipStore;
import org.neo4j.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.impl.nioneo.store.UnderlyingStorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoStore
extends AbstractStore {
    private static final String VERSION = "NeoStore v0.9.5";
    private static final int RECORD_SIZE = 9;
    private NodeStore nodeStore;
    private PropertyStore propStore;
    private RelationshipStore relStore;
    private RelationshipTypeStore relTypeStore;
    private final int REL_GRAB_SIZE;
    private static final Random r = new Random(System.currentTimeMillis());

    public NeoStore(Map<?, ?> config) {
        super((String)config.get("neo_store"), config);
        String grabSize;
        this.REL_GRAB_SIZE = this.getConfig() != null ? ((grabSize = (String)this.getConfig().get("relationship_grab_size")) != null ? Integer.parseInt(grabSize) : 100) : 100;
    }

    public NeoStore(String fileName) {
        super(fileName);
        this.REL_GRAB_SIZE = 100;
    }

    @Override
    protected void initStorage() {
        this.relTypeStore = new RelationshipTypeStore(this.getStorageFileName() + ".relationshiptypestore.db", this.getConfig());
        this.propStore = new PropertyStore(this.getStorageFileName() + ".propertystore.db", this.getConfig());
        this.relStore = new RelationshipStore(this.getStorageFileName() + ".relationshipstore.db", this.getConfig());
        this.nodeStore = new NodeStore(this.getStorageFileName() + ".nodestore.db", this.getConfig());
    }

    @Override
    protected void closeStorage() {
        if (this.relTypeStore != null) {
            this.relTypeStore.close();
            this.relTypeStore = null;
        }
        if (this.propStore != null) {
            this.propStore.close();
            this.propStore = null;
        }
        if (this.relStore != null) {
            this.relStore.close();
            this.relStore = null;
        }
        if (this.nodeStore != null) {
            this.nodeStore.close();
            this.nodeStore = null;
        }
    }

    @Override
    public void flushAll() {
        this.relTypeStore.flushAll();
        this.propStore.flushAll();
        this.relStore.flushAll();
        this.nodeStore.flushAll();
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    @Override
    public int getRecordSize() {
        return 9;
    }

    public static void createStore(String fileName) {
        NeoStore.createEmptyStore(fileName, VERSION);
        NodeStore.createStore(fileName + ".nodestore.db");
        RelationshipStore.createStore(fileName + ".relationshipstore.db");
        PropertyStore.createStore(fileName + ".propertystore.db");
        RelationshipTypeStore.createStore(fileName + ".relationshiptypestore.db");
        NeoStore neoStore = new NeoStore(fileName);
        neoStore.nextId();
        neoStore.nextId();
        neoStore.nextId();
        long time = System.currentTimeMillis();
        neoStore.setCreationTime(time);
        neoStore.setRandomNumber(r.nextLong());
        neoStore.setVersion(0L);
        neoStore.close();
    }

    public long getCreationTime() {
        return this.getRecord(0);
    }

    public void setCreationTime(long time) {
        this.setRecord(0, time);
    }

    public long getRandomNumber() {
        return this.getRecord(1);
    }

    public void setRandomNumber(long nr) {
        this.setRecord(1, nr);
    }

    public void setRecoveredStatus(boolean status) {
        if (status) {
            this.setRecovered();
        } else {
            this.unsetRecovered();
        }
    }

    public long getVersion() {
        return this.getRecord(2);
    }

    public void setVersion(long version) {
        this.setRecord(2, version);
    }

    public long incrementVersion() {
        long current = this.getVersion();
        this.setVersion(current + 1L);
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRecord(int id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            Buffer buffer = window.getOffsettedBuffer(id);
            buffer.get();
            long l = buffer.getLong();
            return l;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRecord(int id, long value) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.WRITE);
        try {
            Buffer buffer = window.getOffsettedBuffer(id);
            buffer.put(Record.IN_USE.byteValue()).putLong(value);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    public NodeStore getNodeStore() {
        return this.nodeStore;
    }

    public RelationshipStore getRelationshipStore() {
        return this.relStore;
    }

    public RelationshipTypeStore getRelationshipTypeStore() {
        return this.relTypeStore;
    }

    public PropertyStore getPropertyStore() {
        return this.propStore;
    }

    @Override
    public void makeStoreOk() {
        this.relTypeStore.makeStoreOk();
        this.propStore.makeStoreOk();
        this.relStore.makeStoreOk();
        this.nodeStore.makeStoreOk();
        super.makeStoreOk();
    }

    @Override
    public void rebuildIdGenerators() {
        this.relTypeStore.rebuildIdGenerators();
        this.propStore.rebuildIdGenerators();
        this.relStore.rebuildIdGenerators();
        this.nodeStore.rebuildIdGenerators();
        super.rebuildIdGenerators();
    }

    public void updateIdGenerators() {
        this.updateHighId();
        this.relTypeStore.updateIdGenerators();
        this.propStore.updateIdGenerators();
        this.relStore.updateHighId();
        this.nodeStore.updateHighId();
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("NeoStore")) {
            return false;
        }
        if (version.equals("NeoStore v0.9.3")) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[27]);
            long time = System.currentTimeMillis();
            long random = r.nextLong();
            buffer.put(Record.IN_USE.byteValue()).putLong(time);
            buffer.put(Record.IN_USE.byteValue()).putLong(random);
            buffer.put(Record.IN_USE.byteValue()).putLong(0L);
            buffer.flip();
            try {
                this.getFileChannel().write(buffer, 0L);
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
            this.rebuildIdGenerator();
            this.closeIdGenerator();
            return true;
        }
        if (version.equals("NeoStore v0.9.4")) {
            this.rebuildIdGenerator();
            this.closeIdGenerator();
            return true;
        }
        throw new IllegalStoreVersionException("Store version [" + version + "]. Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }

    public int getRelationshipGrabSize() {
        return this.REL_GRAB_SIZE;
    }
}

