/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.nioneo.xa;

import java.util.ArrayList;
import org.neo4j.impl.nioneo.store.InvalidRecordException;
import org.neo4j.impl.nioneo.store.NeoStore;
import org.neo4j.impl.nioneo.store.NodeRecord;
import org.neo4j.impl.nioneo.store.NodeStore;
import org.neo4j.impl.nioneo.store.PropertyData;
import org.neo4j.impl.nioneo.store.PropertyIndexData;
import org.neo4j.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.impl.nioneo.store.PropertyRecord;
import org.neo4j.impl.nioneo.store.PropertyStore;
import org.neo4j.impl.nioneo.store.PropertyType;
import org.neo4j.impl.nioneo.store.Record;
import org.neo4j.impl.nioneo.store.RelationshipChainPosition;
import org.neo4j.impl.nioneo.store.RelationshipData;
import org.neo4j.impl.nioneo.store.RelationshipRecord;
import org.neo4j.impl.nioneo.store.RelationshipStore;
import org.neo4j.impl.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NeoReadTransaction {
    private final NeoStore neoStore;

    public NeoReadTransaction(NeoStore neoStore) {
        this.neoStore = neoStore;
    }

    private NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    private int getRelGrabSize() {
        return this.neoStore.getRelationshipGrabSize();
    }

    private RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    private PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    public boolean nodeLoadLight(int nodeId) {
        return this.getNodeStore().loadLightNode(nodeId);
    }

    public RelationshipData relationshipLoad(int id) {
        RelationshipRecord relRecord = this.getRelationshipStore().getLightRel(id);
        if (relRecord != null) {
            return new RelationshipData(id, relRecord.getFirstNode(), relRecord.getSecondNode(), relRecord.getType());
        }
        return null;
    }

    public RelationshipChainPosition getRelationshipChainPosition(int nodeId) {
        NodeRecord nodeRecord = this.getNodeStore().getRecord(nodeId);
        int nextRel = nodeRecord.getNextRel();
        return new RelationshipChainPosition(nextRel);
    }

    public Iterable<RelationshipData> getMoreRelationships(int nodeId, RelationshipChainPosition position) {
        int nextRel = position.getNextRecord();
        ArrayList<RelationshipData> rels = new ArrayList<RelationshipData>();
        for (int i = 0; i < this.getRelGrabSize() && nextRel != Record.NO_NEXT_RELATIONSHIP.intValue(); ++i) {
            RelationshipRecord relRecord = this.getRelationshipStore().getChainRecord(nextRel);
            if (relRecord == null) {
                position.setNextRecord(Record.NO_NEXT_RELATIONSHIP.intValue());
                return rels;
            }
            int firstNode = relRecord.getFirstNode();
            int secondNode = relRecord.getSecondNode();
            if (relRecord.inUse()) {
                rels.add(new RelationshipData(relRecord.getId(), firstNode, secondNode, relRecord.getType()));
            } else {
                --i;
            }
            if (firstNode == nodeId) {
                nextRel = relRecord.getFirstNextRel();
                continue;
            }
            if (secondNode == nodeId) {
                nextRel = relRecord.getSecondNextRel();
                continue;
            }
            throw new InvalidRecordException("Node[" + nodeId + "] not part of firstNode[" + firstNode + "] or secondNode[" + secondNode + "]");
        }
        position.setNextRecord(nextRel);
        return rels;
    }

    public ArrayMap<Integer, PropertyData> relGetProperties(int relId) {
        RelationshipRecord relRecord = this.getRelationshipStore().getRecord(relId);
        if (!relRecord.inUse()) {
            throw new InvalidRecordException("Relationship[" + relId + "] not in use");
        }
        int nextProp = relRecord.getNextProp();
        ArrayMap<Integer, PropertyData> propertyMap = new ArrayMap<Integer, PropertyData>(9, false, true);
        while (nextProp != Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.getPropertyStore().getLightRecord(nextProp);
            propertyMap.put(propRecord.getKeyIndexId(), new PropertyData(propRecord.getId(), this.propertyGetValueOrNull(propRecord)));
            nextProp = propRecord.getNextProp();
        }
        return propertyMap;
    }

    ArrayMap<Integer, PropertyData> nodeGetProperties(int nodeId) {
        NodeRecord nodeRecord = this.getNodeStore().getRecord(nodeId);
        int nextProp = nodeRecord.getNextProp();
        ArrayMap<Integer, PropertyData> propertyMap = new ArrayMap<Integer, PropertyData>(9, false, true);
        while (nextProp != Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propRecord = this.getPropertyStore().getLightRecord(nextProp);
            propertyMap.put(propRecord.getKeyIndexId(), new PropertyData(propRecord.getId(), this.propertyGetValueOrNull(propRecord)));
            nextProp = propRecord.getNextProp();
        }
        return propertyMap;
    }

    public Object propertyGetValueOrNull(PropertyRecord propertyRecord) {
        PropertyType type = propertyRecord.getType();
        if (type == PropertyType.INT) {
            return (int)propertyRecord.getPropBlock();
        }
        if (type == PropertyType.STRING) {
            return null;
        }
        if (type == PropertyType.BOOL) {
            if (propertyRecord.getPropBlock() == 1L) {
                return true;
            }
            return false;
        }
        if (type == PropertyType.DOUBLE) {
            return new Double(Double.longBitsToDouble(propertyRecord.getPropBlock()));
        }
        if (type == PropertyType.FLOAT) {
            return new Float(Float.intBitsToFloat((int)propertyRecord.getPropBlock()));
        }
        if (type == PropertyType.LONG) {
            return propertyRecord.getPropBlock();
        }
        if (type == PropertyType.BYTE) {
            return (byte)propertyRecord.getPropBlock();
        }
        if (type == PropertyType.CHAR) {
            return Character.valueOf((char)propertyRecord.getPropBlock());
        }
        if (type == PropertyType.ARRAY) {
            return null;
        }
        if (type == PropertyType.SHORT) {
            return (short)propertyRecord.getPropBlock();
        }
        throw new InvalidRecordException("Unknown type: " + (Object)((Object)type) + " on " + propertyRecord);
    }

    public Object propertyGetValue(int id) {
        PropertyType type;
        PropertyRecord propertyRecord = this.getPropertyStore().getRecord(id);
        if (propertyRecord.isLight()) {
            this.getPropertyStore().makeHeavy(propertyRecord);
        }
        if ((type = propertyRecord.getType()) == PropertyType.INT) {
            return (int)propertyRecord.getPropBlock();
        }
        if (type == PropertyType.STRING) {
            return this.getPropertyStore().getStringFor(propertyRecord);
        }
        if (type == PropertyType.BOOL) {
            if (propertyRecord.getPropBlock() == 1L) {
                return true;
            }
            return false;
        }
        if (type == PropertyType.DOUBLE) {
            return new Double(Double.longBitsToDouble(propertyRecord.getPropBlock()));
        }
        if (type == PropertyType.FLOAT) {
            return new Float(Float.intBitsToFloat((int)propertyRecord.getPropBlock()));
        }
        if (type == PropertyType.LONG) {
            return propertyRecord.getPropBlock();
        }
        if (type == PropertyType.BYTE) {
            return (byte)propertyRecord.getPropBlock();
        }
        if (type == PropertyType.CHAR) {
            return Character.valueOf((char)propertyRecord.getPropBlock());
        }
        if (type == PropertyType.ARRAY) {
            return this.getPropertyStore().getArrayFor(propertyRecord);
        }
        if (type == PropertyType.SHORT) {
            return (short)propertyRecord.getPropBlock();
        }
        throw new InvalidRecordException("Unkown type: " + (Object)((Object)type) + " on " + propertyRecord);
    }

    String getPropertyIndex(int id) {
        PropertyIndexStore indexStore = this.getPropertyStore().getIndexStore();
        PropertyIndexRecord index = indexStore.getRecord(id);
        if (index.isLight()) {
            indexStore.makeHeavy(index);
        }
        return indexStore.getStringFor(index);
    }

    PropertyIndexData[] getPropertyIndexes(int count) {
        PropertyIndexStore indexStore = this.getPropertyStore().getIndexStore();
        return indexStore.getPropertyIndexes(count);
    }
}

