/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.transaction;

import java.util.Iterator;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.impl.core.ReadOnlyNeoException;
import org.neo4j.impl.transaction.ReadOnlyTransactionImpl;
import org.neo4j.impl.transaction.TransactionImpl;
import org.neo4j.impl.transaction.XaDataSourceManager;
import org.neo4j.impl.transaction.xaframework.XaResource;
import org.neo4j.impl.util.ArrayMap;

class ReadOnlyTxManager
implements TransactionManager {
    private static Logger log = Logger.getLogger(ReadOnlyTxManager.class.getName());
    private ArrayMap<Thread, ReadOnlyTransactionImpl> txThreadMap;
    private int eventIdentifierCounter = 0;
    private XaDataSourceManager xaDsManager = null;

    ReadOnlyTxManager() {
    }

    synchronized int getNextEventIdentifier() {
        return this.eventIdentifierCounter++;
    }

    void stop() {
    }

    void init(XaDataSourceManager xaDsManagerToUse) {
        this.xaDsManager = xaDsManagerToUse;
        this.txThreadMap = new ArrayMap(5, true, true);
    }

    public void begin() throws NotSupportedException {
        Thread thread = Thread.currentThread();
        ReadOnlyTransactionImpl tx = this.txThreadMap.get(thread);
        if (tx != null) {
            throw new NotSupportedException("Nested transactions not supported");
        }
        tx = new ReadOnlyTransactionImpl(this);
        this.txThreadMap.put(thread, tx);
    }

    public void commit() throws RollbackException, HeuristicMixedException, IllegalStateException {
        Thread thread = Thread.currentThread();
        ReadOnlyTransactionImpl tx = this.txThreadMap.get(thread);
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        if (tx.getStatus() != 0 && tx.getStatus() != 1) {
            throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
        }
        tx.doBeforeCompletion();
        if (tx.getStatus() == 0) {
            this.commit(thread, tx);
        } else if (tx.getStatus() == 1) {
            this.rollbackCommit(thread, tx);
        } else {
            throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
        }
    }

    private void commit(Thread thread, ReadOnlyTransactionImpl tx) {
        if (tx.getResourceCount() != 0) {
            throw new ReadOnlyNeoException();
        }
        tx.setStatus(3);
        tx.doAfterCompletion();
        this.txThreadMap.remove(thread);
        tx.setStatus(6);
    }

    private void rollbackCommit(Thread thread, ReadOnlyTransactionImpl tx) throws HeuristicMixedException, RollbackException {
        try {
            tx.doRollback();
        }
        catch (XAException e) {
            e.printStackTrace();
            log.severe("Unable to rollback marked transaction. Some resources may be commited others not. Neo should be SHUTDOWN or FREEZED for resource maintance and transaction recovery ---->");
            throw new HeuristicMixedException("Unable to rollback  ---> error code for rollback: " + e.errorCode);
        }
        tx.doAfterCompletion();
        this.txThreadMap.remove(thread);
        tx.setStatus(6);
        throw new RollbackException("Failed to commit, transaction rolledback");
    }

    public void rollback() throws IllegalStateException, SystemException {
        Thread thread = Thread.currentThread();
        ReadOnlyTransactionImpl tx = this.txThreadMap.get(thread);
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        if (tx.getStatus() == 0 || tx.getStatus() == 1 || tx.getStatus() == 7) {
            tx.doBeforeCompletion();
            try {
                tx.doRollback();
            }
            catch (XAException e) {
                e.printStackTrace();
                log.severe("Unable to rollback marked or active transaction. Some resources may be commited others not. Neo should be SHUTDOWN or FREEZED for resource maintance and transaction recovery ---->");
                throw new SystemException("Unable to rollback  ---> error code for rollback: " + e.errorCode);
            }
        } else {
            throw new IllegalStateException("Tx status is: " + this.getTxStatusAsString(tx.getStatus()));
        }
        tx.doAfterCompletion();
        this.txThreadMap.remove(thread);
        tx.setStatus(6);
    }

    public int getStatus() {
        Thread thread = Thread.currentThread();
        ReadOnlyTransactionImpl tx = this.txThreadMap.get(thread);
        if (tx != null) {
            return tx.getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() {
        return this.txThreadMap.get(Thread.currentThread());
    }

    public void resume(Transaction tx) throws IllegalStateException {
        ReadOnlyTransactionImpl txImpl;
        Thread thread = Thread.currentThread();
        if (this.txThreadMap.get(thread) != null) {
            throw new IllegalStateException("Transaction already associated");
        }
        if (tx != null && (txImpl = (ReadOnlyTransactionImpl)tx).getStatus() != 6) {
            txImpl.markAsActive();
            this.txThreadMap.put(thread, txImpl);
        }
    }

    public Transaction suspend() {
        ReadOnlyTransactionImpl tx = this.txThreadMap.remove(Thread.currentThread());
        if (tx != null) {
            tx.markAsSuspended();
        }
        return tx;
    }

    public void setRollbackOnly() throws IllegalStateException {
        Thread thread = Thread.currentThread();
        ReadOnlyTransactionImpl tx = this.txThreadMap.get(thread);
        if (tx == null) {
            throw new IllegalStateException("Not in transaction");
        }
        tx.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) {
    }

    byte[] getBranchId(XAResource xaRes) {
        byte[] branchId;
        if (xaRes instanceof XaResource && (branchId = ((XaResource)xaRes).getBranchId()) != null) {
            return branchId;
        }
        return this.xaDsManager.getBranchId(xaRes);
    }

    XAResource getXaResource(byte[] branchId) {
        return this.xaDsManager.getXaResource(branchId);
    }

    String getTxStatusAsString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 8: {
                return "STATUS_COMMITING";
            }
            case 3: {
                return "STATUS_COMMITED";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
        }
        return "STATUS_UNKNOWN(" + status + ")";
    }

    public synchronized void dumpTransactions() {
        Iterator<ReadOnlyTransactionImpl> itr = this.txThreadMap.values().iterator();
        if (!itr.hasNext()) {
            System.out.println("No uncompleted transactions");
            return;
        }
        System.out.println("Uncompleted transactions found: ");
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
    }

    public int getEventIdentifier() {
        TransactionImpl tx = (TransactionImpl)this.getTransaction();
        if (tx != null) {
            return tx.getEventIdentifier();
        }
        return -1;
    }
}

