/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.impl.transaction.xaframework.LogBuffer;

class MemoryMappedLogBuffer
implements LogBuffer {
    private static final int MAPPED_SIZE = 0x200000;
    private final FileChannel fileChannel;
    private MappedByteBuffer mappedBuffer = null;
    private long mappedStartPosition;
    private final ByteBuffer fallbackBuffer;
    private int mapFail = -1;

    MemoryMappedLogBuffer(FileChannel fileChannel) throws IOException {
        this.fileChannel = fileChannel;
        this.mappedStartPosition = fileChannel.position();
        this.getNewMappedBuffer();
        this.fallbackBuffer = ByteBuffer.allocateDirect(713);
    }

    MappedByteBuffer getMappedBuffer() {
        return this.mappedBuffer;
    }

    private void getNewMappedBuffer() {
        try {
            if (this.mappedBuffer != null) {
                this.mappedStartPosition += (long)this.mappedBuffer.position();
                this.mappedBuffer.force();
                this.mappedBuffer = null;
            }
            if (this.mapFail > 1000) {
                this.mapFail = -1;
            }
            if (this.mapFail > 0) {
                ++this.mapFail;
                return;
            }
            this.mappedBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, this.mappedStartPosition, 0x200000L);
        }
        catch (Throwable t) {
            this.mapFail = 1;
            t.printStackTrace();
        }
    }

    public LogBuffer put(byte b) throws IOException {
        if (this.mappedBuffer == null || 0x200000 - this.mappedBuffer.position() < 1) {
            this.getNewMappedBuffer();
            if (this.mappedBuffer == null) {
                this.fallbackBuffer.clear();
                this.fallbackBuffer.put(b);
                this.fallbackBuffer.flip();
                this.fileChannel.write(this.fallbackBuffer, this.mappedStartPosition);
                ++this.mappedStartPosition;
                return this;
            }
        }
        this.mappedBuffer.put(b);
        return this;
    }

    public LogBuffer putInt(int i) throws IOException {
        if (this.mappedBuffer == null || 0x200000 - this.mappedBuffer.position() < 4) {
            this.getNewMappedBuffer();
            if (this.mappedBuffer == null) {
                this.fallbackBuffer.clear();
                this.fallbackBuffer.putInt(i);
                this.fallbackBuffer.flip();
                this.fileChannel.write(this.fallbackBuffer, this.mappedStartPosition);
                this.mappedStartPosition += 4L;
                return this;
            }
        }
        this.mappedBuffer.putInt(i);
        return this;
    }

    public LogBuffer putLong(long l) throws IOException {
        if (this.mappedBuffer == null || 0x200000 - this.mappedBuffer.position() < 8) {
            this.getNewMappedBuffer();
            if (this.mappedBuffer == null) {
                this.fallbackBuffer.clear();
                this.fallbackBuffer.putLong(l);
                this.fallbackBuffer.flip();
                this.fileChannel.write(this.fallbackBuffer, this.mappedStartPosition);
                this.mappedStartPosition += 8L;
                return this;
            }
        }
        this.mappedBuffer.putLong(l);
        return this;
    }

    public LogBuffer put(byte[] bytes) throws IOException {
        if (this.mappedBuffer == null || 0x200000 - this.mappedBuffer.position() < bytes.length) {
            this.getNewMappedBuffer();
            if (this.mappedBuffer == null) {
                this.fallbackBuffer.clear();
                this.fallbackBuffer.put(bytes);
                this.fallbackBuffer.flip();
                this.fileChannel.write(this.fallbackBuffer, this.mappedStartPosition);
                this.mappedStartPosition += (long)bytes.length;
                return this;
            }
        }
        this.mappedBuffer.put(bytes);
        return this;
    }

    public LogBuffer put(char[] chars) throws IOException {
        if (this.mappedBuffer == null || 0x200000 - this.mappedBuffer.position() < chars.length * 2) {
            this.getNewMappedBuffer();
            if (this.mappedBuffer == null) {
                this.fallbackBuffer.clear();
                this.fallbackBuffer.asCharBuffer().put(chars);
                this.fallbackBuffer.limit(chars.length * 2);
                this.fileChannel.write(this.fallbackBuffer, this.mappedStartPosition);
                this.mappedStartPosition += (long)(chars.length * 2);
                return this;
            }
        }
        int oldPos = this.mappedBuffer.position();
        this.mappedBuffer.asCharBuffer().put(chars);
        this.mappedBuffer.position(oldPos + chars.length * 2);
        return this;
    }

    void releaseMemoryMapped() {
        if (this.mappedBuffer != null) {
            this.mappedBuffer.force();
            this.mappedBuffer = null;
        }
    }

    public void force() throws IOException {
        if (this.mappedBuffer != null) {
            this.mappedBuffer.force();
        }
        this.fileChannel.force(false);
    }

    public long getFileChannelPosition() {
        if (this.mappedBuffer != null) {
            return this.mappedStartPosition + (long)this.mappedBuffer.position();
        }
        return this.mappedStartPosition;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }
}

