/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.neo4j.impl.transaction.TransactionFailureException;
import org.neo4j.impl.transaction.XidImpl;
import org.neo4j.impl.transaction.xaframework.DirectLogBuffer;
import org.neo4j.impl.transaction.xaframework.DirectMappedLogBuffer;
import org.neo4j.impl.transaction.xaframework.LogBuffer;
import org.neo4j.impl.transaction.xaframework.MemoryMappedLogBuffer;
import org.neo4j.impl.transaction.xaframework.XaCommand;
import org.neo4j.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.impl.transaction.xaframework.XaTransaction;
import org.neo4j.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.impl.util.ArrayMap;
import org.neo4j.impl.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XaLogicalLog {
    private Logger log;
    private static final byte EMPTY = 0;
    private static final byte TX_START = 1;
    private static final byte TX_PREPARE = 2;
    private static final byte COMMAND = 3;
    private static final byte DONE = 4;
    private static final byte TX_1P_COMMIT = 5;
    private static final byte TX_2P_COMMIT = 6;
    private static final char CLEAN = 'C';
    private static final char LOG1 = '1';
    private static final char LOG2 = '2';
    private FileChannel fileChannel = null;
    private final ByteBuffer buffer;
    private LogBuffer writeBuffer = null;
    private long logVersion = 0L;
    private ArrayMap<Integer, StartEntry> xidIdentMap = new ArrayMap(4, false, true);
    private Map<Integer, XaTransaction> recoveredTxMap = new HashMap<Integer, XaTransaction>();
    private int nextIdentifier = 1;
    private boolean scanIsComplete = false;
    private String fileName = null;
    private final XaResourceManager xaRm;
    private final XaCommandFactory cf;
    private final XaTransactionFactory xaTf;
    private char currentLog = (char)67;
    private boolean keepLogs = false;
    private boolean autoRotate = true;
    private long rotateAtSize = 0xA00000L;
    private boolean backupSlave = false;
    private boolean useMemoryMapped = true;
    private ArrayMap<Thread, Integer> txIdentMap = new ArrayMap(5, true, true);

    XaLogicalLog(String fileName, XaResourceManager xaRm, XaCommandFactory cf, XaTransactionFactory xaTf, Map<Object, Object> config) {
        this.fileName = fileName;
        this.xaRm = xaRm;
        this.cf = cf;
        this.xaTf = xaTf;
        this.useMemoryMapped = this.getMemoryMapped(config);
        this.log = Logger.getLogger(this.getClass().getName() + "/" + fileName);
        this.buffer = ByteBuffer.allocateDirect(713);
    }

    private boolean getMemoryMapped(Map<Object, Object> config) {
        String value;
        return config == null || (value = (String)config.get("use_memory_mapped_buffers")) == null || !value.toLowerCase().equals("false");
    }

    synchronized void open() throws IOException {
        String activeFileName = this.fileName + ".active";
        if (!new File(activeFileName).exists()) {
            if (new File(this.fileName).exists()) {
                this.open(this.fileName);
            } else {
                this.setActiveLog('1');
                this.open(this.fileName + ".1");
            }
        } else {
            FileChannel fc = new RandomAccessFile(activeFileName, "rw").getChannel();
            byte[] bytes = new byte[256];
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            int read = fc.read(buf);
            fc.close();
            if (read != 4) {
                throw new IllegalStateException("Read " + read + " bytes from " + activeFileName + " but expected 4");
            }
            buf.flip();
            char c = buf.asCharBuffer().get();
            File copy = new File(this.fileName + ".copy");
            if (copy.exists() && !copy.delete()) {
                this.log.warning("Unable to delete " + copy.getName());
            }
            if (c == 'C') {
                String newLog = this.fileName + ".1";
                if (new File(newLog).exists()) {
                    throw new IllegalStateException("Active marked as clean but log " + newLog + " exist");
                }
                this.setActiveLog('1');
                this.open(newLog);
            } else if (c == '1') {
                String newLog = this.fileName + ".1";
                if (!new File(newLog).exists()) {
                    throw new IllegalStateException("Active marked as 1 but no " + newLog + " exist");
                }
                this.currentLog = (char)49;
                File otherLog = new File(this.fileName + ".2");
                if (otherLog.exists() && !otherLog.delete()) {
                    this.log.warning("Unable to delete " + copy.getName());
                }
                this.open(newLog);
            } else if (c == '2') {
                String newLog = this.fileName + ".2";
                if (!new File(newLog).exists()) {
                    throw new IllegalStateException("Active marked as 2 but no " + newLog + " exist");
                }
                File otherLog = new File(this.fileName + ".1");
                if (otherLog.exists() && !otherLog.delete()) {
                    this.log.warning("Unable to delete " + copy.getName());
                }
                this.currentLog = (char)50;
                this.open(newLog);
            } else {
                throw new IllegalStateException("Unknown active log: " + c);
            }
        }
        this.writeBuffer = !this.useMemoryMapped ? new DirectMappedLogBuffer(this.fileChannel) : new MemoryMappedLogBuffer(this.fileChannel);
    }

    private void open(String fileToOpen) throws IOException {
        this.fileChannel = new RandomAccessFile(fileToOpen, "rw").getChannel();
        if (this.fileChannel.size() != 0L) {
            this.doInternalRecovery(fileToOpen);
        } else {
            this.logVersion = this.xaTf.getCurrentVersion();
            this.buffer.clear();
            this.buffer.putLong(this.logVersion);
            this.buffer.flip();
            this.fileChannel.write(this.buffer);
            this.scanIsComplete = true;
        }
    }

    public boolean scanIsComplete() {
        return this.scanIsComplete;
    }

    private int getNextIdentifier() {
        ++this.nextIdentifier;
        if (this.nextIdentifier < 0) {
            this.nextIdentifier = 1;
        }
        return this.nextIdentifier;
    }

    public synchronized int start(Xid xid) throws XAException {
        if (this.backupSlave) {
            throw new XAException("Resource is configured as backup slave, no new transactions can be started for " + this.fileName + "." + this.currentLog);
        }
        int xidIdent = this.getNextIdentifier();
        try {
            byte[] globalId = xid.getGlobalTransactionId();
            byte[] branchId = xid.getBranchQualifier();
            int formatId = xid.getFormatId();
            long position = this.writeBuffer.getFileChannelPosition();
            this.writeBuffer.put((byte)1).put((byte)globalId.length).put((byte)branchId.length).put(globalId).put(branchId).putInt(xidIdent).putInt(formatId);
            this.xidIdentMap.put(xidIdent, new StartEntry(xid, position));
        }
        catch (IOException e) {
            throw new XAException("Logical log couldn't start transaction: " + e);
        }
        return xidIdent;
    }

    private boolean readTxStartEntry() throws IOException {
        long position = this.fileChannel.position();
        this.buffer.clear();
        this.buffer.limit(1);
        if (this.fileChannel.read(this.buffer) != this.buffer.limit()) {
            return false;
        }
        this.buffer.flip();
        byte globalIdLength = this.buffer.get();
        this.buffer.clear();
        this.buffer.limit(1);
        if (this.fileChannel.read(this.buffer) != this.buffer.limit()) {
            return false;
        }
        this.buffer.flip();
        byte branchIdLength = this.buffer.get();
        byte[] globalId = new byte[globalIdLength];
        ByteBuffer tmpBuffer = ByteBuffer.wrap(globalId);
        if (this.fileChannel.read(tmpBuffer) != globalId.length) {
            return false;
        }
        byte[] branchId = new byte[branchIdLength];
        tmpBuffer = ByteBuffer.wrap(branchId);
        if (this.fileChannel.read(tmpBuffer) != branchId.length) {
            return false;
        }
        this.buffer.clear();
        this.buffer.limit(4);
        if (this.fileChannel.read(this.buffer) != this.buffer.limit()) {
            return false;
        }
        this.buffer.flip();
        int identifier = this.buffer.getInt();
        if (identifier >= this.nextIdentifier) {
            this.nextIdentifier = identifier + 1;
        }
        this.buffer.clear();
        this.buffer.limit(4);
        if (this.fileChannel.read(this.buffer) != this.buffer.limit()) {
            return false;
        }
        this.buffer.flip();
        int formatId = this.buffer.getInt();
        XidImpl xid = new XidImpl(globalId, branchId, formatId);
        this.xidIdentMap.put(identifier, new StartEntry(xid, position));
        XaTransaction xaTx = this.xaTf.create(identifier);
        xaTx.setRecovered();
        this.recoveredTxMap.put(identifier, xaTx);
        this.xaRm.injectStart(xid, xaTx);
        return true;
    }

    public synchronized void prepare(int identifier) throws XAException {
        assert (this.xidIdentMap.get(identifier) != null);
        try {
            this.writeBuffer.put((byte)2).putInt(identifier);
            this.writeBuffer.force();
        }
        catch (IOException e) {
            throw new XAException("Logical log unable to mark prepare [" + identifier + "] " + e);
        }
    }

    private boolean readTxPrepareEntry() throws IOException {
        this.buffer.clear();
        this.buffer.limit(4);
        if (this.fileChannel.read(this.buffer) != this.buffer.limit()) {
            return false;
        }
        this.buffer.flip();
        int identifier = this.buffer.getInt();
        StartEntry entry = this.xidIdentMap.get(identifier);
        if (entry == null) {
            return false;
        }
        Xid xid = entry.getXid();
        if (this.xaRm.injectPrepare(xid)) {
            this.xidIdentMap.remove(identifier);
            this.recoveredTxMap.remove(identifier);
        }
        return true;
    }

    public synchronized void commitOnePhase(int identifier) throws XAException {
        assert (this.xidIdentMap.get(identifier) != null);
        try {
            this.writeBuffer.put((byte)5).putInt(identifier);
            this.writeBuffer.force();
        }
        catch (IOException e) {
            throw new XAException("Logical log unable to mark 1P-commit [" + identifier + "] " + e);
        }
    }

    private boolean readTxOnePhaseCommit() throws IOException {
        this.buffer.clear();
        this.buffer.limit(4);
        if (this.fileChannel.read(this.buffer) != this.buffer.limit()) {
            return false;
        }
        this.buffer.flip();
        int identifier = this.buffer.getInt();
        StartEntry entry = this.xidIdentMap.get(identifier);
        if (entry == null) {
            return false;
        }
        Xid xid = entry.getXid();
        try {
            this.xaRm.injectOnePhaseCommit(xid);
        }
        catch (XAException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        return true;
    }

    public synchronized void done(int identifier) throws XAException {
        if (this.backupSlave) {
            return;
        }
        assert (this.xidIdentMap.get(identifier) != null);
        try {
            this.writeBuffer.put((byte)4).putInt(identifier);
            this.xidIdentMap.remove(identifier);
        }
        catch (IOException e) {
            throw new XAException("Logical log unable to mark as done [" + identifier + "] " + e);
        }
    }

    synchronized void doneInternal(int identifier) throws IOException {
        this.buffer.clear();
        this.buffer.put((byte)4).putInt(identifier);
        this.buffer.flip();
        this.fileChannel.write(this.buffer);
        this.xidIdentMap.remove(identifier);
    }

    private boolean readDoneEntry() throws IOException {
        this.buffer.clear();
        this.buffer.limit(4);
        if (this.fileChannel.read(this.buffer) != this.buffer.limit()) {
            return false;
        }
        this.buffer.flip();
        int identifier = this.buffer.getInt();
        StartEntry entry = this.xidIdentMap.get(identifier);
        if (entry == null) {
            return false;
        }
        Xid xid = entry.getXid();
        this.xaRm.pruneXid(xid);
        this.xidIdentMap.remove(identifier);
        this.recoveredTxMap.remove(identifier);
        return true;
    }

    public synchronized void commitTwoPhase(int identifier) throws XAException {
        assert (this.xidIdentMap.get(identifier) != null);
        try {
            this.writeBuffer.put((byte)6).putInt(identifier);
            this.writeBuffer.force();
        }
        catch (IOException e) {
            throw new XAException("Logical log unable to mark 2PC [" + identifier + "] " + e);
        }
    }

    private boolean readTxTwoPhaseCommit() throws IOException {
        this.buffer.clear();
        this.buffer.limit(4);
        if (this.fileChannel.read(this.buffer) != this.buffer.limit()) {
            return false;
        }
        this.buffer.flip();
        int identifier = this.buffer.getInt();
        StartEntry entry = this.xidIdentMap.get(identifier);
        if (entry == null) {
            return false;
        }
        Xid xid = entry.getXid();
        if (xid == null) {
            return false;
        }
        try {
            this.xaRm.injectTwoPhaseCommit(xid);
        }
        catch (XAException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        return true;
    }

    public synchronized void writeCommand(XaCommand command, int identifier) throws IOException {
        this.checkLogRotation();
        assert (this.xidIdentMap.get(identifier) != null);
        this.writeBuffer.put((byte)3).putInt(identifier);
        command.writeToFile(this.writeBuffer);
    }

    private boolean readCommandEntry() throws IOException {
        this.buffer.clear();
        this.buffer.limit(4);
        if (this.fileChannel.read(this.buffer) != this.buffer.limit()) {
            return false;
        }
        this.buffer.flip();
        int identifier = this.buffer.getInt();
        XaCommand command = this.cf.readCommand(this.fileChannel, this.buffer);
        if (command == null) {
            return false;
        }
        command.setRecovered();
        XaTransaction xaTx = this.recoveredTxMap.get(identifier);
        xaTx.injectCommand(command);
        return true;
    }

    private void checkLogRotation() throws IOException {
        long firstStartEntry;
        long currentPos;
        if (this.autoRotate && this.writeBuffer.getFileChannelPosition() >= this.rotateAtSize && (currentPos = this.writeBuffer.getFileChannelPosition()) - (firstStartEntry = this.getFirstStartEntry(currentPos)) < this.rotateAtSize / 2L) {
            this.rotate();
        }
    }

    private void renameCurrentLogFileAndIncrementVersion(String logFileName, long endPosition) throws IOException {
        this.releaseCurrentLogFile();
        File file = new File(logFileName);
        if (!file.exists()) {
            throw new IOException("Logical log[" + logFileName + "] not found");
        }
        String newName = this.fileName + ".v" + this.xaTf.getAndSetNewVersion();
        File newFile = new File(newName);
        boolean renamed = FileUtils.renameFile(file, newFile);
        if (!renamed) {
            throw new IOException("Failed to rename log to: " + newName);
        }
        try {
            FileChannel channel = new RandomAccessFile(newName, "rw").getChannel();
            FileUtils.truncateFile(channel, endPosition);
        }
        catch (IOException e) {
            this.log.log(Level.WARNING, "Failed to truncate log at correct size", e);
        }
    }

    private void deleteCurrentLogFile(String logFileName) throws IOException {
        this.releaseCurrentLogFile();
        File file = new File(logFileName);
        if (!file.exists()) {
            throw new IOException("Logical log[" + logFileName + "] not found");
        }
        boolean deleted = FileUtils.deleteFile(file);
        if (!deleted) {
            this.log.warning("Unable to delete clean logical log[" + logFileName + "]");
        }
    }

    private void releaseCurrentLogFile() throws IOException {
        if (this.writeBuffer != null) {
            this.writeBuffer.force();
            this.writeBuffer = null;
        }
        this.fileChannel.close();
        this.fileChannel = null;
    }

    public synchronized void close() throws IOException {
        if (this.fileChannel == null || !this.fileChannel.isOpen()) {
            this.log.fine("Logical log: " + this.fileName + " already closed");
            return;
        }
        long endPosition = this.writeBuffer.getFileChannelPosition();
        if (this.xidIdentMap.size() > 0) {
            this.log.info("Close invoked with " + this.xidIdentMap.size() + " running transaction(s). ");
            this.writeBuffer.force();
            this.writeBuffer = null;
            this.fileChannel.close();
            this.log.info("Dirty log: " + this.fileName + "." + this.currentLog + " now closed. Recovery will be started automatically next " + "time it is opened.");
            return;
        }
        if (!this.keepLogs || this.backupSlave) {
            if (this.currentLog == 'C') {
                this.deleteCurrentLogFile(this.fileName);
            } else {
                this.deleteCurrentLogFile(this.fileName + "." + this.currentLog);
            }
        } else {
            this.renameCurrentLogFileAndIncrementVersion(this.fileName + "." + this.currentLog, endPosition);
        }
        if (this.currentLog != 'C') {
            this.setActiveLog('C');
        }
    }

    private void doInternalRecovery(String logFileName) throws IOException {
        this.log.info("Non clean shutdown detected on log [" + logFileName + "]. Recovery started ...");
        this.buffer.clear();
        this.buffer.limit(8);
        if (this.fileChannel.read(this.buffer) != 8) {
            this.log.info("Unable to read timestamp information, no records in logical log.");
            this.fileChannel.close();
            boolean success = FileUtils.renameFile(new File(logFileName), new File(logFileName + "_unknown_timestamp_" + System.currentTimeMillis() + ".log"));
            assert (success);
            this.fileChannel = new RandomAccessFile(logFileName, "rw").getChannel();
            return;
        }
        this.buffer.flip();
        this.logVersion = this.buffer.getLong();
        this.log.fine("Logical log version: " + this.logVersion);
        long logEntriesFound = 0L;
        while (this.readEntry()) {
            ++logEntriesFound;
        }
        this.scanIsComplete = true;
        this.log.fine("Internal recovery completed, scanned " + logEntriesFound + " log entries.");
        this.xaRm.checkXids();
        if (this.xidIdentMap.size() == 0) {
            this.log.fine("Recovery completed.");
        } else {
            this.log.fine("[" + logFileName + "] Found " + this.xidIdentMap.size() + " prepared 2PC transactions.");
            for (StartEntry entry : this.xidIdentMap.values()) {
                this.log.fine("[" + logFileName + "] 2PC xid[" + entry.getXid() + "]");
            }
        }
        this.recoveredTxMap.clear();
    }

    void reset() {
        this.xidIdentMap.clear();
        this.recoveredTxMap.clear();
    }

    private boolean readEntry() throws IOException {
        this.buffer.clear();
        this.buffer.limit(1);
        if (this.fileChannel.read(this.buffer) != this.buffer.limit()) {
            return false;
        }
        this.buffer.flip();
        byte entry = this.buffer.get();
        switch (entry) {
            case 1: {
                return this.readTxStartEntry();
            }
            case 2: {
                return this.readTxPrepareEntry();
            }
            case 5: {
                return this.readTxOnePhaseCommit();
            }
            case 6: {
                return this.readTxTwoPhaseCommit();
            }
            case 3: {
                return this.readCommandEntry();
            }
            case 4: {
                return this.readDoneEntry();
            }
            case 0: {
                this.fileChannel.position(this.fileChannel.position() - 1L);
                return false;
            }
        }
        throw new IOException("Internal recovery failed, unknown log entry[" + entry + "]");
    }

    void registerTxIdentifier(int identifier) {
        this.txIdentMap.put(Thread.currentThread(), identifier);
    }

    void unregisterTxIdentifier() {
        this.txIdentMap.remove(Thread.currentThread());
    }

    public int getCurrentTxIdentifier() {
        Integer intValue = this.txIdentMap.get(Thread.currentThread());
        if (intValue != null) {
            return intValue;
        }
        return -1;
    }

    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        String name = this.fileName + ".v" + version;
        if (!new File(name).exists()) {
            throw new IOException("No such log version:" + version);
        }
        return new RandomAccessFile(name, "r").getChannel();
    }

    public long getLogicalLogLength(long version) {
        String name = this.fileName + ".v" + version;
        File file = new File(name);
        if (!file.exists()) {
            return -1L;
        }
        return file.length();
    }

    public boolean hasLogicalLog(long version) {
        String name = this.fileName + ".v" + version;
        return new File(name).exists();
    }

    public boolean deleteLogicalLog(long version) {
        String name = this.fileName + ".v" + version;
        File file = new File(name);
        if (file.exists()) {
            return FileUtils.deleteFile(file);
        }
        return false;
    }

    public void makeBackupSlave() {
        if (this.xidIdentMap.size() > 0) {
            throw new IllegalStateException("There are active transactions");
        }
        this.backupSlave = true;
    }

    public synchronized void applyLog(ReadableByteChannel byteChannel) throws IOException {
        if (!this.backupSlave) {
            throw new IllegalStateException("This is not a backup slave");
        }
        if (this.xidIdentMap.size() > 0) {
            throw new IllegalStateException("There are active transactions");
        }
        this.buffer.clear();
        this.buffer.limit(8);
        if (byteChannel.read(this.buffer) != 8) {
            throw new IOException("Unable to read log version");
        }
        this.buffer.flip();
        this.logVersion = this.buffer.getLong();
        if (this.logVersion != this.xaTf.getCurrentVersion()) {
            throw new IllegalStateException("Tried to apply version " + this.logVersion + " but expected version " + this.xaTf.getCurrentVersion());
        }
        this.log.fine("Logical log version: " + this.logVersion);
        long logEntriesFound = 0L;
        LogApplier logApplier = new LogApplier(byteChannel, this.buffer, this.xaTf, this.xaRm, this.cf, this.xidIdentMap, this.recoveredTxMap);
        while (logApplier.readAndApplyEntry()) {
            ++logEntriesFound;
        }
        byteChannel.close();
        this.xaTf.getAndSetNewVersion();
        this.xaRm.reset();
        this.log.info("Log version " + this.logVersion + " applied successfully.");
    }

    public synchronized void rotate() throws IOException {
        this.xaTf.flushAll();
        String newLogFile = this.fileName + ".2";
        String currentLogFile = this.fileName + ".1";
        char newActiveLog = '2';
        long currentVersion = this.xaTf.getCurrentVersion();
        String oldCopy = this.fileName + ".v" + currentVersion;
        if (this.currentLog == 'C' || this.currentLog == '2') {
            newActiveLog = '1';
            newLogFile = this.fileName + ".1";
            currentLogFile = this.fileName + ".2";
        } else assert (this.currentLog == '1');
        if (new File(newLogFile).exists()) {
            throw new IOException("New log file: " + newLogFile + " already exist");
        }
        if (new File(oldCopy).exists()) {
            throw new IOException("Copy log file: " + oldCopy + " already exist");
        }
        long endPosition = this.writeBuffer.getFileChannelPosition();
        this.writeBuffer.force();
        FileChannel newLog = new RandomAccessFile(newLogFile, "rw").getChannel();
        this.buffer.clear();
        this.buffer.putLong(currentVersion + 1L).flip();
        if (newLog.write(this.buffer) != 8) {
            throw new IOException("Unable to write log version to new");
        }
        this.fileChannel.position(0L);
        this.buffer.clear();
        this.buffer.limit(8);
        if (this.fileChannel.read(this.buffer) != 8) {
            throw new IOException("Verification of log version failed");
        }
        this.buffer.flip();
        long verification = this.buffer.getLong();
        if (verification != currentVersion) {
            throw new IOException("Verification of log version failed,  expected " + currentVersion + " got " + verification);
        }
        if (this.xidIdentMap.size() > 0) {
            this.fileChannel.position(this.getFirstStartEntry(endPosition));
        }
        this.buffer.clear();
        this.buffer.limit(1);
        boolean emptyHit = false;
        while (this.fileChannel.read(this.buffer) == 1 && !emptyHit) {
            this.buffer.flip();
            byte entry = this.buffer.get();
            switch (entry) {
                case 1: {
                    this.readAndWriteTxStartEntry(newLog);
                    break;
                }
                case 2: {
                    this.readAndWriteTxPrepareEntry(newLog);
                    break;
                }
                case 5: {
                    this.readAndWriteTxOnePhaseCommit(newLog);
                    break;
                }
                case 6: {
                    this.readAndWriteTxTwoPhaseCommit(newLog);
                    break;
                }
                case 3: {
                    this.readAndWriteCommandEntry(newLog);
                    break;
                }
                case 4: {
                    this.readAndVerifyDoneEntry();
                    break;
                }
                case 0: {
                    emptyHit = true;
                    break;
                }
                default: {
                    throw new IOException("Log rotation failed, unknown log entry[" + entry + "]");
                }
            }
            this.buffer.clear();
            this.buffer.limit(1);
        }
        newLog.force(false);
        this.setActiveLog(newActiveLog);
        if (this.keepLogs) {
            this.renameCurrentLogFileAndIncrementVersion(currentLogFile, endPosition);
        } else {
            this.deleteCurrentLogFile(currentLogFile);
            this.xaTf.getAndSetNewVersion();
        }
        if (this.xaTf.getCurrentVersion() != currentVersion + 1L) {
            throw new IOException("version change failed");
        }
        this.fileChannel = newLog;
        this.writeBuffer = !this.useMemoryMapped ? new DirectMappedLogBuffer(this.fileChannel) : new MemoryMappedLogBuffer(this.fileChannel);
    }

    private long getFirstStartEntry(long endPosition) {
        long firstEntryPosition = endPosition;
        for (StartEntry entry : this.xidIdentMap.values()) {
            if (entry.getStartPosition() >= firstEntryPosition) continue;
            assert (entry.getStartPosition() > 0L);
            firstEntryPosition = entry.getStartPosition();
        }
        return firstEntryPosition;
    }

    private void setActiveLog(char c) throws IOException {
        if (c != 'C' && c != '1' && c != '2') {
            throw new IllegalArgumentException("Log must be either clean, 1 or 2");
        }
        if (c == this.currentLog) {
            throw new IllegalStateException("Log should not be equal to current " + this.currentLog);
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[4]);
        bb.asCharBuffer().put(c).flip();
        FileChannel fc = new RandomAccessFile(this.fileName + ".active", "rw").getChannel();
        int wrote = fc.write(bb);
        if (wrote != 4) {
            throw new IllegalStateException("Expected to write 4 -> " + wrote);
        }
        fc.force(false);
        fc.close();
        this.currentLog = c;
    }

    private void readAndWriteCommandEntry(FileChannel newLog) throws IOException {
        this.buffer.clear();
        this.buffer.put((byte)3);
        this.buffer.limit(5);
        if (this.fileChannel.read(this.buffer) != 4) {
            throw new IllegalStateException("Unable to read command header");
        }
        this.buffer.flip();
        this.buffer.position(1);
        int identifier = this.buffer.getInt();
        FileChannel writeToLog = null;
        if (this.xidIdentMap.get(identifier) != null) {
            writeToLog = newLog;
        }
        if (writeToLog != null) {
            this.buffer.position(0);
            if (writeToLog.write(this.buffer) != 5) {
                throw new TransactionFailureException("Unable to write command header");
            }
        }
        XaCommand command = this.cf.readCommand(this.fileChannel, this.buffer);
        if (writeToLog != null) {
            command.writeToFile(new DirectLogBuffer(writeToLog, this.buffer));
        }
    }

    private void readAndVerifyDoneEntry() throws IOException {
        this.buffer.clear();
        this.buffer.limit(4);
        if (this.fileChannel.read(this.buffer) != 4) {
            throw new IllegalStateException("Unable to read done entry");
        }
        this.buffer.flip();
        int identifier = this.buffer.getInt();
        if (this.xidIdentMap.get(identifier) != null) {
            throw new IllegalStateException(identifier + " done entry found but still active");
        }
    }

    private void readAndWriteTxOnePhaseCommit(FileChannel newLog) throws IOException {
        this.buffer.clear();
        this.buffer.limit(5);
        this.buffer.put((byte)5);
        if (this.fileChannel.read(this.buffer) != 4) {
            throw new IllegalStateException("Unable to read 1P commit entry");
        }
        this.buffer.flip();
        this.buffer.position(1);
        int identifier = this.buffer.getInt();
        FileChannel writeToLog = null;
        if (this.xidIdentMap.get(identifier) != null) {
            writeToLog = newLog;
        }
        this.buffer.position(0);
        if (writeToLog != null && writeToLog.write(this.buffer) != 5) {
            throw new TransactionFailureException("Unable to write 1P commit entry");
        }
    }

    private void readAndWriteTxTwoPhaseCommit(FileChannel newLog) throws IOException {
        this.buffer.clear();
        this.buffer.limit(5);
        this.buffer.put((byte)6);
        if (this.fileChannel.read(this.buffer) != 4) {
            throw new IllegalStateException("Unable to read 2P commit entry");
        }
        this.buffer.flip();
        this.buffer.position(1);
        int identifier = this.buffer.getInt();
        FileChannel writeToLog = null;
        if (this.xidIdentMap.get(identifier) != null) {
            writeToLog = newLog;
        }
        this.buffer.position(0);
        if (writeToLog != null && writeToLog.write(this.buffer) != 5) {
            throw new TransactionFailureException("Unable to write 2P commit entry");
        }
    }

    private void readAndWriteTxPrepareEntry(FileChannel newLog) throws IOException {
        this.buffer.clear();
        this.buffer.limit(5);
        this.buffer.put((byte)2);
        if (this.fileChannel.read(this.buffer) != 4) {
            throw new IllegalStateException("Unable to read prepare entry");
        }
        this.buffer.flip();
        this.buffer.position(1);
        int identifier = this.buffer.getInt();
        FileChannel writeToLog = null;
        if (this.xidIdentMap.get(identifier) != null) {
            writeToLog = newLog;
        }
        this.buffer.position(0);
        if (writeToLog != null && writeToLog.write(this.buffer) != 5) {
            throw new TransactionFailureException("Unable to write prepare entry");
        }
    }

    private void readAndWriteTxStartEntry(FileChannel newLog) throws IOException {
        this.buffer.clear();
        this.buffer.put((byte)1);
        this.buffer.limit(3);
        if (this.fileChannel.read(this.buffer) != 2) {
            throw new IllegalStateException("Unable to read tx start entry xid id lengths");
        }
        this.buffer.flip();
        this.buffer.position(1);
        byte globalIdLength = this.buffer.get();
        byte branchIdLength = this.buffer.get();
        int xidLength = globalIdLength + branchIdLength;
        this.buffer.limit(3 + xidLength + 8);
        this.buffer.position(3);
        if (this.fileChannel.read(this.buffer) != 8 + xidLength) {
            throw new IllegalStateException("Unable to read xid");
        }
        this.buffer.flip();
        this.buffer.position(3 + xidLength);
        int identifier = this.buffer.getInt();
        FileChannel writeToLog = null;
        StartEntry entry = this.xidIdentMap.get(identifier);
        if (entry != null) {
            writeToLog = newLog;
            entry.setStartPosition(newLog.position());
        }
        this.buffer.position(0);
        if (writeToLog != null && writeToLog.write(this.buffer) != 11 + xidLength) {
            throw new TransactionFailureException("Unable to write tx start xid");
        }
    }

    public void setKeepLogs(boolean keep) {
        this.keepLogs = keep;
    }

    public boolean isLogsKept() {
        return this.keepLogs;
    }

    public void setAutoRotateLogs(boolean autoRotate) {
        this.autoRotate = autoRotate;
    }

    public boolean isLogsAutoRotated() {
        return this.autoRotate;
    }

    public void setLogicalLogTargetSize(long size) {
        this.rotateAtSize = size;
    }

    public long getLogicalLogTargetSize() {
        return this.rotateAtSize;
    }

    public String getFileName(long version) {
        return this.fileName + ".v" + version;
    }

    private static class StartEntry {
        private final Xid xid;
        private long startEntryPosition;

        StartEntry(Xid xid, long startPosition) {
            this.xid = xid;
            this.startEntryPosition = startPosition;
        }

        Xid getXid() {
            return this.xid;
        }

        long getStartPosition() {
            return this.startEntryPosition;
        }

        void setStartPosition(long newPosition) {
            this.startEntryPosition = newPosition;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LogApplier {
        private final ReadableByteChannel byteChannel;
        private final ByteBuffer buffer;
        private final XaTransactionFactory xaTf;
        private final XaResourceManager xaRm;
        private final XaCommandFactory xaCf;
        private final ArrayMap<Integer, StartEntry> xidIdentMap;
        private final Map<Integer, XaTransaction> recoveredTxMap;

        LogApplier(ReadableByteChannel byteChannel, ByteBuffer buffer, XaTransactionFactory xaTf, XaResourceManager xaRm, XaCommandFactory xaCf, ArrayMap<Integer, StartEntry> xidIdentMap, Map<Integer, XaTransaction> recoveredTxMap) {
            this.byteChannel = byteChannel;
            this.buffer = buffer;
            this.xaTf = xaTf;
            this.xaRm = xaRm;
            this.xaCf = xaCf;
            this.xidIdentMap = xidIdentMap;
            this.recoveredTxMap = recoveredTxMap;
        }

        boolean readAndApplyEntry() throws IOException {
            this.buffer.clear();
            this.buffer.limit(1);
            if (this.byteChannel.read(this.buffer) != this.buffer.limit()) {
                return false;
            }
            this.buffer.flip();
            byte entry = this.buffer.get();
            switch (entry) {
                case 1: {
                    this.readTxStartEntry();
                    return true;
                }
                case 2: {
                    this.readTxPrepareEntry();
                    return true;
                }
                case 5: {
                    this.readAndApplyTxOnePhaseCommit();
                    return true;
                }
                case 6: {
                    this.readAndApplyTxTwoPhaseCommit();
                    return true;
                }
                case 3: {
                    this.readCommandEntry();
                    return true;
                }
                case 4: {
                    this.readDoneEntry();
                    return true;
                }
                case 0: {
                    return false;
                }
            }
            throw new IOException("Internal recovery failed, unknown log entry[" + entry + "]");
        }

        private void readTxStartEntry() throws IOException {
            this.buffer.clear();
            this.buffer.limit(1);
            if (this.byteChannel.read(this.buffer) != this.buffer.limit()) {
                throw new IOException("Unable to read tx start entry");
            }
            this.buffer.flip();
            byte globalIdLength = this.buffer.get();
            this.buffer.clear();
            this.buffer.limit(1);
            if (this.byteChannel.read(this.buffer) != this.buffer.limit()) {
                throw new IOException("Unable to read tx start entry");
            }
            this.buffer.flip();
            byte branchIdLength = this.buffer.get();
            byte[] globalId = new byte[globalIdLength];
            ByteBuffer tmpBuffer = ByteBuffer.wrap(globalId);
            if (this.byteChannel.read(tmpBuffer) != globalId.length) {
                throw new IOException("Unable to read tx start entry");
            }
            byte[] branchId = new byte[branchIdLength];
            tmpBuffer = ByteBuffer.wrap(branchId);
            if (this.byteChannel.read(tmpBuffer) != branchId.length) {
                throw new IOException("Unable to read tx start entry");
            }
            this.buffer.clear();
            this.buffer.limit(4);
            if (this.byteChannel.read(this.buffer) != this.buffer.limit()) {
                throw new IOException("Unable to read tx start entry");
            }
            this.buffer.flip();
            int identifier = this.buffer.getInt();
            this.buffer.clear();
            this.buffer.limit(4);
            if (this.byteChannel.read(this.buffer) != this.buffer.limit()) {
                throw new IOException("Unable to read tx start entry");
            }
            this.buffer.flip();
            int formatId = this.buffer.getInt();
            XidImpl xid = new XidImpl(globalId, branchId, formatId);
            this.xidIdentMap.put(identifier, new StartEntry(xid, -1L));
            XaTransaction xaTx = this.xaTf.create(identifier);
            xaTx.setRecovered();
            this.recoveredTxMap.put(identifier, xaTx);
            this.xaRm.injectStart(xid, xaTx);
        }

        private void readTxPrepareEntry() throws IOException {
            this.buffer.clear();
            this.buffer.limit(4);
            if (this.byteChannel.read(this.buffer) != this.buffer.limit()) {
                throw new IOException("Unable to read tx prepare entry");
            }
            this.buffer.flip();
            int identifier = this.buffer.getInt();
            StartEntry entry = this.xidIdentMap.get(identifier);
            if (entry == null) {
                throw new IOException("Unable to read tx prepeare entry");
            }
            Xid xid = entry.getXid();
            if (this.xaRm.injectPrepare(xid)) {
                this.xidIdentMap.remove(identifier);
                this.recoveredTxMap.remove(identifier);
            }
        }

        private void readAndApplyTxOnePhaseCommit() throws IOException {
            this.buffer.clear();
            this.buffer.limit(4);
            if (this.byteChannel.read(this.buffer) != this.buffer.limit()) {
                throw new IOException("Unable to read tx 1PC entry");
            }
            this.buffer.flip();
            int identifier = this.buffer.getInt();
            StartEntry entry = this.xidIdentMap.get(identifier);
            if (entry == null) {
                throw new IOException("Unable to read tx prepeare entry");
            }
            Xid xid = entry.getXid();
            try {
                this.xaRm.commit(xid, true);
            }
            catch (XAException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }

        private void readAndApplyTxTwoPhaseCommit() throws IOException {
            this.buffer.clear();
            this.buffer.limit(4);
            if (this.byteChannel.read(this.buffer) != this.buffer.limit()) {
                throw new IOException("Unable to read tx 2PC entry");
            }
            this.buffer.flip();
            int identifier = this.buffer.getInt();
            StartEntry entry = this.xidIdentMap.get(identifier);
            if (entry == null) {
                throw new IOException("Unable to read tx prepeare entry");
            }
            Xid xid = entry.getXid();
            try {
                this.xaRm.commit(xid, true);
            }
            catch (XAException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }

        private void readCommandEntry() throws IOException {
            this.buffer.clear();
            this.buffer.limit(4);
            if (this.byteChannel.read(this.buffer) != this.buffer.limit()) {
                throw new IOException("Unable to read tx command entry");
            }
            this.buffer.flip();
            int identifier = this.buffer.getInt();
            XaCommand command = this.xaCf.readCommand(this.byteChannel, this.buffer);
            if (command == null) {
                throw new IOException("Unable to read command entry");
            }
            command.setRecovered();
            XaTransaction xaTx = this.recoveredTxMap.get(identifier);
            xaTx.injectCommand(command);
        }

        private boolean readDoneEntry() throws IOException {
            this.buffer.clear();
            this.buffer.limit(4);
            if (this.byteChannel.read(this.buffer) != this.buffer.limit()) {
                return false;
            }
            this.buffer.flip();
            int identifier = this.buffer.getInt();
            StartEntry entry = this.xidIdentMap.get(identifier);
            if (entry == null) {
                throw new IOException("Unable to read tx done entry");
            }
            Xid xid = entry.getXid();
            this.xaRm.pruneXidIfExist(xid);
            this.xidIdentMap.remove(identifier);
            this.recoveredTxMap.remove(identifier);
            return true;
        }
    }
}

