/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.traversal;

import java.util.LinkedList;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.ReturnableEvaluator;
import org.neo4j.api.core.StopEvaluator;
import org.neo4j.impl.traversal.AbstractTraverser;
import org.neo4j.impl.traversal.RandomEvaluator;
import org.neo4j.impl.traversal.TraversalPositionImpl;

class BreadthFirstTraverser
extends AbstractTraverser {
    private LinkedList<TraversalPositionImpl> nodeQueue;

    BreadthFirstTraverser(Node startNode, RelationshipType[] traversableRels, Direction[] traversableDirections, RelationshipType[] preservingRels, Direction[] preservingDirections, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RandomEvaluator randomEvaluator) {
        super(startNode, traversableRels, traversableDirections, preservingRels, preservingDirections, stopEvaluator, returnableEvaluator, randomEvaluator);
    }

    void addPositionToList(TraversalPositionImpl position) {
        this.nodeQueue.addLast(position);
    }

    TraversalPositionImpl getNextPositionFromList() {
        return this.nodeQueue.removeFirst();
    }

    boolean listIsEmpty() {
        return this.nodeQueue.isEmpty();
    }

    final boolean traverseChildrenInNaturalOrder() {
        return true;
    }

    void initializeList() {
        this.nodeQueue = new LinkedList();
    }
}

