/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.traversal;

import java.util.Arrays;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.ReturnableEvaluator;
import org.neo4j.api.core.StopEvaluator;
import org.neo4j.api.core.Traverser;
import org.neo4j.impl.traversal.BreadthFirstTraverser;
import org.neo4j.impl.traversal.DepthFirstTraverser;
import org.neo4j.impl.traversal.RandomEvaluator;

public final class InternalTraverserFactory {
    public Traverser createTraverser(Traverser.Order traversalOrder, Node startNode, RelationshipType[] traversableRels, Direction[] traversableDirs, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator) {
        if (traversableRels == null || traversableDirs == null) {
            throw new IllegalArgumentException("Using this constructor requires that traversable relationships array and traversable directions array isn't null: travRels[" + Arrays.toString(traversableRels) + "] " + "travDirs[" + Arrays.toString((Object[])traversableDirs) + "]");
        }
        if (traversableRels.length != traversableDirs.length) {
            throw new IllegalArgumentException("Length of traversable relationships array isn't equal to length of traversable directions array: travRels.length[" + traversableRels.length + "] != " + "travDirs.length[" + traversableDirs.length + "]");
        }
        if (traversalOrder == Traverser.Order.BREADTH_FIRST) {
            return new BreadthFirstTraverser(startNode, traversableRels, traversableDirs, null, null, stopEvaluator, returnableEvaluator, null);
        }
        if (traversalOrder == Traverser.Order.DEPTH_FIRST) {
            return new DepthFirstTraverser(startNode, traversableRels, traversableDirs, null, null, stopEvaluator, returnableEvaluator, null);
        }
        throw new IllegalArgumentException("Unknown traverser type: " + (Object)((Object)traversalOrder));
    }

    public Traverser createTraverser(Traverser.Order traversalOrder, Node startNode, RelationshipType[] traversableRels, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator) {
        if (traversalOrder == Traverser.Order.BREADTH_FIRST) {
            return new BreadthFirstTraverser(startNode, traversableRels, null, null, null, stopEvaluator, returnableEvaluator, null);
        }
        if (traversalOrder == Traverser.Order.DEPTH_FIRST) {
            return new DepthFirstTraverser(startNode, traversableRels, null, null, null, stopEvaluator, returnableEvaluator, null);
        }
        throw new IllegalArgumentException("Unknown traverser type: " + (Object)((Object)traversalOrder));
    }

    public Traverser createTraverser(Traverser.Order traversalOrder, Node startNode, RelationshipType traversableRel, Direction direction, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator) {
        RelationshipType[] traversableRels = new RelationshipType[]{traversableRel};
        Direction[] traversableDirs = new Direction[]{direction};
        if (traversalOrder == Traverser.Order.BREADTH_FIRST) {
            return new BreadthFirstTraverser(startNode, traversableRels, traversableDirs, null, null, stopEvaluator, returnableEvaluator, null);
        }
        if (traversalOrder == Traverser.Order.DEPTH_FIRST) {
            return new DepthFirstTraverser(startNode, traversableRels, traversableDirs, null, null, stopEvaluator, returnableEvaluator, null);
        }
        throw new IllegalArgumentException("Unknown traverser type: " + (Object)((Object)traversalOrder));
    }

    public Traverser createTraverser(Traverser.Order traversalOrder, Node startNode, RelationshipType[] traversableRels, Direction[] traversableDirs, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RandomEvaluator randomEvaluator) {
        if (traversableRels == null || traversableDirs == null) {
            throw new IllegalArgumentException("Using this constructor requires that traversable relationships array and traversable directions array isn't null: travRels[" + Arrays.toString(traversableRels) + "] " + "travDirs[" + Arrays.toString((Object[])traversableDirs) + "]");
        }
        if (traversableRels.length != traversableDirs.length) {
            throw new IllegalArgumentException("Length of traversable relationships array isn't equal to length of traversable directions array: travRels.length[" + traversableRels.length + "] != " + "travDirs.length[" + traversableDirs.length + "]");
        }
        if (traversalOrder == Traverser.Order.BREADTH_FIRST) {
            return new BreadthFirstTraverser(startNode, traversableRels, traversableDirs, null, null, stopEvaluator, returnableEvaluator, randomEvaluator);
        }
        if (traversalOrder == Traverser.Order.DEPTH_FIRST) {
            return new DepthFirstTraverser(startNode, traversableRels, traversableDirs, null, null, stopEvaluator, returnableEvaluator, randomEvaluator);
        }
        throw new IllegalArgumentException("Unknown traverser type: " + (Object)((Object)traversalOrder));
    }
}

