/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.traversal;

import java.io.Serializable;
import java.util.Comparator;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeSortInfo<T extends Node>
implements Comparator<T>,
Serializable {
    @Override
    public abstract int compare(Node var1, Node var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertySortInfo<T extends Node>
    extends NodeSortInfo<T> {
        private String key = null;
        private int direction = 1;

        public PropertySortInfo(String key) {
            this.key = key;
        }

        public PropertySortInfo(String key, boolean descending) {
            this.key = key;
            if (descending) {
                this.direction = -1;
            }
        }

        @Override
        public int compare(Node node1, Node node2) {
            Object property1 = null;
            Object property2 = null;
            try {
                property1 = node1.getProperty(this.key);
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            try {
                property2 = node2.getProperty(this.key);
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            if (property1 == null) {
                return (property2 == null ? 0 : -1) * this.direction;
            }
            if (property2 == null) {
                return 1 * this.direction;
            }
            if (property1 instanceof Integer) {
                if (property2 instanceof Integer) {
                    return ((Integer)property1).compareTo((Integer)property2) * this.direction;
                }
                if (property2 instanceof String) {
                    String stringValue = property1.toString();
                    return stringValue.compareTo((String)property2) * this.direction;
                }
                return 1 * this.direction;
            }
            if (property1 instanceof String) {
                if (property2 instanceof String) {
                    return ((String)property1).compareTo((String)property2) * this.direction;
                }
                if (property2 instanceof Integer) {
                    return ((String)property1).compareTo(property2.toString()) * this.direction;
                }
                return 1 * this.direction;
            }
            if (property2 instanceof Integer || property2 instanceof String) {
                return -1 * this.direction;
            }
            return 0;
        }
    }
}

