/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.api.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.transaction.TransactionManager;
import org.neo4j.api.core.NeoJvmInstance;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.impl.core.NodeManager;
import org.neo4j.impl.shell.NeoShellServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddedNeo
implements NeoService {
    public static final int DEFAULT_SHELL_PORT = 1337;
    public static final String DEFAULT_SHELL_NAME = "shell";
    private static Logger log = Logger.getLogger(EmbeddedNeo.class.getName());
    private NeoShellServer shellServer;
    private Transaction placeboTransaction = null;
    private final NeoJvmInstance neoJvmInstance;
    private final NodeManager nodeManager;
    private final String storeDir;

    public EmbeddedNeo(String storeDir) {
        this.storeDir = storeDir;
        this.shellServer = null;
        this.neoJvmInstance = new NeoJvmInstance(storeDir, true);
        this.neoJvmInstance.start();
        this.nodeManager = this.neoJvmInstance.getConfig().getNeoModule().getNodeManager();
    }

    public EmbeddedNeo(String storeDir, Map<String, String> params) {
        this.storeDir = storeDir;
        this.shellServer = null;
        this.neoJvmInstance = new NeoJvmInstance(storeDir, true);
        this.neoJvmInstance.start(params);
        this.nodeManager = this.neoJvmInstance.getConfig().getNeoModule().getNodeManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadConfigurations(String file) {
        Properties props = new Properties();
        try {
            FileInputStream stream = new FileInputStream(new File(file));
            try {
                props.load(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load properties file[" + file + "]", e);
        }
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        HashMap<String, String> stringProps = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : entries) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            stringProps.put(key, value);
        }
        return stringProps;
    }

    private NeoShellServer getShellServer() {
        return this.shellServer;
    }

    @Override
    public Node createNode() {
        return this.nodeManager.createNode();
    }

    @Override
    public Node getNodeById(long id) {
        return this.nodeManager.getNodeById((int)id);
    }

    @Override
    public Relationship getRelationshipById(long id) {
        return this.nodeManager.getRelationshipById((int)id);
    }

    @Override
    public Node getReferenceNode() {
        return this.nodeManager.getReferenceNode();
    }

    @Override
    public void shutdown() {
        if (this.getShellServer() != null) {
            try {
                this.getShellServer().shutdown();
            }
            catch (Throwable t) {
                log.warning("Error shutting down shell server: " + t);
            }
        }
        this.neoJvmInstance.shutdown();
    }

    @Override
    public boolean enableRemoteShell() {
        return this.enableRemoteShell(null);
    }

    @Override
    public boolean enableRemoteShell(Map<String, Serializable> initialProperties) {
        Map<String, Serializable> properties = initialProperties;
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        try {
            if (this.shellDependencyAvailable()) {
                this.shellServer = new NeoShellServer(this);
                Serializable port = properties.get("port");
                Serializable name = properties.get("name");
                this.shellServer.makeRemotelyAvailable(port != null ? (Integer)port : 1337, name != null ? (String)((Object)name) : DEFAULT_SHELL_NAME);
                return true;
            }
            log.info("Shell library not available. Neo shell not started. Please add the Neo4j shell jar to the classpath.");
            return false;
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Can't start remote neo shell: " + e);
        }
    }

    private boolean shellDependencyAvailable() {
        try {
            Class.forName("org.neo4j.util.shell.ShellServer");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.neoJvmInstance.getRelationshipTypes();
    }

    @Override
    public Transaction beginTx() {
        if (this.neoJvmInstance.transactionRunning()) {
            if (this.placeboTransaction == null) {
                this.placeboTransaction = new PlaceboTransaction(this.neoJvmInstance.getTransactionManager());
            }
            return this.placeboTransaction;
        }
        TransactionManager txManager = this.neoJvmInstance.getTransactionManager();
        try {
            txManager.begin();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new TransactionImpl(txManager);
    }

    public NeoJvmInstance.Config getConfig() {
        return this.neoJvmInstance.getConfig();
    }

    public String toString() {
        return super.toString() + " [" + this.storeDir + "]";
    }

    public String getStoreDir() {
        return this.storeDir;
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                long highId = EmbeddedNeo.this.nodeManager.getHighestPossibleIdInUse(Node.class) & 0xFFFFFFFFL;
                return new AllNodesIterator(highId);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllNodesIterator
    implements Iterator<Node> {
        private final long highId;
        private long currentNodeId = 0L;
        private Node currentNode = null;

        AllNodesIterator(long highId) {
            this.highId = highId;
        }

        @Override
        public synchronized boolean hasNext() {
            while (this.currentNode == null && this.currentNodeId <= this.highId) {
                try {
                    this.currentNode = EmbeddedNeo.this.getNodeById(this.currentNodeId++);
                }
                catch (NotFoundException notFoundException) {}
            }
            return this.currentNode != null;
        }

        @Override
        public synchronized Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Node nextNode = this.currentNode;
            this.currentNode = null;
            return nextNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class TransactionImpl
    implements Transaction {
        private boolean success = false;
        private final TransactionManager transactionManager;

        TransactionImpl(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
        }

        public void failure() {
            this.success = false;
            try {
                this.transactionManager.getTransaction().setRollbackOnly();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void success() {
            this.success = true;
        }

        public void finish() {
            try {
                if (this.success) {
                    if (this.transactionManager.getTransaction() != null) {
                        this.transactionManager.getTransaction().commit();
                    }
                } else if (this.transactionManager.getTransaction() != null) {
                    this.transactionManager.getTransaction().rollback();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PlaceboTransaction
    implements Transaction {
        private final TransactionManager transactionManager;

        PlaceboTransaction(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
        }

        public void failure() {
            try {
                this.transactionManager.getTransaction().setRollbackOnly();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void success() {
        }

        public void finish() {
        }
    }
}

