/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.api.core;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.impl.cache.AdaptiveCacheManager;
import org.neo4j.impl.core.LockReleaser;
import org.neo4j.impl.core.NeoModule;
import org.neo4j.impl.event.EventModule;
import org.neo4j.impl.nioneo.xa.NioNeoDbPersistenceSource;
import org.neo4j.impl.persistence.IdGeneratorModule;
import org.neo4j.impl.persistence.PersistenceModule;
import org.neo4j.impl.transaction.LockManager;
import org.neo4j.impl.transaction.TxModule;
import org.neo4j.impl.transaction.xaframework.XaDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NeoJvmInstance {
    private static final String NIO_NEO_DB_CLASS = "org.neo4j.impl.nioneo.xa.NeoStoreXaDataSource";
    private static final String DEFAULT_DATA_SOURCE_NAME = "nioneodb";
    private static final String LUCENE_DS_CLASS = "org.neo4j.util.index.LuceneDataSource";
    private boolean started = false;
    private boolean create;
    private String storeDir;
    private Config config = null;
    private NioNeoDbPersistenceSource persistenceSource = null;

    NeoJvmInstance(String storeDir, boolean create) {
        this.storeDir = storeDir;
        this.create = create;
    }

    public Config getConfig() {
        return this.config;
    }

    public void start() {
        this.start(new HashMap<String, String>());
    }

    private Map<Object, Object> getDefaultParams() {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("neostore.nodestore.db.mapped_memory", "20M");
        params.put("neostore.propertystore.db.mapped_memory", "90M");
        params.put("neostore.propertystore.db.index.mapped_memory", "1M");
        params.put("neostore.propertystore.db.index.keys.mapped_memory", "1M");
        params.put("neostore.propertystore.db.strings.mapped_memory", "130M");
        params.put("neostore.propertystore.db.arrays.mapped_memory", "130M");
        params.put("neostore.relationshipstore.db.mapped_memory", "100M");
        String nameOs = System.getProperty("os.name");
        if (nameOs.startsWith("Windows")) {
            params.put("use_memory_mapped_buffers", "false");
        }
        return params;
    }

    public synchronized void start(Map<String, String> stringParams) {
        if (this.started) {
            throw new IllegalStateException("A Neo instance already started");
        }
        Map<Object, Object> params = this.getDefaultParams();
        for (Map.Entry<String, String> entry : stringParams.entrySet()) {
            params.put(entry.getKey(), entry.getValue());
        }
        this.config = new Config(this.storeDir, params);
        this.storeDir = this.convertFileSeparators(this.storeDir);
        String separator = System.getProperty("file.separator");
        String store = this.storeDir + separator + "neostore";
        params.put("store_dir", this.storeDir);
        params.put("neo_store", store);
        params.put("create", String.valueOf(this.create));
        String logicalLog = this.storeDir + separator + "nioneo_logical.log";
        params.put("logical_log", logicalLog);
        byte[] resourceId = "414141".getBytes();
        params.put(LockManager.class, this.config.getLockManager());
        params.put(LockReleaser.class, this.config.getLockReleaser());
        this.config.getTxModule().registerDataSource(DEFAULT_DATA_SOURCE_NAME, NIO_NEO_DB_CLASS, resourceId, params);
        XaDataSource lucene = null;
        try {
            Class<?> clazz = Class.forName(LUCENE_DS_CLASS);
            this.cleanWriteLocksInLuceneDirectory(this.storeDir + "/lucene");
            lucene = this.registerLuceneDataSource(clazz.getName(), this.config.getTxModule(), this.storeDir + "/lucene", this.config.getLockManager());
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        this.persistenceSource = new NioNeoDbPersistenceSource();
        this.config.setNeoPersistenceSource(DEFAULT_DATA_SOURCE_NAME, this.create);
        this.config.getIdGeneratorModule().setPersistenceSourceInstance(this.persistenceSource);
        this.config.getEventModule().init();
        this.config.getTxModule().init();
        this.config.getPersistenceModule().init();
        this.persistenceSource.init();
        this.config.getIdGeneratorModule().init();
        this.config.getNeoModule().init();
        this.config.getEventModule().start();
        this.config.getTxModule().start();
        this.config.getPersistenceModule().start(this.config.getTxModule().getTxManager(), this.persistenceSource);
        this.persistenceSource.start(this.config.getTxModule().getXaDataSourceManager());
        this.config.getIdGeneratorModule().start();
        this.config.getNeoModule().start(this.config.getLockReleaser(), this.config.getPersistenceModule().getPersistenceManager(), params);
        if (lucene != null) {
            this.config.getTxModule().getXaDataSourceManager().unregisterDataSource("lucene");
            lucene = null;
        }
        this.started = true;
    }

    private void cleanWriteLocksInLuceneDirectory(String luceneDir) {
        File dir = new File(luceneDir);
        if (!dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.cleanWriteLocksInLuceneDirectory(file.getAbsolutePath());
                continue;
            }
            if (!file.getName().equals("write.lock")) continue;
            boolean success = file.delete();
            assert (success);
        }
    }

    private XaDataSource registerLuceneDataSource(String className, TxModule txModule, String luceneDirectory, LockManager lockManager) {
        byte[] resourceId = "162373".getBytes();
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put("dir", luceneDirectory);
        params.put(LockManager.class, lockManager);
        return txModule.registerDataSource("lucene", className, resourceId, params, true);
    }

    private String convertFileSeparators(String fileName) {
        String fileSeparator = System.getProperty("file.separator");
        if ("\\".equals(fileSeparator)) {
            return fileName.replace('/', '\\');
        }
        if ("/".equals(fileSeparator)) {
            return fileName.replace('\\', '/');
        }
        return fileName;
    }

    public boolean started() {
        return this.started;
    }

    public synchronized void shutdown() {
        if (this.started) {
            this.config.getNeoModule().stop();
            this.config.getIdGeneratorModule().stop();
            this.persistenceSource.stop();
            this.config.getPersistenceModule().stop();
            this.config.getTxModule().stop();
            this.config.getEventModule().stop();
            this.config.getNeoModule().destroy();
            this.config.getIdGeneratorModule().destroy();
            this.persistenceSource.destroy();
            this.config.getPersistenceModule().destroy();
            this.config.getTxModule().destroy();
            this.config.getEventModule().destroy();
        }
        this.started = false;
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.config.getNeoModule().getRelationshipTypes();
    }

    public boolean transactionRunning() {
        try {
            return this.config.getTxModule().getTxManager().getTransaction() != null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.config.getTxModule().getTxManager();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Config {
        private EventModule eventModule;
        private AdaptiveCacheManager cacheManager;
        private TxModule txModule;
        private LockManager lockManager;
        private LockReleaser lockReleaser;
        private PersistenceModule persistenceModule;
        private boolean create = false;
        private String persistenceSourceName;
        private IdGeneratorModule idGeneratorModule;
        private NeoModule neoModule;
        private String storeDir;
        private final Map<Object, Object> params;

        Config(String storeDir, Map<Object, Object> params) {
            this.storeDir = storeDir;
            this.params = params;
            this.eventModule = new EventModule();
            this.cacheManager = new AdaptiveCacheManager();
            this.txModule = new TxModule(this.storeDir);
            this.lockManager = new LockManager(this.txModule.getTxManager());
            this.lockReleaser = new LockReleaser(this.lockManager, this.txModule.getTxManager());
            this.persistenceModule = new PersistenceModule();
            this.idGeneratorModule = new IdGeneratorModule();
            this.neoModule = new NeoModule(this.cacheManager, this.lockManager, this.txModule.getTxManager(), this.idGeneratorModule.getIdGenerator());
        }

        void setNeoPersistenceSource(String name, boolean create) {
            this.persistenceSourceName = name;
            this.create = create;
        }

        String getPersistenceSource() {
            return this.persistenceSourceName;
        }

        boolean getCreatePersistenceSource() {
            return this.create;
        }

        public EventModule getEventModule() {
            return this.eventModule;
        }

        public TxModule getTxModule() {
            return this.txModule;
        }

        public NeoModule getNeoModule() {
            return this.neoModule;
        }

        public PersistenceModule getPersistenceModule() {
            return this.persistenceModule;
        }

        IdGeneratorModule getIdGeneratorModule() {
            return this.idGeneratorModule;
        }

        public LockManager getLockManager() {
            return this.lockManager;
        }

        public LockReleaser getLockReleaser() {
            return this.lockReleaser;
        }

        public Map<Object, Object> getParams() {
            return this.params;
        }
    }
}

