/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.neo4j.api.core.EmbeddedNeo;
import org.neo4j.api.core.NeoService;

public class StandaloneWithShell {
    private static Logger log = Logger.getLogger(StandaloneWithShell.class.getName());
    private NeoService embeddedNeo;
    private AtomicBoolean shutdownInitiated = new AtomicBoolean(false);

    private NeoService getNeo() {
        return this.embeddedNeo;
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                StandaloneWithShell.this.shutdown();
            }
        });
    }

    private void initialize() {
        this.embeddedNeo = new EmbeddedNeo("var/neo");
        Map<String, Serializable> shellProperties = Collections.emptyMap();
        this.getNeo().enableRemoteShell(shellProperties);
        log.info("Neo started");
    }

    private void blockUntilShutdown() {
        try {
            while (!this.shutdownInitiated.get()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    private void shutdown() {
        if (this.shutdownInitiated.compareAndSet(false, true)) {
            log.info("Shutting down...");
            try {
                if (this.getNeo() != null) {
                    this.getNeo().shutdown();
                    this.embeddedNeo = null;
                }
            }
            catch (Throwable t) {
                log.warning("Error shutting down Neo: " + t);
            }
        }
    }

    public void execute() {
        this.addShutdownHook();
        this.initialize();
        this.blockUntilShutdown();
    }

    public static void main(String[] args) {
        new StandaloneWithShell().execute();
    }
}

