/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.core;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.api.core.Relationship;
import org.neo4j.impl.core.NodeManager;
import org.neo4j.impl.core.RelTypeElementIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntArrayIterator
implements Iterable<Relationship>,
Iterator<Relationship> {
    private Logger log = Logger.getLogger(IntArrayIterator.class.getName());
    private Iterator<RelTypeElementIterator> typeIterator;
    private Iterator<Integer> currentTypeIterator = null;
    private Node fromNode;
    private Direction direction = null;
    private Relationship nextElement = null;
    private final NodeManager nodeManager;
    private int position = 0;

    IntArrayIterator(List<RelTypeElementIterator> rels, Node fromNode, Direction direction, NodeManager nodeManager) {
        this.typeIterator = rels.iterator();
        this.currentTypeIterator = this.typeIterator.hasNext() ? (Iterator)this.typeIterator.next() : Collections.EMPTY_LIST.iterator();
        this.fromNode = fromNode;
        this.direction = direction;
        this.nodeManager = nodeManager;
    }

    IntArrayIterator(Iterator<RelTypeElementIterator> rels, Node fromNode, Direction direction, NodeManager nodeManager) {
        this.typeIterator = rels;
        this.fromNode = fromNode;
        this.direction = direction;
        this.nodeManager = nodeManager;
    }

    @Override
    public Iterator<Relationship> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.nextElement != null) {
            return true;
        }
        do {
            if (this.currentTypeIterator.hasNext()) {
                int nextId = this.currentTypeIterator.next();
                try {
                    Relationship possibleElement = this.nodeManager.getRelationshipById(nextId);
                    if (this.direction == Direction.INCOMING && possibleElement.getEndNode().equals(this.fromNode)) {
                        this.nextElement = possibleElement;
                        return true;
                    }
                    if (this.direction == Direction.OUTGOING && possibleElement.getStartNode().equals(this.fromNode)) {
                        this.nextElement = possibleElement;
                        return true;
                    }
                    if (this.direction == Direction.BOTH) {
                        this.nextElement = possibleElement;
                        return true;
                    }
                }
                catch (NotFoundException e) {
                    this.log.log(Level.FINE, "Unable to get relationship " + nextId, e);
                }
            }
            while (!this.currentTypeIterator.hasNext() && this.typeIterator.hasNext()) {
                this.currentTypeIterator = this.typeIterator.next();
            }
        } while (this.currentTypeIterator.hasNext());
        return false;
    }

    @Override
    public Relationship next() {
        this.hasNext();
        if (this.nextElement != null) {
            Relationship elementToReturn = this.nextElement;
            this.nextElement = null;
            return elementToReturn;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

