/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.core;

import java.util.Map;
import java.util.logging.Logger;
import javax.transaction.TransactionManager;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.impl.cache.AdaptiveCacheManager;
import org.neo4j.impl.core.LockReleaser;
import org.neo4j.impl.core.NodeManager;
import org.neo4j.impl.nioneo.store.PropertyIndexData;
import org.neo4j.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.impl.persistence.IdGenerator;
import org.neo4j.impl.persistence.PersistenceManager;
import org.neo4j.impl.transaction.LockManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoModule {
    private static Logger log = Logger.getLogger(NeoModule.class.getName());
    private boolean startIsOk = true;
    private static final int INDEX_COUNT = 2500;
    private final TransactionManager transactionManager;
    private final AdaptiveCacheManager cacheManager;
    private final LockManager lockManager;
    private final IdGenerator idGenerator;
    private NodeManager nodeManager;

    public NeoModule(AdaptiveCacheManager cacheManager, LockManager lockManager, TransactionManager transactionManager, IdGenerator idGenerator) {
        this.cacheManager = cacheManager;
        this.lockManager = lockManager;
        this.transactionManager = transactionManager;
        this.idGenerator = idGenerator;
    }

    public void init() {
    }

    public void start(LockReleaser lockReleaser, PersistenceManager persistenceManager, Map<Object, Object> params) {
        if (!this.startIsOk) {
            return;
        }
        boolean useNewCache = true;
        if (params.containsKey("use_old_cache") && params.get("use_old_cache").equals("true")) {
            useNewCache = false;
        }
        this.nodeManager = new NodeManager(this.cacheManager, this.lockManager, lockReleaser, this.transactionManager, persistenceManager, this.idGenerator, useNewCache);
        RelationshipTypeData[] relTypes = null;
        PropertyIndexData[] propertyIndexes = null;
        try {
            this.transactionManager.begin();
            relTypes = persistenceManager.loadAllRelationshipTypes();
            propertyIndexes = persistenceManager.loadPropertyIndexes(2500);
            this.transactionManager.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.transactionManager.rollback();
            }
            catch (Exception ee) {
                ee.printStackTrace();
                log.severe("Unable to rollback tx");
            }
            throw new RuntimeException("Unable to load all relationships", e);
        }
        this.nodeManager.addRawRelationshipTypes(relTypes);
        this.nodeManager.addPropertyIndexes(propertyIndexes);
        if (propertyIndexes.length < 2500) {
            this.nodeManager.setHasAllpropertyIndexes(true);
        }
        this.nodeManager.start(params);
        this.startIsOk = false;
    }

    public int getNodeCacheSize() {
        return this.nodeManager.getNodeMaxCacheSize();
    }

    public int getRelationshipCacheSize() {
        return this.nodeManager.getRelationshipMaxCacheSize();
    }

    public void setReferenceNodeId(Integer nodeId) {
        this.nodeManager.setReferenceNodeId(nodeId);
        try {
            this.nodeManager.getReferenceNode();
        }
        catch (NotFoundException e) {
            log.warning("Reference node[" + nodeId + "] not valid.");
        }
    }

    public Integer getCurrentReferenceNodeId() {
        try {
            return (int)this.nodeManager.getReferenceNode().getId();
        }
        catch (NotFoundException e) {
            return -1;
        }
    }

    public void createNewReferenceNode() {
        try {
            Node node = this.nodeManager.createNode();
            this.nodeManager.setReferenceNodeId((int)node.getId());
            log.fine("Created a new reference node. Current reference node is now " + node);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.severe("Unable to create new reference node.");
        }
    }

    public void reload(Map<Object, Object> params) {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        this.nodeManager.clearPropertyIndexes();
        this.nodeManager.clearCache();
        this.nodeManager.stop();
    }

    public void destroy() {
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.nodeManager.getRelationshipTypes();
    }
}

