/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.impl.core.NodeManager;
import org.neo4j.impl.core.PropertyIndex;
import org.neo4j.impl.nioneo.store.PropertyData;
import org.neo4j.impl.transaction.LockType;
import org.neo4j.impl.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class NeoPrimitive {
    protected final int id;
    protected final NodeManager nodeManager;
    private ArrayMap<Integer, PropertyData> propertyMap = null;

    protected abstract void changeProperty(int var1, Object var2);

    protected abstract int addProperty(PropertyIndex var1, Object var2);

    protected abstract void removeProperty(int var1);

    protected abstract ArrayMap<Integer, PropertyData> loadProperties();

    NeoPrimitive(int id, NodeManager nodeManager) {
        this.id = id;
        this.nodeManager = nodeManager;
    }

    NeoPrimitive(int id, boolean newPrimitive, NodeManager nodeManager) {
        this.id = id;
        this.nodeManager = nodeManager;
        if (newPrimitive) {
            this.propertyMap = new ArrayMap(9, false, true);
        }
    }

    public long getId() {
        return this.id;
    }

    public Iterable<Object> getPropertyValues() {
        ArrayMap<Integer, PropertyData> skipMap = this.nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = this.nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Integer index : this.propertyMap.keySet()) {
            if (skipMap != null && skipMap.get(index) != null || addMap != null && addMap.get(index) != null) continue;
            values.add(this.propertyMap.get(index).getValue());
        }
        if (addMap != null) {
            for (PropertyData property : addMap.values()) {
                values.add(property.getValue());
            }
        }
        return values;
    }

    public Iterable<String> getPropertyKeys() {
        ArrayMap<Integer, PropertyData> skipMap = this.nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = this.nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties();
        ArrayList<String> keys = new ArrayList<String>();
        for (Integer index : this.propertyMap.keySet()) {
            if (skipMap != null && skipMap.get(index) != null || addMap != null && addMap.get(index) != null) continue;
            keys.add(this.nodeManager.getIndexFor(index).getKey());
        }
        if (addMap != null) {
            for (Integer index : addMap.keySet()) {
                keys.add(this.nodeManager.getIndexFor(index).getKey());
            }
        }
        return keys;
    }

    public Object getProperty(String key) throws NotFoundException {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        ArrayMap<Integer, PropertyData> skipMap = this.nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = this.nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties();
        for (PropertyIndex index : this.nodeManager.index(key)) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.getKeyId()) != null) {
                throw this.newPropertyNotFoundException(key);
            }
            if (addMap != null && (property = addMap.get(index.getKeyId())) != null) {
                return this.getPropertyValue(property);
            }
            property = this.propertyMap.get(index.getKeyId());
            if (property == null) continue;
            return this.getPropertyValue(property);
        }
        PropertyData property = this.getSlowProperty(addMap, skipMap, key);
        if (property != null) {
            return this.getPropertyValue(property);
        }
        throw this.newPropertyNotFoundException(key);
    }

    private NotFoundException newPropertyNotFoundException(String key) {
        return new NotFoundException(key + " property not found for " + this + ".");
    }

    private PropertyData getSlowProperty(ArrayMap<Integer, PropertyData> addMap, ArrayMap<Integer, PropertyData> skipMap, String key) {
        PropertyData property;
        PropertyIndex indexToCheck;
        if (this.nodeManager.hasAllPropertyIndexes()) {
            return null;
        }
        if (addMap != null) {
            for (int keyId : addMap.keySet()) {
                if (this.nodeManager.hasIndexFor(keyId) || !(indexToCheck = this.nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
                if (skipMap != null && skipMap.get(keyId) != null) {
                    throw this.newPropertyNotFoundException(key);
                }
                property = addMap.get(indexToCheck.getKeyId());
                if (property == null) continue;
                return property;
            }
        }
        for (int keyId : this.propertyMap.keySet()) {
            if (this.nodeManager.hasIndexFor(keyId) || !(indexToCheck = this.nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
            if (skipMap != null && skipMap.get(keyId) != null) {
                throw this.newPropertyNotFoundException(key);
            }
            property = this.propertyMap.get(indexToCheck.getKeyId());
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public Object getProperty(String key, Object defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        ArrayMap<Integer, PropertyData> skipMap = this.nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = this.nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties();
        for (PropertyIndex index : this.nodeManager.index(key)) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.getKeyId()) != null) {
                return defaultValue;
            }
            if (addMap != null && (property = addMap.get(index.getKeyId())) != null) {
                return this.getPropertyValue(property);
            }
            property = this.propertyMap.get(index.getKeyId());
            if (property == null) continue;
            return this.getPropertyValue(property);
        }
        PropertyData property = this.getSlowProperty(addMap, skipMap, key);
        if (property != null) {
            return this.getPropertyValue(property);
        }
        return defaultValue;
    }

    public boolean hasProperty(String key) {
        if (key == null) {
            return false;
        }
        ArrayMap<Integer, PropertyData> skipMap = this.nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = this.nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties();
        for (PropertyIndex index : this.nodeManager.index(key)) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.getKeyId()) != null) {
                return false;
            }
            if (addMap != null && (property = addMap.get(index.getKeyId())) != null) {
                return true;
            }
            property = this.propertyMap.get(index.getKeyId());
            if (property == null) continue;
            return true;
        }
        PropertyData property = this.getSlowProperty(addMap, skipMap, key);
        return property != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Null parameter, key=" + key + ", " + "value=" + value);
        }
        this.nodeManager.acquireLock(this, LockType.WRITE);
        boolean success = false;
        try {
            this.ensureFullProperties();
            ArrayMap<Integer, PropertyData> addMap = this.nodeManager.getCowPropertyAddMap(this, true);
            ArrayMap<Integer, PropertyData> skipMap = this.nodeManager.getCowPropertyRemoveMap(this);
            PropertyIndex index = null;
            PropertyData property = null;
            boolean foundInSkipMap = false;
            for (PropertyIndex cachedIndex : this.nodeManager.index(key)) {
                if (skipMap != null && skipMap.remove(cachedIndex.getKeyId()) != null) {
                    foundInSkipMap = true;
                }
                index = cachedIndex;
                property = addMap.get(cachedIndex.getKeyId());
                if (property == null && (property = this.propertyMap.get(cachedIndex.getKeyId())) == null) continue;
                break;
            }
            if (property == null && !this.nodeManager.hasAllPropertyIndexes()) {
                PropertyIndex indexToCheck;
                Iterator<Object> i$ = addMap.keySet().iterator();
                while (i$.hasNext()) {
                    int keyId = (Integer)i$.next();
                    if (this.nodeManager.hasIndexFor(keyId) || !(indexToCheck = this.nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
                    if (skipMap != null) {
                        skipMap.remove(indexToCheck.getKeyId());
                    }
                    index = indexToCheck;
                    property = addMap.get(indexToCheck.getKeyId());
                    if (property == null) continue;
                    break;
                }
                if (property == null) {
                    i$ = this.propertyMap.keySet().iterator();
                    while (i$.hasNext()) {
                        int keyId = (Integer)i$.next();
                        if (this.nodeManager.hasIndexFor(keyId) || !(indexToCheck = this.nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
                        if (skipMap != null) {
                            skipMap.remove(indexToCheck.getKeyId());
                        }
                        index = indexToCheck;
                        property = this.propertyMap.get(indexToCheck.getKeyId());
                        if (property == null) continue;
                        break;
                    }
                }
            }
            if (index == null) {
                index = this.nodeManager.createPropertyIndex(key);
            }
            if (property != null && !foundInSkipMap) {
                int propertyId = property.getId();
                this.changeProperty(propertyId, value);
                property.setNewValue(value);
            } else {
                int propertyId = this.addProperty(index, value);
                property = new PropertyData(propertyId, value);
            }
            addMap.put(index.getKeyId(), property);
            success = true;
        }
        finally {
            this.nodeManager.releaseLock(this, LockType.WRITE);
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Null parameter.");
        }
        this.nodeManager.acquireLock(this, LockType.WRITE);
        boolean success = false;
        try {
            Object object;
            this.ensureFullProperties();
            PropertyData property = null;
            ArrayMap<Integer, PropertyData> addMap = this.nodeManager.getCowPropertyAddMap(this);
            ArrayMap<Integer, PropertyData> removeMap = this.nodeManager.getCowPropertyRemoveMap(this, true);
            for (PropertyIndex cachedIndex : this.nodeManager.index(key)) {
                if (addMap != null && (property = addMap.remove(cachedIndex.getKeyId())) != null) {
                    removeMap.put(cachedIndex.getKeyId(), property);
                    break;
                }
                if (removeMap.get(cachedIndex.getKeyId()) != null) {
                    success = true;
                    Object var8_10 = null;
                    return var8_10;
                }
                property = this.propertyMap.get(cachedIndex.getKeyId());
                if (property == null) continue;
                removeMap.put(cachedIndex.getKeyId(), property);
                break;
            }
            if (property == null && !this.nodeManager.hasAllPropertyIndexes() && addMap != null) {
                PropertyIndex indexToCheck;
                Iterator<Object> i$ = addMap.keySet().iterator();
                while (i$.hasNext()) {
                    int keyId = (Integer)i$.next();
                    if (this.nodeManager.hasIndexFor(keyId) || !(indexToCheck = this.nodeManager.getIndexFor(keyId)).getKey().equals(key) || (property = addMap.remove(indexToCheck.getKeyId())) == null) continue;
                    removeMap.put(indexToCheck.getKeyId(), property);
                    break;
                }
                if (property == null) {
                    i$ = this.propertyMap.keySet().iterator();
                    while (i$.hasNext()) {
                        int keyId = (Integer)i$.next();
                        if (this.nodeManager.hasIndexFor(keyId) || !(indexToCheck = this.nodeManager.getIndexFor(keyId)).getKey().equals(key) || (property = this.propertyMap.get(indexToCheck.getKeyId())) == null) continue;
                        removeMap.put(indexToCheck.getKeyId(), property);
                        break;
                    }
                }
            }
            if (property == null) {
                success = true;
                object = null;
                return object;
            }
            this.removeProperty(property.getId());
            success = true;
            object = this.getPropertyValue(property);
            return object;
        }
        finally {
            this.nodeManager.releaseLock(this, LockType.WRITE);
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    private Object getPropertyValue(PropertyData property) {
        Object value = property.getValue();
        if (value == null) {
            value = this.nodeManager.loadPropertyValue(property.getId());
            property.setNewValue(value);
        }
        return value;
    }

    protected void commitPropertyMaps(ArrayMap<Integer, PropertyData> cowPropertyAddMap, ArrayMap<Integer, PropertyData> cowPropertyRemoveMap) {
        if (this.propertyMap == null) {
            return;
        }
        if (cowPropertyAddMap != null) {
            for (Integer index : cowPropertyAddMap.keySet()) {
                this.propertyMap.put(index, cowPropertyAddMap.get(index));
            }
        }
        if (cowPropertyRemoveMap != null && this.propertyMap != null) {
            for (Integer index : cowPropertyRemoveMap.keySet()) {
                this.propertyMap.remove(index);
            }
        }
    }

    private boolean ensureFullProperties() {
        if (this.propertyMap == null) {
            this.propertyMap = this.loadProperties();
            return true;
        }
        return false;
    }

    protected void setRollbackOnly() {
        this.nodeManager.setRollbackOnly();
    }
}

