/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.core;

import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.ReturnableEvaluator;
import org.neo4j.api.core.StopEvaluator;
import org.neo4j.api.core.Traverser;
import org.neo4j.impl.cache.AdaptiveCacheManager;
import org.neo4j.impl.cache.Cache;
import org.neo4j.impl.cache.LruCache;
import org.neo4j.impl.cache.SoftLruCache;
import org.neo4j.impl.core.LockReleaser;
import org.neo4j.impl.core.NeoPrimitive;
import org.neo4j.impl.core.NodeImpl;
import org.neo4j.impl.core.NodeProxy;
import org.neo4j.impl.core.PropertyIndex;
import org.neo4j.impl.core.PropertyIndexManager;
import org.neo4j.impl.core.RelationshipImpl;
import org.neo4j.impl.core.RelationshipProxy;
import org.neo4j.impl.core.RelationshipTypeHolder;
import org.neo4j.impl.nioneo.store.PropertyData;
import org.neo4j.impl.nioneo.store.PropertyIndexData;
import org.neo4j.impl.nioneo.store.RelationshipData;
import org.neo4j.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.impl.persistence.IdGenerator;
import org.neo4j.impl.persistence.PersistenceManager;
import org.neo4j.impl.transaction.IllegalResourceException;
import org.neo4j.impl.transaction.LockManager;
import org.neo4j.impl.transaction.LockType;
import org.neo4j.impl.traversal.InternalTraverserFactory;
import org.neo4j.impl.util.ArrayMap;
import org.neo4j.impl.util.IntArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeManager {
    private static Logger log = Logger.getLogger(NodeManager.class.getName());
    private int referenceNodeId = 0;
    private final Cache<Integer, NodeImpl> nodeCache;
    private final Cache<Integer, RelationshipImpl> relCache;
    private final AdaptiveCacheManager cacheManager;
    private final LockManager lockManager;
    private final TransactionManager transactionManager;
    private final LockReleaser lockReleaser;
    private final PropertyIndexManager propertyIndexManager;
    private final InternalTraverserFactory traverserFactory;
    private final RelationshipTypeHolder relTypeHolder;
    private final PersistenceManager persistenceManager;
    private final IdGenerator idGenerator;
    private boolean useAdaptiveCache = true;
    private float adaptiveCacheHeapRatio = 0.77f;
    private int minNodeCacheSize = 0;
    private int minRelCacheSize = 0;
    private int maxNodeCacheSize = 1500;
    private int maxRelCacheSize = 3500;
    private static final int LOCK_STRIPE_COUNT = 5;
    private final ReentrantLock[] loadLocks = new ReentrantLock[5];

    NodeManager(AdaptiveCacheManager cacheManager, LockManager lockManager, LockReleaser lockReleaser, TransactionManager transactionManager, PersistenceManager persistenceManager, IdGenerator idGenerator, boolean useNewCaches) {
        this.cacheManager = cacheManager;
        this.lockManager = lockManager;
        this.transactionManager = transactionManager;
        this.propertyIndexManager = new PropertyIndexManager(transactionManager, persistenceManager, idGenerator);
        this.lockReleaser = lockReleaser;
        lockReleaser.setNodeManager(this);
        lockReleaser.setPropertyIndexManager(this.propertyIndexManager);
        this.persistenceManager = persistenceManager;
        this.idGenerator = idGenerator;
        this.traverserFactory = new InternalTraverserFactory();
        this.relTypeHolder = new RelationshipTypeHolder(transactionManager, persistenceManager, idGenerator);
        if (useNewCaches) {
            this.nodeCache = new SoftLruCache<Integer, NodeImpl>("NodeCache");
            this.relCache = new SoftLruCache<Integer, RelationshipImpl>("RelationshipCache");
        } else {
            this.nodeCache = new LruCache<Integer, NodeImpl>("NodeCache", 1500, this.cacheManager);
            this.relCache = new LruCache<Integer, RelationshipImpl>("RelationshipCache", 3500, this.cacheManager);
        }
        for (int i = 0; i < this.loadLocks.length; ++i) {
            this.loadLocks[i] = new ReentrantLock();
        }
    }

    private void parseParams(Map<Object, Object> params) {
        Object value;
        if (params.containsKey("use_adaptive_cache")) {
            value = (String)params.get("use_adaptive_cache");
            if (((String)value).toLowerCase().equals("yes")) {
                this.useAdaptiveCache = true;
            } else if (((String)value).toLowerCase().equals("no")) {
                this.useAdaptiveCache = false;
            } else {
                log.warning("Unable to parse use_adaptive_cache=" + (String)value);
            }
        }
        if (params.containsKey("adaptive_cache_heap_ratio")) {
            value = params.get("adaptive_cache_heap_ratio");
            try {
                this.adaptiveCacheHeapRatio = Float.parseFloat((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse adaptive_cache_heap_ratio " + value);
            }
            if (this.adaptiveCacheHeapRatio < 0.1f) {
                this.adaptiveCacheHeapRatio = 0.1f;
            }
            if (this.adaptiveCacheHeapRatio > 0.95f) {
                this.adaptiveCacheHeapRatio = 0.95f;
            }
        }
        if (params.containsKey("min_node_cache_size")) {
            value = params.get("min_node_cache_size");
            try {
                this.minNodeCacheSize = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse min_node_cache_size " + value);
            }
        }
        if (params.containsKey("min_relationship_cache_size")) {
            value = params.get("min_relationship_cache_size");
            try {
                this.minRelCacheSize = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse min_relationship_cache_size " + value);
            }
        }
        if (params.containsKey("max_node_cache_size")) {
            value = params.get("max_node_cache_size");
            try {
                this.maxNodeCacheSize = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse max_node_cache_size " + value);
            }
        }
        if (params.containsKey("max_relationship_cache_size")) {
            value = params.get("max_relationship_cache_size");
            try {
                this.maxRelCacheSize = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                log.warning("Unable to parse max_relationship_cache_size " + value);
            }
        }
    }

    public void start(Map<Object, Object> params) {
        this.parseParams(params);
        this.nodeCache.resize(this.maxNodeCacheSize);
        this.relCache.resize(this.maxRelCacheSize);
        if (this.useAdaptiveCache) {
            this.cacheManager.registerCache(this.nodeCache, this.adaptiveCacheHeapRatio, this.minNodeCacheSize);
            this.cacheManager.registerCache(this.relCache, this.adaptiveCacheHeapRatio, this.minRelCacheSize);
            this.cacheManager.start(params);
        }
    }

    public void stop() {
        if (this.useAdaptiveCache) {
            this.cacheManager.stop();
            this.cacheManager.unregisterCache(this.nodeCache);
            this.cacheManager.unregisterCache(this.relCache);
        }
        this.relTypeHolder.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createNode() {
        int id = this.idGenerator.nextId(Node.class);
        NodeImpl node = new NodeImpl(id, true, this);
        this.acquireLock(node, LockType.WRITE);
        boolean success = false;
        try {
            this.persistenceManager.nodeCreate(id);
            this.nodeCache.put((int)node.getId(), node);
            success = true;
            NodeProxy nodeProxy = new NodeProxy(id, this);
            return nodeProxy;
        }
        finally {
            this.releaseLock(node, LockType.WRITE);
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship createRelationship(Node startNode, Node endNode, RelationshipType type) {
        Exception e22;
        boolean releaseFailed2;
        RelationshipProxy relationshipProxy;
        boolean success;
        boolean secondNodeTaken;
        RelationshipImpl rel;
        NodeImpl secondNode;
        block19: {
            int startNodeId;
            NodeImpl firstNode;
            if (startNode == null || endNode == null || type == null) {
                throw new IllegalArgumentException("Null parameter, startNode=" + startNode + ", endNode=" + endNode + ", type=" + type);
            }
            if (!this.relTypeHolder.isValidRelationshipType(type)) {
                this.relTypeHolder.addValidRelationshipType(type.name(), true);
            }
            if ((firstNode = this.getLightNode(startNodeId = (int)startNode.getId())) == null) {
                this.setRollbackOnly();
                throw new RuntimeException("First node[" + startNode.getId() + "] deleted");
            }
            int endNodeId = (int)endNode.getId();
            secondNode = this.getLightNode(endNodeId);
            if (secondNode == null) {
                this.setRollbackOnly();
                throw new RuntimeException("Second node[" + endNode.getId() + "] deleted");
            }
            int id = this.idGenerator.nextId(Relationship.class);
            rel = new RelationshipImpl(id, startNodeId, endNodeId, type, true, this);
            boolean firstNodeTaken = false;
            secondNodeTaken = false;
            this.acquireLock(rel, LockType.WRITE);
            success = false;
            try {
                this.acquireLock(firstNode, LockType.WRITE);
                firstNodeTaken = true;
                this.acquireLock(secondNode, LockType.WRITE);
                secondNodeTaken = true;
                int typeId = this.getRelationshipTypeIdFor(type);
                this.persistenceManager.relationshipCreate(id, typeId, startNodeId, endNodeId);
                firstNode.addRelationship(type, id);
                secondNode.addRelationship(type, id);
                this.relCache.put((int)rel.getId(), rel);
                success = true;
                relationshipProxy = new RelationshipProxy(id, this);
                Object var16_15 = null;
                releaseFailed2 = false;
                if (!firstNodeTaken) break block19;
            }
            catch (Throwable throwable) {
                Exception e22;
                Object var16_16 = null;
                boolean releaseFailed2 = false;
                if (firstNodeTaken) {
                    try {
                        this.releaseLock(firstNode, LockType.WRITE);
                    }
                    catch (Exception e22) {
                        releaseFailed2 = true;
                        e22.printStackTrace();
                        log.severe("Failed to release lock");
                    }
                }
                if (secondNodeTaken) {
                    try {
                        this.releaseLock(secondNode, LockType.WRITE);
                    }
                    catch (Exception e22) {
                        releaseFailed2 = true;
                        e22.printStackTrace();
                        log.severe("Failed to release lock");
                    }
                }
                this.releaseLock(rel, LockType.WRITE);
                if (!success) {
                    this.setRollbackOnly();
                }
                if (releaseFailed2) {
                    throw new RuntimeException("Unable to release locks [" + startNode + "," + endNode + "] in relationship create->" + rel);
                }
                throw throwable;
            }
            try {
                this.releaseLock(firstNode, LockType.WRITE);
            }
            catch (Exception e22) {
                releaseFailed2 = true;
                e22.printStackTrace();
                log.severe("Failed to release lock");
            }
        }
        if (secondNodeTaken) {
            try {
                this.releaseLock(secondNode, LockType.WRITE);
            }
            catch (Exception e22) {
                releaseFailed2 = true;
                e22.printStackTrace();
                log.severe("Failed to release lock");
            }
        }
        this.releaseLock(rel, LockType.WRITE);
        if (!success) {
            this.setRollbackOnly();
        }
        if (releaseFailed2) {
            throw new RuntimeException("Unable to release locks [" + startNode + "," + endNode + "] in relationship create->" + rel);
        }
        return relationshipProxy;
    }

    private ReentrantLock lockId(int id) {
        ReentrantLock lock = this.loadLocks[id % 5];
        lock.lock();
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getNodeById(int nodeId) throws NotFoundException {
        if (nodeId < 0) {
            throw new IllegalArgumentException("Negative node id " + nodeId);
        }
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node != null) {
            return new NodeProxy(nodeId, this);
        }
        node = new NodeImpl(nodeId, this);
        ReentrantLock loadLock = this.lockId(nodeId);
        try {
            if (this.nodeCache.get(nodeId) != null) {
                NodeProxy nodeProxy = new NodeProxy(nodeId, this);
                return nodeProxy;
            }
            if (!this.persistenceManager.loadLightNode(nodeId)) {
                throw new NotFoundException("Node[" + nodeId + "]");
            }
            this.nodeCache.put(nodeId, node);
            NodeProxy nodeProxy = new NodeProxy(nodeId, this);
            return nodeProxy;
        }
        finally {
            loadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeImpl getLightNode(int nodeId) {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node != null) {
            return node;
        }
        node = new NodeImpl(nodeId, this);
        ReentrantLock loadLock = this.lockId(nodeId);
        try {
            if (this.nodeCache.get(nodeId) != null) {
                NodeImpl nodeImpl = node = this.nodeCache.get(nodeId);
                return nodeImpl;
            }
            if (!this.persistenceManager.loadLightNode(nodeId)) {
                NodeImpl nodeImpl = null;
                return nodeImpl;
            }
            this.nodeCache.put(nodeId, node);
            NodeImpl nodeImpl = node;
            return nodeImpl;
        }
        finally {
            loadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeImpl getNodeForProxy(int nodeId) {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node != null) {
            return node;
        }
        node = new NodeImpl(nodeId, this);
        ReentrantLock loadLock = this.lockId(nodeId);
        try {
            if (this.nodeCache.get(nodeId) != null) {
                NodeImpl nodeImpl = node = this.nodeCache.get(nodeId);
                return nodeImpl;
            }
            if (!this.persistenceManager.loadLightNode(nodeId)) {
                throw new NotFoundException("Node[" + nodeId + "] not found.");
            }
            this.nodeCache.put(nodeId, node);
            NodeImpl nodeImpl = node;
            return nodeImpl;
        }
        finally {
            loadLock.unlock();
        }
    }

    public Node getReferenceNode() throws NotFoundException {
        if (this.referenceNodeId == -1) {
            throw new NotFoundException("No reference node set");
        }
        return this.getNodeById(this.referenceNodeId);
    }

    void setReferenceNodeId(int nodeId) {
        this.referenceNodeId = nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship getRelationshipById(int relId) throws NotFoundException {
        if (relId < 0) {
            throw new IllegalArgumentException("Negative id " + relId);
        }
        RelationshipImpl relationship = this.relCache.get(relId);
        if (relationship != null) {
            return new RelationshipProxy(relId, this);
        }
        relationship = new RelationshipImpl(relId, this);
        ReentrantLock loadLock = this.lockId(relId);
        try {
            if (this.relCache.get(relId) != null) {
                relationship = this.relCache.get(relId);
                RelationshipProxy relationshipProxy = new RelationshipProxy(relId, this);
                return relationshipProxy;
            }
            RelationshipData data = this.persistenceManager.loadLightRelationship(relId);
            if (data == null) {
                throw new NotFoundException("Relationship[" + relId + "] not found");
            }
            int typeId = data.relationshipType();
            RelationshipType type = this.getRelationshipTypeById(typeId);
            if (type == null) {
                throw new RuntimeException("Relationship[" + data.getId() + "] exist but relationship type[" + typeId + "] not found.");
            }
            int startNodeId = data.firstNode();
            int endNodeId = data.secondNode();
            relationship = new RelationshipImpl(relId, startNodeId, endNodeId, type, false, this);
            this.relCache.put(relId, relationship);
            RelationshipProxy relationshipProxy = new RelationshipProxy(relId, this);
            return relationshipProxy;
        }
        finally {
            loadLock.unlock();
        }
    }

    RelationshipType getRelationshipTypeById(int id) {
        return this.relTypeHolder.getRelationshipType(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Relationship getRelForProxy(int relId) {
        RelationshipImpl relationship = this.relCache.get(relId);
        if (relationship != null) {
            return relationship;
        }
        relationship = new RelationshipImpl(relId, this);
        ReentrantLock loadLock = this.lockId(relId);
        try {
            if (this.relCache.get(relId) != null) {
                RelationshipImpl relationshipImpl = relationship = this.relCache.get(relId);
                return relationshipImpl;
            }
            RelationshipData data = this.persistenceManager.loadLightRelationship(relId);
            if (data == null) {
                throw new NotFoundException("Relationship[" + relId + "] not found.");
            }
            int typeId = data.relationshipType();
            RelationshipType type = this.getRelationshipTypeById(typeId);
            if (type == null) {
                throw new RuntimeException("Relationship[" + data.getId() + "] exist but relationship type[" + typeId + "] not found.");
            }
            relationship = new RelationshipImpl(relId, data.firstNode(), data.secondNode(), type, false, this);
            this.relCache.put(relId, relationship);
            RelationshipImpl relationshipImpl = relationship;
            return relationshipImpl;
        }
        finally {
            loadLock.unlock();
        }
    }

    public void removeNodeFromCache(int nodeId) {
        this.nodeCache.remove(nodeId);
    }

    public void removeRelationshipFromCache(int id) {
        this.relCache.remove(id);
    }

    Object loadPropertyValue(int id) {
        return this.persistenceManager.loadPropertyValue(id);
    }

    ArrayMap<String, IntArray> loadRelationships(NodeImpl node) {
        try {
            Iterable<RelationshipData> rels = this.persistenceManager.loadRelationships((int)node.getId());
            ArrayMap<String, IntArray> newRelationshipMap = new ArrayMap<String, IntArray>();
            for (RelationshipData rel : rels) {
                int relId = rel.getId();
                RelationshipImpl relImpl = this.relCache.get(relId);
                RelationshipType type = null;
                if (relImpl == null) {
                    type = this.getRelationshipTypeById(rel.relationshipType());
                    assert (type != null);
                    relImpl = new RelationshipImpl(relId, rel.firstNode(), rel.secondNode(), type, false, this);
                    this.relCache.put(relId, relImpl);
                } else {
                    type = relImpl.getType();
                }
                IntArray relationshipSet = newRelationshipMap.get(type.name());
                if (relationshipSet == null) {
                    relationshipSet = new IntArray();
                    newRelationshipMap.put(type.name(), relationshipSet);
                }
                relationshipSet.add(relId);
            }
            return newRelationshipMap;
        }
        catch (Exception e) {
            log.severe("Failed loading relationships for node[" + node.getId() + "]");
            throw new RuntimeException(e);
        }
    }

    ArrayMap<Integer, PropertyData> loadProperties(NodeImpl node) {
        try {
            return this.persistenceManager.loadNodeProperties((int)node.getId());
        }
        catch (Exception e) {
            log.severe("Failed loading properties for node[" + node.getId() + "]");
            throw new RuntimeException(e);
        }
    }

    ArrayMap<Integer, PropertyData> loadProperties(RelationshipImpl relationship) {
        try {
            return this.persistenceManager.loadRelProperties((int)relationship.getId());
        }
        catch (Exception e) {
            log.severe("Failed loading properties for relationship[" + relationship.getId() + "]");
            throw new RuntimeException(e);
        }
    }

    int getNodeMaxCacheSize() {
        return -1;
    }

    int getRelationshipMaxCacheSize() {
        return -1;
    }

    public void clearCache() {
        this.nodeCache.clear();
        this.relCache.clear();
    }

    void setRollbackOnly() {
        try {
            this.transactionManager.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            log.log(Level.FINE, "Failed to set transaction rollback only", e);
        }
        catch (SystemException se) {
            log.log(Level.SEVERE, "Failed to set transaction rollback only", se);
        }
    }

    void acquireLock(Object resource, LockType lockType) {
        block4: {
            try {
                if (lockType == LockType.READ) {
                    this.lockManager.getReadLock(resource);
                    break block4;
                }
                if (lockType == LockType.WRITE) {
                    this.lockManager.getWriteLock(resource);
                    break block4;
                }
                throw new RuntimeException("Unknown lock type: " + (Object)((Object)lockType));
            }
            catch (IllegalResourceException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void releaseLock(Object resource, LockType lockType) {
        if (lockType == LockType.READ) {
            this.lockManager.releaseReadLock(resource);
        } else if (lockType == LockType.WRITE) {
            this.lockReleaser.addLockToTransaction(resource, lockType);
        } else {
            throw new RuntimeException("Unknown lock type: " + (Object)((Object)lockType));
        }
    }

    public long getHighestPossibleIdInUse(Class<?> clazz) {
        return this.idGenerator.getHighestPossibleIdInUse(clazz);
    }

    public long getNumberOfIdsInUse(Class<?> clazz) {
        return this.idGenerator.getNumberOfIdsInUse(clazz);
    }

    public void removeRelationshipTypeFromCache(int id) {
        this.relTypeHolder.removeRelType(id);
    }

    Traverser createTraverser(Traverser.Order traversalOrder, NodeImpl node, RelationshipType relationshipType, Direction direction, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator) {
        return this.traverserFactory.createTraverser(traversalOrder, (Node)new NodeProxy((int)node.getId(), this), relationshipType, direction, stopEvaluator, returnableEvaluator);
    }

    Traverser createTraverser(Traverser.Order traversalOrder, NodeImpl node, RelationshipType[] types, Direction[] dirs, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator) {
        return this.traverserFactory.createTraverser(traversalOrder, (Node)new NodeProxy((int)node.getId(), this), types, dirs, stopEvaluator, returnableEvaluator);
    }

    void addPropertyIndexes(PropertyIndexData[] propertyIndexes) {
        this.propertyIndexManager.addPropertyIndexes(propertyIndexes);
    }

    void setHasAllpropertyIndexes(boolean hasAll) {
        this.propertyIndexManager.setHasAll(hasAll);
    }

    void clearPropertyIndexes() {
        this.propertyIndexManager.clear();
    }

    PropertyIndex getIndexFor(int keyId) {
        return this.propertyIndexManager.getIndexFor(keyId);
    }

    Iterable<PropertyIndex> index(String key) {
        return this.propertyIndexManager.index(key);
    }

    boolean hasAllPropertyIndexes() {
        return this.propertyIndexManager.hasAll();
    }

    boolean hasIndexFor(int keyId) {
        return this.propertyIndexManager.hasIndexFor(keyId);
    }

    PropertyIndex createPropertyIndex(String key) {
        return this.propertyIndexManager.createPropertyIndex(key);
    }

    int getRelationshipTypeIdFor(RelationshipType type) {
        return this.relTypeHolder.getIdFor(type);
    }

    void addRawRelationshipTypes(RelationshipTypeData[] relTypes) {
        this.relTypeHolder.addRawRelationshipTypes(relTypes);
    }

    Iterable<RelationshipType> getRelationshipTypes() {
        return this.relTypeHolder.getRelationshipTypes();
    }

    void deleteNode(NodeImpl node) {
        int nodeId = (int)node.getId();
        this.persistenceManager.nodeDelete(nodeId);
    }

    int nodeAddProperty(NodeImpl node, PropertyIndex index, Object value) {
        int nodeId = (int)node.getId();
        return this.persistenceManager.nodeAddProperty(nodeId, index, value);
    }

    void nodeChangeProperty(NodeImpl node, int propertyId, Object value) {
        int nodeId = (int)node.getId();
        this.persistenceManager.nodeChangeProperty(nodeId, propertyId, value);
    }

    void nodeRemoveProperty(NodeImpl node, int propertyId) {
        int nodeId = (int)node.getId();
        this.persistenceManager.nodeRemoveProperty(nodeId, propertyId);
    }

    public void deleteRelationship(RelationshipImpl rel) {
        int relId = (int)rel.getId();
        this.persistenceManager.relDelete(relId);
    }

    int relAddProperty(RelationshipImpl rel, PropertyIndex index, Object value) {
        int relId = (int)rel.getId();
        return this.persistenceManager.relAddProperty(relId, index, value);
    }

    void relChangeProperty(RelationshipImpl rel, int propertyId, Object value) {
        int relId = (int)rel.getId();
        this.persistenceManager.relChangeProperty(relId, propertyId, value);
    }

    void relRemoveProperty(RelationshipImpl rel, int propertyId) {
        int relId = (int)rel.getId();
        this.persistenceManager.relRemoveProperty(relId, propertyId);
    }

    public IntArray getCowRelationshipRemoveMap(NodeImpl node, String type) {
        return this.lockReleaser.getCowRelationshipRemoveMap(node, type);
    }

    public IntArray getCowRelationshipRemoveMap(NodeImpl node, String type, boolean create) {
        return this.lockReleaser.getCowRelationshipRemoveMap(node, type, create);
    }

    public ArrayMap<String, IntArray> getCowRelationshipAddMap(NodeImpl node) {
        return this.lockReleaser.getCowRelationshipAddMap(node);
    }

    public IntArray getCowRelationshipAddMap(NodeImpl node, String string) {
        return this.lockReleaser.getCowRelationshipAddMap(node, string);
    }

    public IntArray getCowRelationshipAddMap(NodeImpl node, String string, boolean create) {
        return this.lockReleaser.getCowRelationshipAddMap(node, string, create);
    }

    public NodeImpl getNodeIfCached(int nodeId) {
        return this.nodeCache.get(nodeId);
    }

    public RelationshipImpl getRelIfCached(int nodeId) {
        return this.relCache.get(nodeId);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyRemoveMap(NeoPrimitive primitive) {
        return this.lockReleaser.getCowPropertyRemoveMap(primitive);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyAddMap(NeoPrimitive primitive) {
        return this.lockReleaser.getCowPropertyAddMap(primitive);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyAddMap(NeoPrimitive primitive, boolean create) {
        return this.lockReleaser.getCowPropertyAddMap(primitive, create);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyRemoveMap(NeoPrimitive primitive, boolean create) {
        return this.lockReleaser.getCowPropertyRemoveMap(primitive, create);
    }

    LockReleaser getLockReleaser() {
        return this.lockReleaser;
    }
}

