/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.api.core.NotFoundException;
import org.neo4j.api.core.NotInTransactionException;
import org.neo4j.impl.core.PropertyIndex;
import org.neo4j.impl.nioneo.store.PropertyIndexData;
import org.neo4j.impl.persistence.IdGenerator;
import org.neo4j.impl.persistence.PersistenceManager;
import org.neo4j.impl.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyIndexManager {
    private ArrayMap<String, List<PropertyIndex>> indexMap = new ArrayMap(5, true, false);
    private ArrayMap<Integer, PropertyIndex> idToIndexMap = new ArrayMap(9, true, false);
    private ArrayMap<Transaction, TxCommitHook> txCommitHooks = new ArrayMap(5, true, false);
    private final TransactionManager transactionManager;
    private final PersistenceManager persistenceManager;
    private final IdGenerator idGenerator;
    private boolean hasAll = false;

    PropertyIndexManager(TransactionManager transactionManager, PersistenceManager persistenceManager, IdGenerator idGenerator) {
        this.transactionManager = transactionManager;
        this.persistenceManager = persistenceManager;
        this.idGenerator = idGenerator;
    }

    void clear() {
        this.indexMap = new ArrayMap(5, true, false);
        this.idToIndexMap = new ArrayMap(9, true, false);
        this.txCommitHooks.clear();
    }

    public Iterable<PropertyIndex> index(String key) {
        PropertyIndex index;
        List<PropertyIndex> list = this.indexMap.get(key);
        TxCommitHook hook = this.txCommitHooks.get(this.getTransaction());
        if (hook != null && (index = hook.getIndex(key)) != null) {
            ArrayList<PropertyIndex> added = new ArrayList<PropertyIndex>();
            if (list != null) {
                added.addAll(list);
            }
            added.add(index);
            return added;
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    void setHasAll(boolean status) {
        this.hasAll = status;
    }

    boolean hasAll() {
        return this.hasAll;
    }

    public boolean hasIndexFor(int keyId) {
        return this.idToIndexMap.get(keyId) != null;
    }

    void addPropertyIndexes(PropertyIndexData[] indexes) {
        for (PropertyIndexData rawIndex : indexes) {
            this.addPropertyIndex(new PropertyIndex(rawIndex.getValue(), rawIndex.getKeyId()));
        }
    }

    public PropertyIndex getIndexFor(int keyId) {
        PropertyIndex index = this.idToIndexMap.get(keyId);
        if (index == null) {
            TxCommitHook commitHook = this.txCommitHooks.get(this.getTransaction());
            if (commitHook != null && (index = commitHook.getIndex(keyId)) != null) {
                return index;
            }
            String indexString = this.persistenceManager.loadIndex(keyId);
            if (indexString == null) {
                throw new NotFoundException("Index not found [" + keyId + "]");
            }
            index = new PropertyIndex(indexString, keyId);
            this.addPropertyIndex(index);
        }
        return index;
    }

    private synchronized void addPropertyIndex(PropertyIndex index) {
        List<PropertyIndex> list = this.indexMap.get(index.getKey());
        if (list == null) {
            list = new CopyOnWriteArrayList<PropertyIndex>();
            this.indexMap.put(index.getKey(), list);
        }
        list.add(index);
        this.idToIndexMap.put(index.getKeyId(), index);
    }

    private Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new NotInTransactionException(e);
        }
        catch (Exception e) {
            throw new NotInTransactionException(e);
        }
    }

    PropertyIndex createPropertyIndex(String key) {
        PropertyIndex index;
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new NotInTransactionException("Unable to create property index for " + key);
        }
        TxCommitHook hook = this.txCommitHooks.get(tx);
        if (hook == null) {
            hook = new TxCommitHook(tx);
            this.txCommitHooks.put(tx, hook);
        }
        if ((index = hook.getIndex(key)) != null) {
            return index;
        }
        int id = this.idGenerator.nextId(PropertyIndex.class);
        index = new PropertyIndex(key, id);
        hook.addIndex(index);
        this.persistenceManager.createPropertyIndex(key, id);
        return index;
    }

    void setRollbackOnly() {
        try {
            this.transactionManager.setRollbackOnly();
        }
        catch (SystemException se) {
            se.printStackTrace();
        }
    }

    void commit(Transaction tx) {
        TxCommitHook hook;
        if (tx != null && (hook = this.txCommitHooks.remove(tx)) != null) {
            for (PropertyIndex index : hook.getAddedPropertyIndexes()) {
                this.addPropertyIndex(index);
            }
        }
    }

    void rollback(Transaction tx) {
        this.txCommitHooks.remove(tx);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TxCommitHook {
        private Map<String, PropertyIndex> createdIndexes = new HashMap<String, PropertyIndex>();
        private Map<Integer, PropertyIndex> idToIndex = new HashMap<Integer, PropertyIndex>();
        private final Transaction tx;

        TxCommitHook(Transaction tx) {
            this.tx = tx;
        }

        void addIndex(PropertyIndex index) {
            assert (!this.createdIndexes.containsKey(index.getKey()));
            this.createdIndexes.put(index.getKey(), index);
            this.idToIndex.put(index.getKeyId(), index);
        }

        PropertyIndex getIndex(String key) {
            return this.createdIndexes.get(key);
        }

        PropertyIndex getIndex(int keyId) {
            return this.idToIndex.get(keyId);
        }

        Iterable<PropertyIndex> getAddedPropertyIndexes() {
            return this.createdIndexes.values();
        }
    }
}

