/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.impl.core.NodeManager;
import org.neo4j.impl.util.ArrayIntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RelationshipArrayIntSetIterator
implements Iterable<Relationship>,
Iterator<Relationship> {
    private Logger log = Logger.getLogger(RelationshipArrayIntSetIterator.class.getName());
    private Iterator<Integer> relIds;
    private Node fromNode;
    private Direction direction = null;
    private Relationship nextElement = null;
    private final NodeManager nodeManager;

    RelationshipArrayIntSetIterator(ArrayIntSet relIds, Node fromNode, Direction direction, NodeManager nodeManager) {
        this.relIds = relIds.iterator();
        this.fromNode = fromNode;
        this.direction = direction;
        this.nodeManager = nodeManager;
    }

    RelationshipArrayIntSetIterator(Iterator<Integer> relIds, Node fromNode, Direction direction, NodeManager nodeManager) {
        this.relIds = relIds;
        this.fromNode = fromNode;
        this.direction = direction;
        this.nodeManager = nodeManager;
    }

    @Override
    public Iterator<Relationship> iterator() {
        return new RelationshipArrayIntSetIterator(this.relIds, this.fromNode, this.direction, this.nodeManager);
    }

    @Override
    public boolean hasNext() {
        if (this.nextElement != null) {
            return true;
        }
        do {
            if (!this.relIds.hasNext()) continue;
            int nextId = this.relIds.next();
            try {
                Relationship possibleElement = this.nodeManager.getRelationshipById(nextId);
                if (this.direction == Direction.INCOMING && possibleElement.getEndNode().equals(this.fromNode)) {
                    this.nextElement = possibleElement;
                    continue;
                }
                if (this.direction == Direction.OUTGOING && possibleElement.getStartNode().equals(this.fromNode)) {
                    this.nextElement = possibleElement;
                    continue;
                }
                if (this.direction != Direction.BOTH) continue;
                this.nextElement = possibleElement;
            }
            catch (Throwable t) {
                this.log.log(Level.FINE, "Unable to get relationship " + nextId, t);
            }
        } while (this.nextElement == null && this.relIds.hasNext());
        return this.nextElement != null;
    }

    @Override
    public Relationship next() {
        this.hasNext();
        if (this.nextElement != null) {
            Relationship elementToReturn = this.nextElement;
            this.nextElement = null;
            return elementToReturn;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

