/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.event;

import java.util.LinkedList;
import java.util.logging.Logger;
import org.neo4j.impl.event.EventElement;
import org.neo4j.impl.event.EventManager;

class EventQueue
extends Thread {
    private static Logger log = Logger.getLogger(EventQueue.class.getName());
    private final LinkedList<EventElement> queueList = new LinkedList();
    private int waitTime = 50;
    private int notifyOnCount = 100;
    private volatile boolean run = true;
    private volatile boolean destroyed = false;
    private int elementCount = 0;
    private final EventManager eventManager;

    EventQueue(EventManager eventManager) {
        super("EventQueueConsumer");
        this.eventManager = eventManager;
    }

    private void queue(EventElement eventElement) {
        this.queueList.add(eventElement);
        ++this.elementCount;
        if (this.elementCount > this.notifyOnCount) {
            this.elementCount = 0;
            this.notify();
        }
    }

    private int flushAll() {
        int numElements = 0;
        while (this.queueList.size() > 0) {
            this.sendEvent(this.queueList.removeFirst());
            ++numElements;
        }
        this.elementCount = 0;
        return numElements;
    }

    private void sendEvent(EventElement eventElement) {
        this.eventManager.sendReActiveEvent(eventElement.getEvent(), eventElement.getEventData());
    }

    public synchronized void run() {
        try {
            EventElement eventElement = this.eventManager.getNextEventElement();
            while (eventElement != null) {
                this.queue(eventElement);
                eventElement = this.eventManager.getNextEventElement();
            }
            while (this.run || this.queueList.size() > 0) {
                this.flushAll();
                try {
                    this.wait(this.waitTime);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                eventElement = this.eventManager.getNextEventElement();
                while (eventElement != null) {
                    this.queue(eventElement);
                    eventElement = this.eventManager.getNextEventElement();
                }
            }
            eventElement = this.eventManager.getNextEventElement();
            while (eventElement != null) {
                this.queueList.add(eventElement);
                eventElement = this.eventManager.getNextEventElement();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.severe("Event consumer queue caught thowable, queue destroyed");
        }
        this.destroyed = true;
    }

    void shutdown() {
        this.run = false;
    }

    void waitForDestroy() {
        while (!this.destroyed) {
            try {
                Thread.sleep(this.waitTime);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                System.out.println("Error " + e);
            }
        }
    }

    void setWaitTime(int time) {
        this.waitTime = time;
    }

    int getWaitTime() {
        return this.waitTime;
    }

    void setNotifyOnCount(int count) {
        this.notifyOnCount = count;
    }

    int getNotifyOnCount() {
        return this.notifyOnCount;
    }
}

