/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.nioneo.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.Map;
import org.neo4j.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.impl.nioneo.store.IdGenerator;
import org.neo4j.impl.nioneo.store.PersistenceWindowPool;
import org.neo4j.impl.nioneo.store.StoreFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStore
extends CommonAbstractStore {
    public abstract int getRecordSize();

    protected static void createEmptyStore(String fileName, String typeAndVersionDescriptor) {
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        File file = new File(fileName);
        if (file.exists()) {
            throw new IllegalStateException("Can't create store[" + fileName + "], file already exists");
        }
        try {
            FileChannel channel = new FileOutputStream(fileName).getChannel();
            int endHeaderSize = typeAndVersionDescriptor.getBytes().length;
            ByteBuffer buffer = ByteBuffer.allocate(endHeaderSize);
            buffer.put(typeAndVersionDescriptor.getBytes()).flip();
            channel.write(buffer);
            channel.force(false);
            channel.close();
        }
        catch (IOException e) {
            throw new StoreFailureException("Unable to create store " + fileName, e);
        }
        IdGenerator.createGenerator(fileName + ".id");
    }

    public AbstractStore(String fileName, Map<?, ?> config) {
        super(fileName, config);
    }

    public AbstractStore(String fileName) {
        super(fileName);
    }

    @Override
    protected void loadStorage() {
        try {
            long fileSize = this.getFileChannel().size();
            String expectedVersion = this.getTypeAndVersionDescriptor();
            byte[] version = new byte[expectedVersion.getBytes().length];
            ByteBuffer buffer = ByteBuffer.wrap(version);
            if (fileSize >= (long)version.length) {
                this.getFileChannel().position(fileSize - (long)version.length);
            } else {
                this.setStoreNotOk();
            }
            this.getFileChannel().read(buffer);
            if (!expectedVersion.equals(new String(version)) && !this.versionFound(new String(version))) {
                this.setStoreNotOk();
            }
            if (this.getRecordSize() != 0 && (fileSize - (long)version.length) % (long)this.getRecordSize() != 0L) {
                this.setStoreNotOk();
            }
            if (this.getStoreOk()) {
                this.getFileChannel().truncate(fileSize - (long)version.length);
            }
        }
        catch (IOException e) {
            throw new StoreFailureException("Unable to load store " + this.getStorageFileName(), e);
        }
        try {
            this.openIdGenerator();
        }
        catch (StoreFailureException e) {
            this.setStoreNotOk();
        }
        this.setWindowPool(new PersistenceWindowPool(this.getStorageFileName(), this.getRecordSize(), this.getFileChannel(), this.getMappedMem(), this.getIfMemoryMapped()));
    }

    @Override
    public long getHighId() {
        return super.getHighId();
    }

    public void setHighId(int id) {
        super.setHighId(id);
    }

    @Override
    protected void rebuildIdGenerator() {
        boolean RECORD_NOT_IN_USE = false;
        logger.fine("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
        this.closeIdGenerator();
        File file = new File(this.getStorageFileName() + ".id");
        if (file.exists()) {
            boolean success = file.delete();
            assert (success);
        }
        IdGenerator.createGenerator(this.getStorageFileName() + ".id");
        this.openIdGenerator();
        FileChannel fileChannel = this.getFileChannel();
        long highId = 1L;
        long defraggedCount = 0L;
        try {
            long fileSize = fileChannel.size();
            int recordSize = this.getRecordSize();
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[1]);
            LinkedList<Integer> freeIdList = new LinkedList<Integer>();
            long i = 0L;
            while (i * (long)recordSize < fileSize && recordSize > 0) {
                fileChannel.position(i * (long)recordSize);
                fileChannel.read(byteBuffer);
                byteBuffer.flip();
                byte inUse = byteBuffer.get();
                byteBuffer.flip();
                this.nextId();
                if (inUse == 0) {
                    freeIdList.add((int)i);
                } else {
                    highId = i;
                    while (!freeIdList.isEmpty()) {
                        this.freeId((Integer)freeIdList.removeFirst());
                        ++defraggedCount;
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new StoreFailureException("Unable to rebuild id generator " + this.getStorageFileName(), e);
        }
        this.setHighId(highId + 1L);
        logger.fine("[" + this.getStorageFileName() + "] high id=" + this.getHighId() + " (defragged=" + defraggedCount + ")");
        this.closeIdGenerator();
        this.openIdGenerator();
    }
}

