/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.nioneo.store;

import java.util.Map;
import org.neo4j.impl.nioneo.store.AbstractDynamicStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicStringStore
extends AbstractDynamicStore {
    private static final String VERSION = "StringPropertyStore v0.9.5";

    public DynamicStringStore(String fileName, Map<?, ?> config) {
        super(fileName, config);
    }

    public DynamicStringStore(String fileName) {
        super(fileName);
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    public static void createStore(String fileName, int blockSize) {
        DynamicStringStore.createEmptyStore(fileName, blockSize, VERSION);
    }

    @Override
    public void setHighId(long highId) {
        super.setHighId(highId);
    }

    @Override
    public int nextBlockId() {
        return super.nextBlockId();
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("StringPropertyStore")) {
            return false;
        }
        if (version.equals("StringPropertyStore v0.9.3")) {
            this.rebuildIdGenerator();
            this.closeIdGenerator();
            return true;
        }
        throw new RuntimeException("Unknown store version " + version + " Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }
}

