/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.nioneo.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.impl.nioneo.store.AbstractRecord;
import org.neo4j.impl.nioneo.store.DynamicRecord;
import org.neo4j.impl.nioneo.store.PropertyType;
import org.neo4j.impl.nioneo.store.Record;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyRecord
extends AbstractRecord {
    private PropertyType type;
    private int keyIndexId = Record.NO_NEXT_BLOCK.intValue();
    private long propBlock = Record.NO_NEXT_BLOCK.intValue();
    private int prevProp = Record.NO_PREVIOUS_PROPERTY.intValue();
    private int nextProp = Record.NO_NEXT_PROPERTY.intValue();
    private List<DynamicRecord> valueRecords = new ArrayList<DynamicRecord>();
    private boolean isLight = false;
    private int nodeRelId = -1;
    private boolean nodeIdSet = false;

    public PropertyRecord(int id) {
        super(id);
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    public void setNodeId(int nodeId) {
        this.nodeIdSet = true;
        this.nodeRelId = nodeId;
    }

    public void setRelId(int relId) {
        this.nodeIdSet = false;
        this.nodeRelId = relId;
    }

    public int getNodeId() {
        if (this.nodeIdSet) {
            return this.nodeRelId;
        }
        return -1;
    }

    public int getRelId() {
        if (!this.nodeIdSet) {
            return this.nodeRelId;
        }
        return -1;
    }

    void setIsLight(boolean status) {
        this.isLight = status;
    }

    public boolean isLight() {
        return this.isLight;
    }

    public Collection<DynamicRecord> getValueRecords() {
        assert (!this.isLight);
        return this.valueRecords;
    }

    public void addValueRecord(DynamicRecord record) {
        assert (!this.isLight);
        this.valueRecords.add(record);
    }

    public PropertyType getType() {
        return this.type;
    }

    public int getKeyIndexId() {
        return this.keyIndexId;
    }

    public void setKeyIndexId(int keyId) {
        this.keyIndexId = keyId;
    }

    public long getPropBlock() {
        return this.propBlock;
    }

    public void setPropBlock(long propBlock) {
        this.propBlock = propBlock;
    }

    public int getPrevProp() {
        return this.prevProp;
    }

    public void setPrevProp(int prevProp) {
        this.prevProp = prevProp;
    }

    public int getNextProp() {
        return this.nextProp;
    }

    public void setNextProp(int nextProp) {
        this.nextProp = nextProp;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("PropertyRecord[").append(this.getId()).append(",").append(this.inUse()).append(",").append((Object)this.type).append(",").append(this.keyIndexId).append(",").append(this.propBlock).append(",").append(this.prevProp).append(",").append(this.nextProp);
        buf.append(", Value[");
        for (DynamicRecord record : this.valueRecords) {
            buf.append(record);
        }
        buf.append("]]");
        return buf.toString();
    }
}

