/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.nioneo.store;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.neo4j.impl.nioneo.store.AbstractStore;
import org.neo4j.impl.nioneo.store.Buffer;
import org.neo4j.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.impl.nioneo.store.DynamicRecord;
import org.neo4j.impl.nioneo.store.DynamicStringStore;
import org.neo4j.impl.nioneo.store.OperationType;
import org.neo4j.impl.nioneo.store.PersistenceWindow;
import org.neo4j.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.impl.nioneo.store.PropertyRecord;
import org.neo4j.impl.nioneo.store.PropertyType;
import org.neo4j.impl.nioneo.store.Record;
import org.neo4j.impl.nioneo.store.Store;
import org.neo4j.impl.nioneo.store.StoreFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyStore
extends AbstractStore
implements Store {
    private static final String VERSION = "PropertyStore v0.9.5";
    private static final int RECORD_SIZE = 25;
    private static final int STRING_STORE_BLOCK_SIZE = 120;
    private DynamicStringStore stringPropertyStore;
    private PropertyIndexStore propertyIndexStore;
    private DynamicArrayStore arrayPropertyStore;

    public PropertyStore(String fileName, Map<?, ?> config) {
        super(fileName, config);
    }

    public PropertyStore(String fileName) {
        super(fileName);
    }

    @Override
    protected void initStorage() {
        this.stringPropertyStore = new DynamicStringStore(this.getStorageFileName() + ".strings", this.getConfig());
        this.propertyIndexStore = new PropertyIndexStore(this.getStorageFileName() + ".index", this.getConfig());
        File arrayStoreFile = new File(this.getStorageFileName() + ".arrays");
        if (!arrayStoreFile.exists()) {
            DynamicArrayStore.createStore(this.getStorageFileName() + ".arrays", 120);
        }
        this.arrayPropertyStore = new DynamicArrayStore(this.getStorageFileName() + ".arrays", this.getConfig());
    }

    @Override
    protected void setRecovered() {
        super.setRecovered();
        this.stringPropertyStore.setRecovered();
        this.propertyIndexStore.setRecovered();
        this.arrayPropertyStore.setRecovered();
    }

    @Override
    protected void unsetRecovered() {
        super.unsetRecovered();
        this.stringPropertyStore.unsetRecovered();
        this.propertyIndexStore.unsetRecovered();
        this.arrayPropertyStore.unsetRecovered();
    }

    @Override
    protected void closeStorage() {
        this.stringPropertyStore.close();
        this.stringPropertyStore = null;
        this.propertyIndexStore.close();
        this.propertyIndexStore = null;
        this.arrayPropertyStore.close();
        this.arrayPropertyStore = null;
    }

    @Override
    public void flushAll() {
        this.stringPropertyStore.flushAll();
        this.propertyIndexStore.flushAll();
        this.arrayPropertyStore.flushAll();
        super.flushAll();
    }

    @Override
    public String getTypeAndVersionDescriptor() {
        return VERSION;
    }

    @Override
    public int getRecordSize() {
        return 25;
    }

    public static void createStore(String fileName) {
        PropertyStore.createEmptyStore(fileName, VERSION);
        DynamicStringStore.createStore(fileName + ".strings", 120);
        PropertyIndexStore.createStore(fileName + ".index");
        DynamicArrayStore.createStore(fileName + ".arrays", 120);
    }

    private int nextStringBlockId() {
        return this.stringPropertyStore.nextBlockId();
    }

    public void freeStringBlockId(int blockId) {
        this.stringPropertyStore.freeBlockId(blockId);
    }

    private int nextArrayBlockId() {
        return this.arrayPropertyStore.nextBlockId();
    }

    public void freeArrayBlockId(int blockId) {
        this.arrayPropertyStore.freeBlockId(blockId);
    }

    public PropertyIndexStore getIndexStore() {
        return this.propertyIndexStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(PropertyRecord record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
        }
        finally {
            this.unsetRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(PropertyRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window);
        }
        finally {
            this.releaseWindow(window);
        }
        if (!record.isLight()) {
            for (DynamicRecord valueRecord : record.getValueRecords()) {
                if (valueRecord.getType() == PropertyType.STRING.intValue()) {
                    this.stringPropertyStore.updateRecord(valueRecord);
                    continue;
                }
                if (valueRecord.getType() == PropertyType.ARRAY.intValue()) {
                    this.arrayPropertyStore.updateRecord(valueRecord);
                    continue;
                }
                throw new RuntimeException("Unknown dynamic record");
            }
        }
    }

    private void updateRecord(PropertyRecord record, PersistenceWindow window) {
        int id = record.getId();
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse()) {
            buffer.put(Record.IN_USE.byteValue()).putInt(record.getType().intValue()).putInt(record.getKeyIndexId()).putLong(record.getPropBlock()).putInt(record.getPrevProp()).putInt(record.getNextProp());
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue());
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyRecord getLightRecord(int id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            PropertyRecord record = this.getRecord(id, window);
            record.setIsLight(true);
            PropertyRecord propertyRecord = record;
            return propertyRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    public void makeHeavy(PropertyRecord record) {
        block3: {
            block2: {
                record.setIsLight(false);
                if (record.getType() != PropertyType.STRING) break block2;
                Collection<DynamicRecord> stringRecords = this.stringPropertyStore.getLightRecords((int)record.getPropBlock());
                for (DynamicRecord stringRecord : stringRecords) {
                    stringRecord.setType(PropertyType.STRING.intValue());
                    record.addValueRecord(stringRecord);
                }
                break block3;
            }
            if (record.getType() != PropertyType.ARRAY) break block3;
            Collection<DynamicRecord> arrayRecords = this.arrayPropertyStore.getLightRecords((int)record.getPropBlock());
            for (DynamicRecord arrayRecord : arrayRecords) {
                arrayRecord.setType(PropertyType.ARRAY.intValue());
                record.addValueRecord(arrayRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyRecord getRecord(int id) {
        PropertyRecord record;
        block7: {
            block6: {
                PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
                try {
                    record = this.getRecord(id, window);
                }
                finally {
                    this.releaseWindow(window);
                }
                if (record.getType() != PropertyType.STRING) break block6;
                Collection<DynamicRecord> stringRecords = this.stringPropertyStore.getLightRecords((int)record.getPropBlock());
                record.setIsLight(false);
                for (DynamicRecord stringRecord : stringRecords) {
                    stringRecord.setType(PropertyType.STRING.intValue());
                    record.addValueRecord(stringRecord);
                }
                break block7;
            }
            if (record.getType() != PropertyType.ARRAY) break block7;
            Collection<DynamicRecord> arrayRecords = this.arrayPropertyStore.getLightRecords((int)record.getPropBlock());
            record.setIsLight(false);
            for (DynamicRecord arrayRecord : arrayRecords) {
                arrayRecord.setType(PropertyType.ARRAY.intValue());
                record.addValueRecord(arrayRecord);
            }
        }
        return record;
    }

    private PropertyRecord getRecord(int id, PersistenceWindow window) {
        Buffer buffer = window.getOffsettedBuffer(id);
        if (buffer.get() != Record.IN_USE.byteValue()) {
            throw new StoreFailureException("Record[" + id + "] not in use");
        }
        PropertyRecord record = new PropertyRecord(id);
        record.setType(this.getEnumType(buffer.getInt()));
        record.setInUse(true);
        record.setKeyIndexId(buffer.getInt());
        record.setPropBlock(buffer.getLong());
        record.setPrevProp(buffer.getInt());
        record.setNextProp(buffer.getInt());
        return record;
    }

    private PropertyType getEnumType(int type) {
        switch (type) {
            case 1: {
                return PropertyType.INT;
            }
            case 2: {
                return PropertyType.STRING;
            }
            case 3: {
                return PropertyType.BOOL;
            }
            case 4: {
                return PropertyType.DOUBLE;
            }
            case 5: {
                return PropertyType.FLOAT;
            }
            case 6: {
                return PropertyType.LONG;
            }
            case 7: {
                return PropertyType.BYTE;
            }
            case 8: {
                return PropertyType.CHAR;
            }
            case 9: {
                return PropertyType.ARRAY;
            }
            case 10: {
                return PropertyType.SHORT;
            }
        }
        throw new StoreFailureException("Unknown enum type:" + type);
    }

    public Object getValue(PropertyRecord propertyRecord) {
        PropertyType type = propertyRecord.getType();
        if (type == PropertyType.INT) {
            return (int)propertyRecord.getPropBlock();
        }
        if (type == PropertyType.STRING) {
            return this.getStringFor(propertyRecord);
        }
        if (type == PropertyType.BOOL) {
            if (propertyRecord.getPropBlock() == 1L) {
                return true;
            }
            return false;
        }
        if (type == PropertyType.DOUBLE) {
            return new Double(Double.longBitsToDouble(propertyRecord.getPropBlock()));
        }
        if (type == PropertyType.FLOAT) {
            return new Float(Float.intBitsToFloat((int)propertyRecord.getPropBlock()));
        }
        if (type == PropertyType.LONG) {
            return propertyRecord.getPropBlock();
        }
        if (type == PropertyType.BYTE) {
            return (byte)propertyRecord.getPropBlock();
        }
        if (type == PropertyType.CHAR) {
            return Character.valueOf((char)propertyRecord.getPropBlock());
        }
        if (type == PropertyType.ARRAY) {
            return this.getArrayFor(propertyRecord);
        }
        if (type == PropertyType.SHORT) {
            return (short)propertyRecord.getPropBlock();
        }
        throw new RuntimeException("Unknown type: " + (Object)((Object)type));
    }

    @Override
    public void makeStoreOk() {
        this.propertyIndexStore.makeStoreOk();
        this.stringPropertyStore.makeStoreOk();
        this.arrayPropertyStore.makeStoreOk();
        super.makeStoreOk();
    }

    @Override
    public void rebuildIdGenerators() {
        this.propertyIndexStore.rebuildIdGenerators();
        this.stringPropertyStore.rebuildIdGenerators();
        this.arrayPropertyStore.rebuildIdGenerators();
        super.rebuildIdGenerators();
    }

    private Collection<DynamicRecord> allocateStringRecords(int valueBlockId, char[] chars) {
        return this.stringPropertyStore.allocateRecords(valueBlockId, chars);
    }

    private Collection<DynamicRecord> allocateArrayRecords(int valueBlockId, Object array) {
        return this.arrayPropertyStore.allocateRecords(valueBlockId, array);
    }

    public void encodeValue(PropertyRecord record, Object value) {
        if (value instanceof String) {
            int stringBlockId = this.nextStringBlockId();
            record.setPropBlock(stringBlockId);
            String string = (String)value;
            int length = string.length();
            char[] chars = new char[length];
            string.getChars(0, length, chars, 0);
            Collection<DynamicRecord> valueRecords = this.allocateStringRecords(stringBlockId, chars);
            for (DynamicRecord valueRecord : valueRecords) {
                valueRecord.setType(PropertyType.STRING.intValue());
                record.addValueRecord(valueRecord);
            }
            record.setType(PropertyType.STRING);
        } else if (value instanceof Integer) {
            record.setPropBlock(((Integer)value).intValue());
            record.setType(PropertyType.INT);
        } else if (value instanceof Boolean) {
            record.setPropBlock((Boolean)value != false ? 1 : 0);
            record.setType(PropertyType.BOOL);
        } else if (value instanceof Float) {
            record.setPropBlock(Float.floatToRawIntBits(((Float)value).floatValue()));
            record.setType(PropertyType.FLOAT);
        } else if (value instanceof Long) {
            record.setPropBlock((Long)value);
            record.setType(PropertyType.LONG);
        } else if (value instanceof Double) {
            record.setPropBlock(Double.doubleToRawLongBits((Double)value));
            record.setType(PropertyType.DOUBLE);
        } else if (value instanceof Byte) {
            record.setPropBlock(((Byte)value).byteValue());
            record.setType(PropertyType.BYTE);
        } else if (value instanceof Character) {
            record.setPropBlock(((Character)value).charValue());
            record.setType(PropertyType.CHAR);
        } else if (value.getClass().isArray()) {
            int arrayBlockId = this.nextArrayBlockId();
            record.setPropBlock(arrayBlockId);
            Collection<DynamicRecord> arrayRecords = this.allocateArrayRecords(arrayBlockId, value);
            for (DynamicRecord valueRecord : arrayRecords) {
                valueRecord.setType(PropertyType.ARRAY.intValue());
                record.addValueRecord(valueRecord);
            }
            record.setType(PropertyType.ARRAY);
        } else if (value instanceof Short) {
            record.setPropBlock(((Short)value).shortValue());
            record.setType(PropertyType.SHORT);
        } else {
            throw new IllegalArgumentException("Unknown property type on: " + value);
        }
    }

    public Object getStringFor(PropertyRecord propRecord) {
        int recordToFind = (int)propRecord.getPropBlock();
        Iterator<DynamicRecord> records = propRecord.getValueRecords().iterator();
        LinkedList<char[]> charList = new LinkedList<char[]>();
        int totalSize = 0;
        while (recordToFind != Record.NO_NEXT_BLOCK.intValue() && records.hasNext()) {
            DynamicRecord record = records.next();
            if (record.getId() != recordToFind) continue;
            if (record.isLight()) {
                this.stringPropertyStore.makeHeavy(record);
            }
            if (!record.isCharData()) {
                ByteBuffer buf = ByteBuffer.wrap(record.getData());
                char[] chars = new char[record.getData().length / 2];
                totalSize += chars.length;
                buf.asCharBuffer().get(chars);
                charList.add(chars);
            } else {
                charList.add(record.getDataAsChar());
            }
            recordToFind = record.getNextBlock();
            records = propRecord.getValueRecords().iterator();
        }
        StringBuffer buf = new StringBuffer();
        for (char[] str : charList) {
            buf.append(str);
        }
        return buf.toString();
    }

    public Object getArrayFor(PropertyRecord propertyRecord) {
        int recordToFind = (int)propertyRecord.getPropBlock();
        Iterator<DynamicRecord> records = propertyRecord.getValueRecords().iterator();
        LinkedList<byte[]> byteList = new LinkedList<byte[]>();
        int totalSize = 0;
        while (recordToFind != Record.NO_NEXT_BLOCK.intValue() && records.hasNext()) {
            byte[] bytes;
            ByteBuffer buf;
            DynamicRecord record = records.next();
            if (record.getId() != recordToFind) continue;
            if (record.isLight()) {
                this.arrayPropertyStore.makeHeavy(record);
            }
            if (!record.isCharData()) {
                buf = ByteBuffer.wrap(record.getData());
                bytes = new byte[record.getData().length];
                totalSize += bytes.length;
            } else {
                throw new RuntimeException("Assert");
            }
            buf.get(bytes);
            byteList.add(bytes);
            recordToFind = record.getNextBlock();
            records = propertyRecord.getValueRecords().iterator();
        }
        byte[] bArray = new byte[totalSize];
        int offset = 0;
        for (byte[] currentArray : byteList) {
            System.arraycopy(currentArray, 0, bArray, offset, currentArray.length);
            offset += currentArray.length;
        }
        return this.arrayPropertyStore.getRightArray(bArray);
    }

    @Override
    protected boolean versionFound(String version) {
        if (!version.startsWith("PropertyStore")) {
            return false;
        }
        if (version.equals("PropertyStore v0.9.3")) {
            this.rebuildIdGenerator();
            this.closeIdGenerator();
            return true;
        }
        throw new RuntimeException("Unknown store version " + version + " Please make sure you are not running old Neo4j kernel " + " towards a store that has been created by newer version " + " of Neo4j.");
    }
}

