/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.nioneo.xa;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.logging.Logger;
import org.neo4j.impl.nioneo.store.DynamicRecord;
import org.neo4j.impl.nioneo.store.NeoStore;
import org.neo4j.impl.nioneo.store.NodeRecord;
import org.neo4j.impl.nioneo.store.NodeStore;
import org.neo4j.impl.nioneo.store.PropertyIndexRecord;
import org.neo4j.impl.nioneo.store.PropertyIndexStore;
import org.neo4j.impl.nioneo.store.PropertyRecord;
import org.neo4j.impl.nioneo.store.PropertyStore;
import org.neo4j.impl.nioneo.store.PropertyType;
import org.neo4j.impl.nioneo.store.Record;
import org.neo4j.impl.nioneo.store.RelationshipRecord;
import org.neo4j.impl.nioneo.store.RelationshipStore;
import org.neo4j.impl.nioneo.store.RelationshipTypeRecord;
import org.neo4j.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.impl.transaction.xaframework.LogBuffer;
import org.neo4j.impl.transaction.xaframework.XaCommand;

abstract class Command
extends XaCommand {
    static Logger logger = Logger.getLogger(Command.class.getName());
    private final int key;
    private static final byte NODE_COMMAND = 1;
    private static final byte PROP_COMMAND = 2;
    private static final byte REL_COMMAND = 3;
    private static final byte REL_TYPE_COMMAND = 4;
    private static final byte PROP_INDEX_COMMAND = 5;

    Command(int key) {
        this.key = key;
    }

    protected void setRecovered() {
        super.setRecovered();
    }

    int getKey() {
        return this.key;
    }

    public int hashCode() {
        return this.key;
    }

    static void writeDynamicRecord(LogBuffer buffer, DynamicRecord record) throws IOException {
        if (record.inUse()) {
            byte inUse = Record.IN_USE.byteValue();
            buffer.putInt(record.getId()).putInt(record.getType()).put(inUse).putInt(record.getPrevBlock()).putInt(record.getLength()).putInt(record.getNextBlock());
            if (!record.isLight()) {
                if (!record.isCharData()) {
                    byte[] data = record.getData();
                    buffer.put(data);
                } else {
                    char[] chars = record.getDataAsChar();
                    buffer.put(chars);
                }
            }
        } else {
            byte inUse = Record.NOT_IN_USE.byteValue();
            buffer.putInt(record.getId()).putInt(record.getType()).put(inUse);
        }
    }

    static DynamicRecord readDynamicRecord(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        buffer.clear();
        buffer.limit(9);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        int id = buffer.getInt();
        int type = buffer.getInt();
        byte inUseFlag = buffer.get();
        boolean inUse = false;
        if (inUseFlag == Record.IN_USE.byteValue()) {
            inUse = true;
            buffer.clear();
            buffer.limit(12);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse, type);
        if (inUse) {
            record.setPrevBlock(buffer.getInt());
            int nrOfBytes = buffer.getInt();
            record.setNextBlock(buffer.getInt());
            buffer.clear();
            buffer.limit(nrOfBytes);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            byte[] data = new byte[nrOfBytes];
            buffer.get(data);
            record.setData(data);
        }
        return record;
    }

    static Command readCommand(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        buffer.clear();
        buffer.limit(1);
        if (byteChannel.read(buffer) != buffer.limit()) {
            return null;
        }
        buffer.flip();
        byte commandType = buffer.get();
        switch (commandType) {
            case 1: {
                return NodeCommand.readCommand(neoStore, byteChannel, buffer);
            }
            case 2: {
                return PropertyCommand.readCommand(neoStore, byteChannel, buffer);
            }
            case 5: {
                return PropertyIndexCommand.readCommand(neoStore, byteChannel, buffer);
            }
            case 3: {
                return RelationshipCommand.readCommand(neoStore, byteChannel, buffer);
            }
            case 4: {
                return RelationshipTypeCommand.readCommand(neoStore, byteChannel, buffer);
            }
        }
        throw new IOException("Unknown command type[" + commandType + "]");
    }

    static class RelationshipTypeCommand
    extends Command {
        private final RelationshipTypeRecord record;
        private final RelationshipTypeStore store;

        RelationshipTypeCommand(RelationshipTypeStore store, RelationshipTypeRecord record) {
            super(record.getId());
            this.record = record;
            this.store = store;
        }

        public void execute() {
            if (this.isRecovered()) {
                logger.fine(this.toString());
                this.store.updateRecord(this.record, true);
            } else {
                this.store.updateRecord(this.record);
            }
        }

        public String toString() {
            return "RelationshipTypeCommand[" + this.record + "]";
        }

        public void writeToFile(LogBuffer buffer) throws IOException {
            byte inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put((byte)4);
            buffer.putInt(this.record.getId()).put(inUse).putInt(this.record.getTypeBlock());
            Collection<DynamicRecord> typeRecords = this.record.getTypeRecords();
            buffer.putInt(typeRecords.size());
            for (DynamicRecord typeRecord : typeRecords) {
                RelationshipTypeCommand.writeDynamicRecord(buffer, typeRecord);
            }
        }

        static Command readCommand(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            buffer.clear();
            buffer.limit(13);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            int id = buffer.getInt();
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            RelationshipTypeRecord record = new RelationshipTypeRecord(id);
            record.setInUse(inUse);
            record.setTypeBlock(buffer.getInt());
            int nrTypeRecords = buffer.getInt();
            for (int i = 0; i < nrTypeRecords; ++i) {
                DynamicRecord dr = RelationshipTypeCommand.readDynamicRecord(byteChannel, buffer);
                if (dr == null) {
                    return null;
                }
                record.addTypeRecord(dr);
            }
            return new RelationshipTypeCommand(neoStore.getRelationshipTypeStore(), record);
        }

        public boolean equals(Object o) {
            if (!(o instanceof RelationshipTypeCommand)) {
                return false;
            }
            return this.getKey() == ((Command)o).getKey();
        }
    }

    static class PropertyCommand
    extends Command {
        private final PropertyRecord record;
        private final PropertyStore store;

        PropertyCommand(PropertyStore store, PropertyRecord record) {
            super(record.getId());
            this.record = record;
            this.store = store;
        }

        public void execute() {
            if (this.isRecovered()) {
                logger.fine(this.toString());
                this.store.updateRecord(this.record, true);
            } else {
                this.store.updateRecord(this.record);
            }
        }

        public String toString() {
            return "PropertyCommand[" + this.record + "]";
        }

        public void writeToFile(LogBuffer buffer) throws IOException {
            byte inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put((byte)2);
            buffer.putInt(this.record.getId());
            buffer.put(inUse);
            if (this.record.inUse()) {
                buffer.putInt(this.record.getType().intValue()).putInt(this.record.getKeyIndexId()).putLong(this.record.getPropBlock()).putInt(this.record.getPrevProp()).putInt(this.record.getNextProp());
            }
            if (this.record.isLight()) {
                buffer.putInt(0);
            } else {
                Collection<DynamicRecord> valueRecords = this.record.getValueRecords();
                buffer.putInt(valueRecords.size());
                for (DynamicRecord valueRecord : valueRecords) {
                    PropertyCommand.writeDynamicRecord(buffer, valueRecord);
                }
            }
        }

        static Command readCommand(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            buffer.clear();
            buffer.limit(5);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            int id = buffer.getInt();
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            PropertyRecord record = new PropertyRecord(id);
            if (inUse) {
                buffer.clear();
                buffer.limit(24);
                if (byteChannel.read(buffer) != buffer.limit()) {
                    return null;
                }
                buffer.flip();
                PropertyType type = PropertyCommand.getType(buffer.getInt());
                record.setType(type);
                record.setInUse(inUse);
                record.setKeyIndexId(buffer.getInt());
                record.setPropBlock(buffer.getLong());
                record.setPrevProp(buffer.getInt());
                record.setNextProp(buffer.getInt());
            }
            buffer.clear();
            buffer.limit(4);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            int nrValueRecords = buffer.getInt();
            for (int i = 0; i < nrValueRecords; ++i) {
                DynamicRecord dr = PropertyCommand.readDynamicRecord(byteChannel, buffer);
                if (dr == null) {
                    return null;
                }
                record.addValueRecord(dr);
            }
            return new PropertyCommand(neoStore.getPropertyStore(), record);
        }

        private static PropertyType getType(int type) {
            switch (type) {
                case 1: {
                    return PropertyType.INT;
                }
                case 2: {
                    return PropertyType.STRING;
                }
                case 3: {
                    return PropertyType.BOOL;
                }
                case 4: {
                    return PropertyType.DOUBLE;
                }
                case 5: {
                    return PropertyType.FLOAT;
                }
                case 6: {
                    return PropertyType.LONG;
                }
                case 7: {
                    return PropertyType.BYTE;
                }
                case 8: {
                    return PropertyType.CHAR;
                }
                case 9: {
                    return PropertyType.ARRAY;
                }
                case 10: {
                    return PropertyType.SHORT;
                }
            }
            throw new RuntimeException("Unknown property type:" + type);
        }

        public boolean equals(Object o) {
            if (!(o instanceof PropertyCommand)) {
                return false;
            }
            return this.getKey() == ((Command)o).getKey();
        }
    }

    static class PropertyIndexCommand
    extends Command {
        private final PropertyIndexRecord record;
        private final PropertyIndexStore store;

        PropertyIndexCommand(PropertyIndexStore store, PropertyIndexRecord record) {
            super(record.getId());
            this.record = record;
            this.store = store;
        }

        public void execute() {
            if (this.isRecovered()) {
                logger.fine(this.toString());
                this.store.updateRecord(this.record, true);
            } else {
                this.store.updateRecord(this.record);
            }
        }

        public String toString() {
            return "PropertyIndexCommand[" + this.record + "]";
        }

        public void writeToFile(LogBuffer buffer) throws IOException {
            byte inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put((byte)5);
            buffer.putInt(this.record.getId());
            buffer.put(inUse);
            buffer.putInt(this.record.getPropertyCount()).putInt(this.record.getKeyBlockId());
            if (this.record.isLight()) {
                buffer.putInt(0);
            } else {
                Collection<DynamicRecord> keyRecords = this.record.getKeyRecords();
                buffer.putInt(keyRecords.size());
                for (DynamicRecord keyRecord : keyRecords) {
                    PropertyIndexCommand.writeDynamicRecord(buffer, keyRecord);
                }
            }
        }

        static Command readCommand(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            buffer.clear();
            buffer.limit(17);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            int id = buffer.getInt();
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            PropertyIndexRecord record = new PropertyIndexRecord(id);
            record.setInUse(inUse);
            record.setPropertyCount(buffer.getInt());
            record.setKeyBlockId(buffer.getInt());
            int nrKeyRecords = buffer.getInt();
            for (int i = 0; i < nrKeyRecords; ++i) {
                DynamicRecord dr = PropertyIndexCommand.readDynamicRecord(byteChannel, buffer);
                if (dr == null) {
                    return null;
                }
                record.addKeyRecord(dr);
            }
            return new PropertyIndexCommand(neoStore.getPropertyStore().getIndexStore(), record);
        }

        public boolean equals(Object o) {
            if (!(o instanceof PropertyIndexCommand)) {
                return false;
            }
            return this.getKey() == ((Command)o).getKey();
        }
    }

    static class RelationshipCommand
    extends Command {
        private final RelationshipRecord record;
        private final RelationshipStore store;

        RelationshipCommand(RelationshipStore store, RelationshipRecord record) {
            super(record.getId());
            this.record = record;
            this.store = store;
        }

        public void execute() {
            if (this.isRecovered()) {
                logger.fine(this.toString());
                this.store.updateRecord(this.record, true);
            } else {
                this.store.updateRecord(this.record);
            }
        }

        public String toString() {
            return "RelationshipCommand[" + this.record + "]";
        }

        public void writeToFile(LogBuffer buffer) throws IOException {
            byte inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put((byte)3);
            buffer.putInt(this.record.getId());
            buffer.put(inUse);
            if (this.record.inUse()) {
                buffer.putInt(this.record.getFirstNode()).putInt(this.record.getSecondNode()).putInt(this.record.getType()).putInt(this.record.getFirstPrevRel()).putInt(this.record.getFirstNextRel()).putInt(this.record.getSecondPrevRel()).putInt(this.record.getSecondNextRel()).putInt(this.record.getNextProp());
            }
        }

        static Command readCommand(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            RelationshipRecord record;
            buffer.clear();
            buffer.limit(5);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            int id = buffer.getInt();
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if ((inUseFlag & Record.IN_USE.byteValue()) != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            if (inUse) {
                buffer.clear();
                buffer.limit(32);
                if (byteChannel.read(buffer) != buffer.limit()) {
                    return null;
                }
                buffer.flip();
                record = new RelationshipRecord(id, buffer.getInt(), buffer.getInt(), buffer.getInt());
                record.setInUse(inUse);
                record.setFirstPrevRel(buffer.getInt());
                record.setFirstNextRel(buffer.getInt());
                record.setSecondPrevRel(buffer.getInt());
                record.setSecondNextRel(buffer.getInt());
                record.setNextProp(buffer.getInt());
            } else {
                record = new RelationshipRecord(id, -1, -1, -1);
                record.setInUse(false);
            }
            return new RelationshipCommand(neoStore.getRelationshipStore(), record);
        }

        public boolean equals(Object o) {
            if (!(o instanceof RelationshipCommand)) {
                return false;
            }
            return this.getKey() == ((Command)o).getKey();
        }
    }

    static class NodeCommand
    extends Command {
        private final NodeRecord record;
        private final NodeStore store;

        NodeCommand(NodeStore store, NodeRecord record) {
            super(record.getId());
            this.record = record;
            this.store = store;
        }

        public void execute() {
            if (this.isRecovered()) {
                logger.fine(this.toString());
                this.store.updateRecord(this.record, true);
            } else {
                this.store.updateRecord(this.record);
            }
        }

        public String toString() {
            return "NodeCommand[" + this.record + "]";
        }

        public void writeToFile(LogBuffer buffer) throws IOException {
            byte inUse = this.record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            buffer.put((byte)1);
            buffer.putInt(this.record.getId());
            buffer.put(inUse);
            if (this.record.inUse()) {
                buffer.putInt(this.record.getNextRel()).putInt(this.record.getNextProp());
            }
        }

        static Command readCommand(NeoStore neoStore, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            buffer.clear();
            buffer.limit(5);
            if (byteChannel.read(buffer) != buffer.limit()) {
                return null;
            }
            buffer.flip();
            int id = buffer.getInt();
            byte inUseFlag = buffer.get();
            boolean inUse = false;
            if (inUseFlag == Record.IN_USE.byteValue()) {
                inUse = true;
            } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
                throw new IOException("Illegal in use flag: " + inUseFlag);
            }
            NodeRecord record = new NodeRecord(id);
            record.setInUse(inUse);
            if (inUse) {
                buffer.clear();
                buffer.limit(8);
                if (byteChannel.read(buffer) != buffer.limit()) {
                    return null;
                }
                buffer.flip();
                record.setNextRel(buffer.getInt());
                record.setNextProp(buffer.getInt());
            }
            return new NodeCommand(neoStore.getNodeStore(), record);
        }

        public boolean equals(Object o) {
            if (!(o instanceof NodeCommand)) {
                return false;
            }
            return this.getKey() == ((Command)o).getKey();
        }
    }
}

