/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.nioneo.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.neo4j.impl.core.PropertyIndex;
import org.neo4j.impl.nioneo.store.NeoStore;
import org.neo4j.impl.nioneo.store.NodeStore;
import org.neo4j.impl.nioneo.store.PropertyData;
import org.neo4j.impl.nioneo.store.PropertyIndexData;
import org.neo4j.impl.nioneo.store.PropertyStore;
import org.neo4j.impl.nioneo.store.RelationshipData;
import org.neo4j.impl.nioneo.store.RelationshipStore;
import org.neo4j.impl.nioneo.store.RelationshipTypeData;
import org.neo4j.impl.nioneo.store.RelationshipTypeStore;
import org.neo4j.impl.nioneo.store.StoreFailureException;
import org.neo4j.impl.nioneo.xa.NeoTransaction;
import org.neo4j.impl.nioneo.xa.NodeEventConsumer;
import org.neo4j.impl.nioneo.xa.PropertyIndexEventConsumer;
import org.neo4j.impl.nioneo.xa.RelationshipEventConsumer;
import org.neo4j.impl.nioneo.xa.RelationshipTypeEventConsumer;
import org.neo4j.impl.transaction.xaframework.XaConnectionHelpImpl;
import org.neo4j.impl.transaction.xaframework.XaResourceHelpImpl;
import org.neo4j.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.impl.util.ArrayMap;

public class NeoStoreXaConnection
extends XaConnectionHelpImpl {
    private final NeoStoreXaResource xaResource;
    private final NeoStore neoStore;
    private final NodeEventConsumer nodeConsumer;
    private final RelationshipEventConsumer relConsumer;
    private final RelationshipTypeEventConsumer relTypeConsumer;
    private final PropertyIndexEventConsumer propIndexConsumer;
    private NeoTransaction neoTransaction = null;

    NeoStoreXaConnection(NeoStore neoStore, XaResourceManager xaRm, byte[] branchId) {
        super(xaRm);
        this.neoStore = neoStore;
        this.nodeConsumer = new NodeEventConsumerImpl(this);
        this.relConsumer = new RelationshipEventConsumerImpl(this);
        this.relTypeConsumer = new RelationshipTypeEventConsumerImpl(this);
        this.propIndexConsumer = new PropertyIndexEventConsumerImpl(this);
        this.xaResource = new NeoStoreXaResource(neoStore.getStorageFileName(), xaRm, branchId);
    }

    public NodeEventConsumer getNodeConsumer() {
        return this.nodeConsumer;
    }

    public RelationshipEventConsumer getRelationshipConsumer() {
        return this.relConsumer;
    }

    public PropertyIndexEventConsumer getPropertyIndexConsumer() {
        return this.propIndexConsumer;
    }

    public RelationshipTypeEventConsumer getRelationshipTypeConsumer() {
        return this.relTypeConsumer;
    }

    public PropertyStore getPropertyStore() {
        return this.neoStore.getPropertyStore();
    }

    NodeStore getNodeStore() {
        return this.neoStore.getNodeStore();
    }

    RelationshipStore getRelationshipStore() {
        return this.neoStore.getRelationshipStore();
    }

    RelationshipTypeStore getRelationshipTypeStore() {
        return this.neoStore.getRelationshipTypeStore();
    }

    public XAResource getXaResource() {
        return this.xaResource;
    }

    NeoTransaction getNeoTransaction() {
        if (this.neoTransaction != null) {
            return this.neoTransaction;
        }
        try {
            this.neoTransaction = (NeoTransaction)this.getTransaction();
            return this.neoTransaction;
        }
        catch (XAException e) {
            throw new StoreFailureException("Unable to get transaction.", e);
        }
    }

    private static class PropertyIndexEventConsumerImpl
    implements PropertyIndexEventConsumer {
        private final NeoStoreXaConnection xaCon;

        PropertyIndexEventConsumerImpl(NeoStoreXaConnection xaCon) {
            this.xaCon = xaCon;
        }

        public void createPropertyIndex(int id, String key) {
            this.xaCon.getNeoTransaction().createPropertyIndex(id, key);
        }

        public String getKeyFor(int id) {
            return this.xaCon.getNeoTransaction().getPropertyIndex(id);
        }

        public PropertyIndexData[] getPropertyIndexes(int count) {
            return this.xaCon.getNeoTransaction().getPropertyIndexes(count);
        }
    }

    private class RelationshipTypeEventConsumerImpl
    implements RelationshipTypeEventConsumer {
        private final NeoStoreXaConnection xaCon;
        private final RelationshipTypeStore relTypeStore;

        RelationshipTypeEventConsumerImpl(NeoStoreXaConnection xaCon) {
            this.xaCon = xaCon;
            this.relTypeStore = NeoStoreXaConnection.this.getRelationshipTypeStore();
        }

        public void addRelationshipType(int id, String name) {
            this.xaCon.getNeoTransaction().relationshipTypeAdd(id, name);
        }

        public RelationshipTypeData getRelationshipType(int id) {
            return this.relTypeStore.getRelationshipType(id);
        }

        public RelationshipTypeData[] getRelationshipTypes() {
            return this.relTypeStore.getRelationshipTypes();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RelationshipEventConsumerImpl
    implements RelationshipEventConsumer {
        private final NeoStoreXaConnection xaCon;
        private final RelationshipStore relStore;

        public RelationshipEventConsumerImpl(NeoStoreXaConnection xaCon) {
            this.xaCon = xaCon;
            this.relStore = NeoStoreXaConnection.this.getRelationshipStore();
        }

        @Override
        public void createRelationship(int id, int firstNode, int secondNode, int type) {
            this.xaCon.getNeoTransaction().relationshipCreate(id, firstNode, secondNode, type);
        }

        @Override
        public void deleteRelationship(int id) {
            this.xaCon.getNeoTransaction().relDelete(id);
        }

        @Override
        public void addProperty(int relId, int propertyId, PropertyIndex index, Object value) {
            this.xaCon.getNeoTransaction().relAddProperty(relId, propertyId, index, value);
        }

        @Override
        public void changeProperty(int relId, int propertyId, Object value) {
            this.xaCon.getNeoTransaction().relChangeProperty(relId, propertyId, value);
        }

        @Override
        public void removeProperty(int relId, int propertyId) {
            this.xaCon.getNeoTransaction().relRemoveProperty(relId, propertyId);
        }

        @Override
        public ArrayMap<Integer, PropertyData> getProperties(int relId) {
            return this.xaCon.getNeoTransaction().relGetProperties(relId);
        }

        @Override
        public RelationshipData getRelationship(int id) {
            return this.xaCon.getNeoTransaction().relationshipLoad(id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeEventConsumerImpl
    implements NodeEventConsumer {
        private final NeoStoreXaConnection xaCon;
        private final NodeStore nodeStore;

        public NodeEventConsumerImpl(NeoStoreXaConnection xaCon) {
            this.xaCon = xaCon;
            this.nodeStore = NeoStoreXaConnection.this.getNodeStore();
        }

        @Override
        public void createNode(int nodeId) {
            this.xaCon.getNeoTransaction().nodeCreate(nodeId);
        }

        @Override
        public void deleteNode(int nodeId) {
            this.xaCon.getNeoTransaction().nodeDelete(nodeId);
        }

        @Override
        public boolean loadLightNode(int nodeId) {
            return this.xaCon.getNeoTransaction().nodeLoadLight(nodeId);
        }

        @Override
        public void addProperty(int nodeId, int propertyId, PropertyIndex index, Object value) {
            this.xaCon.getNeoTransaction().nodeAddProperty(nodeId, propertyId, index, value);
        }

        @Override
        public void changeProperty(int nodeId, int propertyId, Object value) {
            this.xaCon.getNeoTransaction().nodeChangeProperty(nodeId, propertyId, value);
        }

        @Override
        public void removeProperty(int nodeId, int propertyId) {
            this.xaCon.getNeoTransaction().nodeRemoveProperty(nodeId, propertyId);
        }

        @Override
        public ArrayMap<Integer, PropertyData> getProperties(int nodeId) {
            return this.xaCon.getNeoTransaction().nodeGetProperties(nodeId);
        }

        @Override
        public Iterable<RelationshipData> getRelationships(int nodeId) {
            return this.xaCon.getNeoTransaction().nodeGetRelationships(nodeId);
        }
    }

    private static class NeoStoreXaResource
    extends XaResourceHelpImpl {
        private final Object identifier;

        NeoStoreXaResource(Object identifier, XaResourceManager xaRm, byte[] branchId) {
            super(xaRm, branchId);
            this.identifier = identifier;
        }

        public boolean isSameRM(XAResource xares) {
            if (xares instanceof NeoStoreXaResource) {
                return this.identifier.equals(((NeoStoreXaResource)xares).identifier);
            }
            return false;
        }
    }
}

