/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.nioneo.xa;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.impl.core.LockReleaser;
import org.neo4j.impl.core.PropertyIndex;
import org.neo4j.impl.nioneo.store.NeoStore;
import org.neo4j.impl.nioneo.store.PropertyStore;
import org.neo4j.impl.nioneo.store.Store;
import org.neo4j.impl.nioneo.xa.Command;
import org.neo4j.impl.nioneo.xa.NeoReadTransaction;
import org.neo4j.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.impl.nioneo.xa.NeoTransaction;
import org.neo4j.impl.persistence.IdGenerationFailedException;
import org.neo4j.impl.transaction.LockManager;
import org.neo4j.impl.transaction.xaframework.XaCommand;
import org.neo4j.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.impl.transaction.xaframework.XaConnection;
import org.neo4j.impl.transaction.xaframework.XaContainer;
import org.neo4j.impl.transaction.xaframework.XaDataSource;
import org.neo4j.impl.transaction.xaframework.XaTransaction;
import org.neo4j.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.impl.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeoStoreXaDataSource
extends XaDataSource {
    private static Logger logger = Logger.getLogger(NeoStoreXaDataSource.class.getName());
    private final NeoStore neoStore;
    private final XaContainer xaContainer;
    private final ArrayMap<Class<?>, Store> idGenerators;
    private final LockManager lockManager;
    private final LockReleaser lockReleaser;
    private final String storeDir;
    private boolean logApplied = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NeoStoreXaDataSource(Map<Object, Object> params) throws IOException, InstantiationException {
        super(params);
        this.lockManager = (LockManager)params.get(LockManager.class);
        this.lockReleaser = (LockReleaser)params.get(LockReleaser.class);
        String configFileName = (String)params.get("config");
        this.storeDir = (String)params.get("store_dir");
        Properties config = new Properties();
        if (configFileName != null) {
            FileInputStream inputStream = new FileInputStream(configFileName);
            try {
                config.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        for (Map.Entry<Object, Object> entry : params.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            config.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        String store = (String)config.get("neo_store");
        File file = new File(store);
        String create = config.getProperty("create");
        if (!file.exists() && "true".equals(create)) {
            this.autoCreatePath(store);
            NeoStore.createStore(store);
        }
        this.neoStore = new NeoStore(config);
        this.xaContainer = XaContainer.create((String)config.get("logical_log"), new CommandFactory(this.neoStore), new TransactionFactory(), params);
        this.xaContainer.openLogicalLog();
        if (!this.xaContainer.getResourceManager().hasRecoveredTransactions()) {
            this.neoStore.makeStoreOk();
        } else {
            logger.fine("Waiting for TM to take care of recovered transactions.");
        }
        this.idGenerators = new ArrayMap(5, false, false);
        this.idGenerators.put(Node.class, this.neoStore.getNodeStore());
        this.idGenerators.put(Relationship.class, this.neoStore.getRelationshipStore());
        this.idGenerators.put(RelationshipType.class, this.neoStore.getRelationshipTypeStore());
        this.idGenerators.put(PropertyStore.class, this.neoStore.getPropertyStore());
        this.idGenerators.put(PropertyIndex.class, this.neoStore.getPropertyStore().getIndexStore());
    }

    private void autoCreatePath(String store) throws IOException {
        String fileSeparator = System.getProperty("file.separator");
        int index = store.lastIndexOf(fileSeparator);
        String dirs = store.substring(0, index);
        File directories = new File(dirs);
        if (!directories.exists() && !directories.mkdirs()) {
            throw new IOException("Unable to create directory path[" + dirs + "] for Neo store.");
        }
    }

    public NeoStoreXaDataSource(String neoStoreFileName, String logicalLogPath, LockManager lockManager, LockReleaser lockReleaser) throws IOException, InstantiationException {
        super(null);
        this.lockManager = lockManager;
        this.lockReleaser = lockReleaser;
        this.storeDir = logicalLogPath;
        this.neoStore = new NeoStore(neoStoreFileName);
        this.xaContainer = XaContainer.create(logicalLogPath, new CommandFactory(this.neoStore), new TransactionFactory(), null);
        this.xaContainer.openLogicalLog();
        if (!this.xaContainer.getResourceManager().hasRecoveredTransactions()) {
            this.neoStore.makeStoreOk();
        } else {
            logger.info("Waiting for TM to take care of recovered transactions.");
        }
        this.idGenerators = new ArrayMap(5, false, false);
        this.idGenerators.put(Node.class, this.neoStore.getNodeStore());
        this.idGenerators.put(Relationship.class, this.neoStore.getRelationshipStore());
        this.idGenerators.put(RelationshipType.class, this.neoStore.getRelationshipTypeStore());
        this.idGenerators.put(PropertyStore.class, this.neoStore.getPropertyStore());
        this.idGenerators.put(PropertyIndex.class, this.neoStore.getPropertyStore().getIndexStore());
    }

    NeoStore getNeoStore() {
        return this.neoStore;
    }

    @Override
    public void close() {
        this.xaContainer.close();
        if (this.logApplied) {
            this.neoStore.rebuildIdGenerators();
            this.logApplied = false;
        }
        this.neoStore.close();
        logger.fine("NeoStore closed");
    }

    @Override
    public XaConnection getXaConnection() {
        return new NeoStoreXaConnection(this.neoStore, this.xaContainer.getResourceManager(), this.getBranchId());
    }

    public int nextId(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.nextId();
    }

    public long getHighestPossibleIdInUse(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.getHighestPossibleIdInUse();
    }

    public long getNumberOfIdsInUse(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.getNumberOfIdsInUse();
    }

    public String getStoreDir() {
        return this.storeDir;
    }

    @Override
    public void keepLogicalLogs(boolean keep) {
        this.xaContainer.getLogicalLog().setKeepLogs(keep);
    }

    @Override
    public long getCreationTime() {
        return this.neoStore.getCreationTime();
    }

    @Override
    public long getRandomIdentifier() {
        return this.neoStore.getRandomNumber();
    }

    @Override
    public long getCurrentLogVersion() {
        return this.neoStore.getVersion();
    }

    public long incrementAndGetLogVersion() {
        return this.neoStore.incrementVersion();
    }

    public void setCurrentLogVersion(long version) {
        this.neoStore.setVersion(version);
    }

    @Override
    public void applyLog(ReadableByteChannel byteChannel) throws IOException {
        this.logApplied = true;
        this.xaContainer.getLogicalLog().applyLog(byteChannel);
    }

    @Override
    public void rotateLogicalLog() throws IOException {
        this.xaContainer.getLogicalLog().rotate();
    }

    @Override
    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        return this.xaContainer.getLogicalLog().getLogicalLog(version);
    }

    @Override
    public boolean hasLogicalLog(long version) {
        return this.xaContainer.getLogicalLog().hasLogicalLog(version);
    }

    @Override
    public boolean deleteLogicalLog(long version) {
        return this.xaContainer.getLogicalLog().deleteLogicalLog(version);
    }

    @Override
    public void setAutoRotate(boolean rotate) {
        this.xaContainer.getLogicalLog().setAutoRotateLogs(rotate);
    }

    @Override
    public void setLogicalLogTargetSize(long size) {
        this.xaContainer.getLogicalLog().setLogicalLogTargetSize(size);
    }

    @Override
    public void makeBackupSlave() {
        this.xaContainer.getLogicalLog().makeBackupSlave();
    }

    NeoReadTransaction getReadOnlyTransaction() {
        return new NeoReadTransaction(this.neoStore);
    }

    private class TransactionFactory
    extends XaTransactionFactory {
        TransactionFactory() {
        }

        public XaTransaction create(int identifier) {
            return new NeoTransaction(identifier, this.getLogicalLog(), NeoStoreXaDataSource.this.neoStore, NeoStoreXaDataSource.this.lockReleaser, NeoStoreXaDataSource.this.lockManager);
        }

        public void recoveryComplete() {
            logger.fine("Recovery complete, all transactions have been resolved");
            logger.fine("Rebuilding id generators as needed. This can take a while for large stores...");
            NeoStoreXaDataSource.this.neoStore.makeStoreOk();
            logger.fine("Rebuild of id generators complete.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getCurrentVersion() {
            if (this.getLogicalLog().scanIsComplete()) {
                return NeoStoreXaDataSource.this.neoStore.getVersion();
            }
            NeoStoreXaDataSource.this.neoStore.setRecoveredStatus(true);
            try {
                long l = NeoStoreXaDataSource.this.neoStore.getVersion();
                return l;
            }
            finally {
                NeoStoreXaDataSource.this.neoStore.setRecoveredStatus(false);
            }
        }

        public long getAndSetNewVersion() {
            return NeoStoreXaDataSource.this.neoStore.incrementVersion();
        }

        public void flushAll() {
            NeoStoreXaDataSource.this.neoStore.flushAll();
        }
    }

    private static class CommandFactory
    extends XaCommandFactory {
        private NeoStore neoStore = null;

        CommandFactory(NeoStore neoStore) {
            this.neoStore = neoStore;
        }

        public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            Command command = Command.readCommand(this.neoStore, byteChannel, buffer);
            if (command != null) {
                command.setRecovered();
            }
            return command;
        }
    }
}

