/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.shell;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.regex.Pattern;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.Transaction;
import org.neo4j.impl.shell.NeoShellServer;
import org.neo4j.impl.shell.apps.Ls;
import org.neo4j.impl.shell.apps.NodeOrRelationship;
import org.neo4j.util.shell.AbstractApp;
import org.neo4j.util.shell.AppCommandParser;
import org.neo4j.util.shell.Output;
import org.neo4j.util.shell.Session;
import org.neo4j.util.shell.ShellException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NeoApp
extends AbstractApp {
    private static final String CURRENT_KEY = "CURRENT_DIR";

    protected static NodeOrRelationship getCurrent(NeoShellServer server, Session session) {
        String currentThing = (String)((Object)NeoApp.safeGet((Session)session, (String)CURRENT_KEY));
        NodeOrRelationship result = null;
        if (currentThing == null) {
            result = NodeOrRelationship.wrap(server.getNeo().getReferenceNode());
            NeoApp.setCurrent(session, result);
        } else {
            NodeOrRelationship.TypedId typedId = new NodeOrRelationship.TypedId(currentThing);
            result = NeoApp.getThingById(server, typedId);
        }
        return result;
    }

    protected NodeOrRelationship getCurrent(Session session) {
        return NeoApp.getCurrent(this.getNeoServer(), session);
    }

    protected static void setCurrent(Session session, NodeOrRelationship current) {
        NeoApp.safeSet((Session)session, (String)CURRENT_KEY, (Serializable)((Object)current.getTypedId().toString()));
    }

    protected void assertCurrentIsNode(Session session) throws ShellException {
        NodeOrRelationship current = this.getCurrent(session);
        if (!current.isNode()) {
            throw new ShellException("You must stand on a node to be able to do this");
        }
    }

    protected NeoShellServer getNeoServer() {
        return (NeoShellServer)this.getServer();
    }

    protected RelationshipType getRelationshipType(String name) {
        return new NeoAppRelationshipType(name);
    }

    protected Direction getDirection(String direction) throws ShellException {
        return this.getDirection(direction, Direction.OUTGOING);
    }

    protected Direction getDirection(String direction, Direction defaultDirection) throws ShellException {
        return (Direction)NeoApp.parseEnum(Direction.class, direction, defaultDirection);
    }

    protected static NodeOrRelationship getThingById(NeoShellServer server, NodeOrRelationship.TypedId typedId) {
        NodeOrRelationship result = null;
        result = typedId.isNode() ? NodeOrRelationship.wrap(server.getNeo().getNodeById(typedId.getId())) : NodeOrRelationship.wrap(server.getNeo().getRelationshipById(typedId.getId()));
        return result;
    }

    protected NodeOrRelationship getThingById(NodeOrRelationship.TypedId typedId) {
        return NeoApp.getThingById(this.getNeoServer(), typedId);
    }

    protected Node getNodeById(long id) {
        return this.getNeoServer().getNeo().getNodeById(id);
    }

    public final String execute(AppCommandParser parser, Session session, Output out) throws ShellException {
        Transaction tx = this.getNeoServer().getNeo().beginTx();
        try {
            String result = this.exec(parser, session, out);
            tx.success();
            String string = result;
            return string;
        }
        catch (RemoteException e) {
            throw new ShellException((Throwable)e);
        }
        finally {
            tx.finish();
        }
    }

    protected String directionAlternatives() {
        return "OUTGOING, INCOMING, o, i";
    }

    protected abstract String exec(AppCommandParser var1, Session var2, Output var3) throws ShellException, RemoteException;

    protected String getDisplayNameForCurrent(Session session) {
        NodeOrRelationship current = this.getCurrent(session);
        return current.isNode() ? "(me)" : "<me>";
    }

    public static String getDisplayName(NeoShellServer server, Session session, NodeOrRelationship thing) {
        if (thing.isNode()) {
            return NeoApp.getDisplayName(server, session, thing.asNode());
        }
        return NeoApp.getDisplayName(server, session, thing.asRelationship(), true);
    }

    public static String getDisplayName(NeoShellServer server, Session session, NodeOrRelationship.TypedId typedId) {
        return NeoApp.getDisplayName(server, session, NeoApp.getThingById(server, typedId));
    }

    public static String getDisplayName(NeoShellServer server, Session session, Node node) {
        StringBuffer result = new StringBuffer("(" + node.getId());
        String title = NeoApp.findTitle(server, session, node);
        if (title != null) {
            result.append(", " + title);
        }
        result.append(")");
        return result.toString();
    }

    private static String findTitle(NeoShellServer server, Session session, Node node) {
        String keys = (String)((Object)NeoApp.safeGet((Session)session, (String)"TITLE_KEYS"));
        if (keys == null) {
            return null;
        }
        String[] titleKeys = keys.split(Pattern.quote(","));
        Pattern[] patterns = new Pattern[titleKeys.length];
        for (int i = 0; i < titleKeys.length; ++i) {
            patterns[i] = Pattern.compile(titleKeys[i]);
        }
        for (Pattern pattern : patterns) {
            for (String nodeKey : node.getPropertyKeys()) {
                if (!NeoApp.matches(pattern, nodeKey, false, false)) continue;
                return NeoApp.trimLength(session, Ls.format(node.getProperty(nodeKey), false));
            }
        }
        return null;
    }

    private static String trimLength(Session session, String string) {
        int maxLength;
        String maxLengthString = (String)((Object)NeoApp.safeGet((Session)session, (String)"TITLE_MAX_LENGTH"));
        int n = maxLength = maxLengthString != null ? Integer.parseInt(maxLengthString) : Integer.MAX_VALUE;
        if (string.length() > maxLength) {
            string = string.substring(0, maxLength) + "...";
        }
        return string;
    }

    public static String getDisplayName(NeoShellServer server, Session session, Relationship relationship, boolean verbose) {
        StringBuffer result = new StringBuffer("<");
        if (verbose) {
            result.append(relationship.getId() + ", ");
        }
        result.append(relationship.getType().name() + ">");
        return result.toString();
    }

    protected static String fixCaseSensitivity(String string, boolean caseInsensitive) {
        return caseInsensitive ? string.toLowerCase() : string;
    }

    protected static Pattern newPattern(String pattern, boolean caseInsensitive) {
        return pattern == null ? null : Pattern.compile(NeoApp.fixCaseSensitivity(pattern, caseInsensitive));
    }

    protected static boolean matches(Pattern patternOrNull, String value, boolean caseInsensitive, boolean loose) {
        if (patternOrNull == null) {
            return true;
        }
        value = NeoApp.fixCaseSensitivity(value, caseInsensitive);
        return loose ? patternOrNull.matcher(value).find() : patternOrNull.matcher(value).matches();
    }

    protected static <T extends Enum<T>> Enum<T> parseEnum(Class<T> enumClass, String name, Enum<T> defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        name = name.toLowerCase();
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            if (!enumConstant.name().equalsIgnoreCase(name)) continue;
            return enumConstant;
        }
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            if (!enumConstant.name().toLowerCase().startsWith(name)) continue;
            return enumConstant;
        }
        throw new IllegalArgumentException("No '" + name + "' or '" + name + ".*' in " + enumClass);
    }

    private static class NeoAppRelationshipType
    implements RelationshipType {
        private String name;

        private NeoAppRelationshipType(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name();
        }
    }
}

