/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.shell;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.api.core.NeoService;
import org.neo4j.api.core.Transaction;
import org.neo4j.impl.shell.NeoApp;
import org.neo4j.impl.shell.apps.Ls;
import org.neo4j.util.shell.BashVariableInterpreter;
import org.neo4j.util.shell.Session;
import org.neo4j.util.shell.ShellServer;
import org.neo4j.util.shell.SimpleAppServer;
import org.neo4j.util.shell.apps.Help;

public class NeoShellServer
extends SimpleAppServer {
    private NeoService neo;
    private BashVariableInterpreter bashInterpreter;

    public NeoShellServer(NeoService neo) throws RemoteException {
        this.addPackage(Ls.class.getPackage().getName());
        this.neo = neo;
        this.bashInterpreter = new BashVariableInterpreter();
        this.bashInterpreter.addReplacer("W", (BashVariableInterpreter.Replacer)new WorkingDirReplacer());
        this.setProperty("PS1", (Serializable)((Object)"neo-sh \\W$ "));
        this.setProperty("TITLE_KEYS", (Serializable)((Object)".*name.*,.*title.*"));
        this.setProperty("TITLE_MAX_LENGTH", (Serializable)((Object)"40"));
    }

    public String welcome() {
        return "Welcome to NeoShell\n" + Help.getHelpString((ShellServer)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable interpretVariable(String key, Serializable value, Session session) {
        Transaction tx = this.getNeo().beginTx();
        try {
            Object result = value;
            if (key.equals("PS1")) {
                result = this.bashInterpreter.interpret((String)((Object)value), (ShellServer)this, session);
            }
            tx.success();
            Serializable serializable = result;
            return serializable;
        }
        finally {
            tx.finish();
        }
    }

    public NeoService getNeo() {
        return this.neo;
    }

    public static class WorkingDirReplacer
    implements BashVariableInterpreter.Replacer {
        public String getReplacement(ShellServer server, Session session) {
            return NeoApp.getDisplayName((NeoShellServer)server, session, NeoApp.getCurrent((NeoShellServer)server, session)).toString();
        }
    }
}

