/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.shell.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.impl.shell.NeoApp;
import org.neo4j.impl.shell.apps.NodeOrRelationship;
import org.neo4j.util.shell.AbstractApp;
import org.neo4j.util.shell.AppCommandParser;
import org.neo4j.util.shell.OptionValueType;
import org.neo4j.util.shell.Output;
import org.neo4j.util.shell.Session;
import org.neo4j.util.shell.ShellException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cd
extends NeoApp {
    public static final String WORKING_DIR_KEY = "WORKING_DIR";

    public Cd() {
        this.addValueType("a", new AbstractApp.OptionContext(OptionValueType.NONE, "Absolute id, new primitive doesn't need to be connected to the\ncurrent one"));
        this.addValueType("r", new AbstractApp.OptionContext(OptionValueType.NONE, "Makes the supplied id represent a relationship instead of a node"));
    }

    public String getDescription() {
        return "Changes the current node or relationship, i.e. traverses one step to another\nnode or relationship. Usage: cd <id>";
    }

    @Override
    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        List<NodeOrRelationship.TypedId> paths = Cd.readPaths(session);
        NodeOrRelationship current = this.getCurrent(session);
        NodeOrRelationship newThing = null;
        if (parser.arguments().isEmpty()) {
            newThing = NodeOrRelationship.wrap(this.getNeoServer().getNeo().getReferenceNode());
            paths.clear();
        } else {
            String arg = (String)parser.arguments().get(0);
            NodeOrRelationship.TypedId newId = current.getTypedId();
            if (arg.equals("..")) {
                if (paths.size() > 0) {
                    newId = paths.remove(paths.size() - 1);
                }
            } else if (!arg.equals(".")) {
                if (arg.equals("start") || arg.equals("end")) {
                    newId = this.getStartOrEnd(current, arg);
                    paths.add(current.getTypedId());
                } else {
                    long suppliedId = Long.parseLong(arg);
                    newId = parser.options().containsKey("r") ? new NodeOrRelationship.TypedId("r", suppliedId) : new NodeOrRelationship.TypedId("n", suppliedId);
                    if (newId.equals(current.getTypedId())) {
                        throw new ShellException("Can't cd to where you stand");
                    }
                    boolean absolute = parser.options().containsKey("a");
                    if (!absolute && !this.isConnected(current, newId)) {
                        throw new ShellException(Cd.getDisplayName(this.getNeoServer(), session, newId) + " isn't connected to the current primitive," + " use -a to force it to go there anyway");
                    }
                    paths.add(current.getTypedId());
                }
            }
            newThing = this.getThingById(newId);
        }
        Cd.setCurrent(session, newThing);
        session.set(WORKING_DIR_KEY, (Serializable)((Object)this.makePath(paths)));
        return null;
    }

    private NodeOrRelationship.TypedId getStartOrEnd(NodeOrRelationship current, String arg) throws ShellException {
        if (!current.isRelationship()) {
            throw new ShellException("Only allowed on relationships");
        }
        Node newNode = null;
        if (arg.equals("start")) {
            newNode = current.asRelationship().getStartNode();
        } else if (arg.equals("end")) {
            newNode = current.asRelationship().getEndNode();
        } else {
            throw new ShellException("Unknown alias '" + arg + "'");
        }
        return NodeOrRelationship.wrap(newNode).getTypedId();
    }

    private boolean isConnected(NodeOrRelationship current, NodeOrRelationship.TypedId newId) throws ShellException {
        if (current.isNode()) {
            Node currentNode = current.asNode();
            for (Relationship rel : currentNode.getRelationships()) {
                if (!(newId.isNode() ? rel.getOtherNode(currentNode).getId() == newId.getId() : rel.getId() == newId.getId())) continue;
                return true;
            }
        } else {
            if (newId.isRelationship()) {
                return false;
            }
            Relationship relationship = current.asRelationship();
            if (relationship.getStartNode().getId() == newId.getId() || relationship.getEndNode().getId() == newId.getId()) {
                return true;
            }
        }
        return false;
    }

    public static List<NodeOrRelationship.TypedId> readPaths(Session session) throws RemoteException {
        ArrayList<NodeOrRelationship.TypedId> list = new ArrayList<NodeOrRelationship.TypedId>();
        String path = (String)((Object)session.get(WORKING_DIR_KEY));
        if (path != null && path.trim().length() > 0) {
            for (String typedId : path.split(",")) {
                list.add(new NodeOrRelationship.TypedId(typedId));
            }
        }
        return list;
    }

    private String makePath(List<NodeOrRelationship.TypedId> paths) {
        StringBuffer buffer = new StringBuffer();
        for (NodeOrRelationship.TypedId typedId : paths) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(typedId.toString());
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }
}

