/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.shell.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.impl.shell.NeoApp;
import org.neo4j.util.shell.AbstractApp;
import org.neo4j.util.shell.AppCommandParser;
import org.neo4j.util.shell.OptionValueType;
import org.neo4j.util.shell.Output;
import org.neo4j.util.shell.Session;
import org.neo4j.util.shell.ShellException;

public class Mkrel
extends NeoApp {
    public Mkrel() {
        this.addValueType("t", new AbstractApp.OptionContext(OptionValueType.MUST, "The relationship type"));
        this.addValueType("n", new AbstractApp.OptionContext(OptionValueType.MUST, "The node id to connect to"));
        this.addValueType("d", new AbstractApp.OptionContext(OptionValueType.MUST, "The direction: " + this.directionAlternatives() + "."));
        this.addValueType("c", new AbstractApp.OptionContext(OptionValueType.NONE, "Supplied if there should be created a new node"));
    }

    public String getDescription() {
        return "Creates a relationship to a node";
    }

    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        this.assertCurrentIsNode(session);
        boolean createNode = parser.options().containsKey("c");
        boolean suppliedNode = parser.options().containsKey("n");
        Node node = null;
        if (createNode) {
            node = this.getNeoServer().getNeo().createNode();
        } else if (suppliedNode) {
            node = this.getNodeById(Long.parseLong((String)parser.options().get("n")));
        } else {
            throw new ShellException("Must either create node (-c) or supply node id (-n <id>)");
        }
        if (parser.options().get("t") == null) {
            throw new ShellException("Must supply relationship type (-t <relationship-type-name>)");
        }
        RelationshipType type = this.getRelationshipType((String)parser.options().get("t"));
        Direction direction = this.getDirection((String)parser.options().get("d"));
        Node currentNode = this.getCurrent(session).asNode();
        Node startNode = direction == Direction.OUTGOING ? currentNode : node;
        Node endNode = direction == Direction.OUTGOING ? node : currentNode;
        Relationship relationship = startNode.createRelationshipTo(endNode, type);
        if (createNode) {
            out.println((Serializable)((Object)("Node " + Mkrel.getDisplayName(this.getNeoServer(), session, node) + " created")));
        }
        out.println((Serializable)((Object)("Relationship " + Mkrel.getDisplayName(this.getNeoServer(), session, relationship, true) + " created")));
        return null;
    }
}

