/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.shell.apps;

import org.neo4j.impl.shell.NeoApp;
import org.neo4j.impl.shell.apps.NodeOrRelationship;
import org.neo4j.util.shell.AbstractApp;
import org.neo4j.util.shell.AppCommandParser;
import org.neo4j.util.shell.OptionValueType;
import org.neo4j.util.shell.Output;
import org.neo4j.util.shell.Session;
import org.neo4j.util.shell.ShellException;

public class Mv
extends NeoApp {
    public Mv() {
        this.addValueType("o", new AbstractApp.OptionContext(OptionValueType.NONE, "To override if the key already exists"));
    }

    public String getDescription() {
        return "Renames a property on a node or relationship. Usage: mv <key> <new-key>";
    }

    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException {
        if (parser.arguments().size() < 2) {
            throw new ShellException("Must supply <from-key> <to-key> arguments, like: mv name \"given_name\"");
        }
        String fromKey = (String)parser.arguments().get(0);
        String toKey = (String)parser.arguments().get(1);
        boolean mayOverwrite = parser.options().containsKey("o");
        NodeOrRelationship thing = this.getCurrent(session);
        if (!thing.hasProperty(fromKey)) {
            throw new ShellException("Property '" + fromKey + "' doesn't exist");
        }
        if (thing.hasProperty(toKey)) {
            if (!mayOverwrite) {
                throw new ShellException("Property '" + toKey + "' already exists, supply -o flag to overwrite");
            }
            thing.removeProperty(toKey);
        }
        Object value = thing.removeProperty(fromKey);
        thing.setProperty(toKey, value);
        return null;
    }
}

