/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.shell.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import org.neo4j.impl.shell.NeoApp;
import org.neo4j.impl.shell.apps.Cd;
import org.neo4j.impl.shell.apps.NodeOrRelationship;
import org.neo4j.util.shell.AppCommandParser;
import org.neo4j.util.shell.Output;
import org.neo4j.util.shell.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pwd
extends NeoApp {
    public String getDescription() {
        return "Prints path to current node or relatioship";
    }

    @Override
    protected String exec(AppCommandParser parser, Session session, Output out) throws RemoteException {
        NodeOrRelationship current = this.getCurrent(session);
        out.println((Serializable)((Object)("Current is " + Pwd.getDisplayName(this.getNeoServer(), session, current))));
        String path = this.stringifyPath(Cd.readPaths(session), session);
        if (path.length() > 0) {
            out.println((Serializable)((Object)path));
        }
        return null;
    }

    private String stringifyPath(List<NodeOrRelationship.TypedId> pathIds, Session session) {
        if (pathIds.isEmpty()) {
            return "";
        }
        StringBuilder path = new StringBuilder();
        for (NodeOrRelationship.TypedId id : pathIds) {
            path.append(Pwd.getDisplayName(this.getNeoServer(), session, id)).append("-->");
        }
        return path.append(this.getDisplayNameForCurrent(session)).toString();
    }
}

