/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.impl.shell.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.impl.shell.NeoApp;
import org.neo4j.impl.shell.apps.NodeOrRelationship;
import org.neo4j.util.shell.AppCommandParser;
import org.neo4j.util.shell.Output;
import org.neo4j.util.shell.Session;
import org.neo4j.util.shell.ShellException;

public class Rm
extends NeoApp {
    public String getDescription() {
        return "Removes a property from the current node or relationship.\nUsage: rm <key>";
    }

    protected String exec(AppCommandParser parser, Session session, Output out) throws ShellException {
        if (parser.arguments().isEmpty()) {
            throw new ShellException("Must supply the property key to remove, like: rm title");
        }
        try {
            String key = (String)parser.arguments().get(0);
            NodeOrRelationship thing = this.getCurrent(session);
            if (thing.removeProperty(key) == null) {
                out.println((Serializable)((Object)("Property '" + key + "' not found")));
            }
            return null;
        }
        catch (RemoteException e) {
            throw new ShellException((Throwable)e);
        }
    }
}

